/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.resourceloader;

import com.google.clearsilver.jsilver.exceptions.JSilverTemplateNotFoundException;
import com.google.clearsilver.jsilver.resourceloader.BufferedResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ClassLoaderResourceLoader
extends BufferedResourceLoader {
    private final ClassLoader classLoader;
    private String basePath;

    public ClassLoaderResourceLoader(ClassLoader classLoader, String basePath) {
        this.classLoader = classLoader;
        this.basePath = basePath;
    }

    public ClassLoaderResourceLoader(ClassLoader classLoader) {
        this(classLoader, ".");
    }

    public Reader open(String name) throws IOException {
        String path = this.basePath + '/' + name;
        InputStream stream = this.classLoader.getResourceAsStream(path);
        return stream == null ? null : this.buffer(new InputStreamReader(stream, this.getCharacterSet()));
    }

    public Reader openOrFail(String name) throws JSilverTemplateNotFoundException, IOException {
        Reader reader = this.open(name);
        if (reader == null) {
            throw new JSilverTemplateNotFoundException("No class loader resource '" + name + "' in '" + this.basePath + "'");
        }
        return reader;
    }
}

