/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeContext;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverAutoEscapingException;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.AAutoescapeCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.AContentTypeCommand;
import com.google.clearsilver.jsilver.syntax.node.ACsOpenPosition;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardLincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.AIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.Node;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.syntax.node.PPosition;
import com.google.clearsilver.jsilver.syntax.node.Start;
import com.google.clearsilver.jsilver.syntax.node.TCsOpen;
import com.google.clearsilver.jsilver.syntax.node.TString;

public class AutoEscaper
extends DepthFirstAdapter {
    private AutoEscapeContext autoEscapeContext;
    private boolean skipAutoEscape;
    private final EscapeMode escapeMode;
    private final String templateName;
    private boolean contentTypeCalled;

    public AutoEscaper(EscapeMode mode, String templateName) {
        this.templateName = templateName;
        if (mode.equals((Object)EscapeMode.ESCAPE_NONE)) {
            throw new JSilverAutoEscapingException("AutoEscaper called when no escaping is required", templateName);
        }
        this.escapeMode = mode;
        if (mode.isAutoEscapingMode()) {
            this.autoEscapeContext = new AutoEscapeContext(mode, templateName);
            this.skipAutoEscape = false;
        } else {
            this.autoEscapeContext = null;
        }
    }

    public AutoEscaper(EscapeMode mode) {
        this(mode, null);
    }

    public void caseStart(Start start) {
        if (!this.escapeMode.isAutoEscapingMode()) {
            this.handleExplicitEscapeMode(start);
        } else {
            AutoEscapeContext.AutoEscapeState startState = this.autoEscapeContext.getCurrentState();
            super.caseStart(start);
            AutoEscapeContext.AutoEscapeState endState = this.autoEscapeContext.getCurrentState();
            if (!this.autoEscapeContext.isPermittedStateChangeForIncludes(startState, endState)) {
                if (this.contentTypeCalled) {
                    return;
                }
                throw new JSilverAutoEscapingException("Template starts in context " + (Object)((Object)startState) + " but ends in different context " + (Object)((Object)endState), this.templateName);
            }
        }
    }

    private void handleExplicitEscapeMode(Start start) {
        AStringExpression escapeExpr = new AStringExpression(new TString("\"" + this.escapeMode.getEscapeCommand() + "\""));
        PCommand node = start.getPCommand();
        AEscapeCommand escape = new AEscapeCommand(new ACsOpenPosition(new TCsOpen("<?cs ", 0, 0)), escapeExpr, (PCommand)node.clone());
        node.replaceBy(escape);
    }

    public void caseADataCommand(ADataCommand node) {
        String data = node.getData().getText();
        this.autoEscapeContext.setCurrentPosition(node.getData().getLine(), node.getData().getPos());
        this.autoEscapeContext.parseData(data);
    }

    public void caseADefCommand(ADefCommand node) {
    }

    public void caseAIfCommand(AIfCommand node) {
        AutoEscapeContext.AutoEscapeState elseEndState;
        this.setCurrentPosition(node.getPosition());
        AutoEscapeContext originalEscapedContext = this.autoEscapeContext.cloneCurrentEscapeContext();
        int line = this.autoEscapeContext.getLineNumber();
        int column = this.autoEscapeContext.getColumnNumber();
        if (node.getBlock() != null) {
            node.getBlock().apply(this);
        }
        AutoEscapeContext.AutoEscapeState ifEndState = this.autoEscapeContext.getCurrentState();
        this.autoEscapeContext = originalEscapedContext;
        if (node.getOtherwise() != null) {
            node.getOtherwise().apply(this);
        }
        if (!ifEndState.equals((Object)(elseEndState = this.autoEscapeContext.getCurrentState()))) {
            throw new JSilverAutoEscapingException("'if/else' branches have different ending contexts " + (Object)((Object)ifEndState) + " and " + (Object)((Object)elseEndState), this.templateName, line, column);
        }
    }

    public void caseAEscapeCommand(AEscapeCommand node) {
        boolean saved_skip = this.skipAutoEscape;
        this.skipAutoEscape = true;
        node.getCommand().apply(this);
        this.skipAutoEscape = saved_skip;
    }

    public void caseACallCommand(ACallCommand node) {
        this.saveAutoEscapingContext(node, node.getPosition());
    }

    public void caseALvarCommand(ALvarCommand node) {
        this.saveAutoEscapingContext(node, node.getPosition());
    }

    public void caseAEvarCommand(AEvarCommand node) {
        this.saveAutoEscapingContext(node, node.getPosition());
    }

    public void caseALincludeCommand(ALincludeCommand node) {
        this.saveAutoEscapingContext(node, node.getPosition());
    }

    public void caseAIncludeCommand(AIncludeCommand node) {
        this.saveAutoEscapingContext(node, node.getPosition());
    }

    public void caseAHardLincludeCommand(AHardLincludeCommand node) {
        this.saveAutoEscapingContext(node, node.getPosition());
    }

    public void caseAHardIncludeCommand(AHardIncludeCommand node) {
        this.saveAutoEscapingContext(node, node.getPosition());
    }

    public void caseAVarCommand(AVarCommand node) {
        this.applyAutoEscaping(node, node.getPosition());
    }

    public void caseAAltCommand(AAltCommand node) {
        this.applyAutoEscaping(node, node.getPosition());
    }

    public void caseANameCommand(ANameCommand node) {
        this.applyAutoEscaping(node, node.getPosition());
    }

    public void caseAUvarCommand(AUvarCommand node) {
        this.setCurrentPosition(node.getPosition());
        this.autoEscapeContext.insertText();
    }

    public void caseAContentTypeCommand(AContentTypeCommand node) {
        this.setCurrentPosition(node.getPosition());
        String contentType = node.getString().getText();
        contentType = contentType.substring(1, contentType.length() - 1);
        this.autoEscapeContext.setContentType(contentType);
        this.contentTypeCalled = true;
    }

    private void applyAutoEscaping(PCommand node, PPosition position) {
        this.setCurrentPosition(position);
        if (this.skipAutoEscape) {
            return;
        }
        AStringExpression escapeExpr = new AStringExpression(new TString("\"" + this.getEscaping() + "\""));
        AEscapeCommand escape = new AEscapeCommand(position, escapeExpr, (PCommand)node.clone());
        node.replaceBy(escape);
        this.autoEscapeContext.insertText();
    }

    private void setCurrentPosition(PPosition position) {
        position.apply(this);
    }

    public void caseACsOpenPosition(ACsOpenPosition node) {
        TCsOpen token = node.getCsOpen();
        this.autoEscapeContext.setCurrentPosition(token.getLine(), token.getPos());
    }

    private void saveAutoEscapingContext(Node node, PPosition position) {
        this.setCurrentPosition(position);
        if (this.skipAutoEscape) {
            return;
        }
        EscapeMode mode = this.autoEscapeContext.getEscapeModeForCurrentState();
        AStringExpression escapeStrategy = new AStringExpression(new TString("\"" + mode.getEscapeCommand() + "\""));
        AAutoescapeCommand command = new AAutoescapeCommand(position, escapeStrategy, (PCommand)node.clone());
        node.replaceBy(command);
        this.autoEscapeContext.insertText();
    }

    private String getEscaping() {
        return this.autoEscapeContext.getEscapingFunctionForCurrentState();
    }
}

