/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEachCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AHardLincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.AIncludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALincludeCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopIncCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopToCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.AWithCommand;
import com.google.clearsilver.jsilver.syntax.node.EOF;
import com.google.clearsilver.jsilver.syntax.node.TData;
import java.util.ArrayList;
import java.util.List;

public class DataCommandConsolidator
extends DepthFirstAdapter {
    private int currentBlockNestingLevel = 0;
    private final List<ADataCommand> datas = new ArrayList<ADataCommand>();
    private int datasBlockNestingLevel = -1;

    private void barrier() {
        if (this.datas.size() > 1) {
            ADataCommand last = this.datas.remove(this.datas.size() - 1);
            StringBuilder sb = new StringBuilder();
            for (ADataCommand data : this.datas) {
                sb.append(data.getData().getText());
                data.replaceBy(null);
            }
            sb.append(last.getData().getText());
            last.replaceBy(new ADataCommand(new TData(sb.toString())));
        }
        this.datas.clear();
        this.datasBlockNestingLevel = -1;
    }

    private void blockEntry() {
        assert (this.datasBlockNestingLevel <= this.currentBlockNestingLevel);
        ++this.currentBlockNestingLevel;
    }

    private void blockExit() {
        assert (this.datasBlockNestingLevel <= this.currentBlockNestingLevel);
        if (this.datasBlockNestingLevel == this.currentBlockNestingLevel) {
            this.barrier();
        }
        --this.currentBlockNestingLevel;
    }

    public void caseADataCommand(ADataCommand node) {
        assert (this.datasBlockNestingLevel <= this.currentBlockNestingLevel);
        if (this.currentBlockNestingLevel != this.datasBlockNestingLevel) {
            this.barrier();
        }
        this.datas.add(node);
        this.datasBlockNestingLevel = this.currentBlockNestingLevel;
    }

    public void inAVarCommand(AVarCommand node) {
        this.barrier();
    }

    public void inALvarCommand(ALvarCommand node) {
        this.barrier();
    }

    public void inAUvarCommand(AUvarCommand node) {
        this.barrier();
    }

    public void inAEvarCommand(AEvarCommand node) {
        this.barrier();
    }

    public void inANameCommand(ANameCommand node) {
        this.barrier();
    }

    public void inALoopCommand(ALoopCommand node) {
        this.blockEntry();
    }

    public void inALoopIncCommand(ALoopIncCommand node) {
        this.blockEntry();
    }

    public void inALoopToCommand(ALoopToCommand node) {
        this.blockEntry();
    }

    public void inAEachCommand(AEachCommand node) {
        this.blockEntry();
    }

    public void inAWithCommand(AWithCommand node) {
        this.blockEntry();
    }

    public void outALoopCommand(ALoopCommand node) {
        this.blockExit();
    }

    public void outALoopIncCommand(ALoopIncCommand node) {
        this.blockExit();
    }

    public void outALoopToCommand(ALoopToCommand node) {
        this.blockExit();
    }

    public void outAEachCommand(AEachCommand node) {
        this.blockExit();
    }

    public void outAWithCommand(AWithCommand node) {
        this.blockExit();
    }

    public void caseADefCommand(ADefCommand node) {
        DataCommandConsolidator consolidator = new DataCommandConsolidator();
        node.getCommand().apply(consolidator);
        consolidator.barrier();
    }

    public void inACallCommand(ACallCommand node) {
        this.barrier();
    }

    public void caseAIfCommand(AIfCommand node) {
        if (node.getBlock() != null) {
            this.blockEntry();
            node.getBlock().apply(this);
            this.blockExit();
        }
        if (node.getOtherwise() != null) {
            this.blockEntry();
            node.getOtherwise().apply(this);
            this.blockExit();
        }
    }

    public void inAAltCommand(AAltCommand node) {
        this.blockEntry();
    }

    public void outAAltCommand(AAltCommand node) {
        this.blockExit();
    }

    public void caseAIncludeCommand(AIncludeCommand node) {
        this.barrier();
    }

    public void caseAHardIncludeCommand(AHardIncludeCommand node) {
        this.barrier();
    }

    public void caseALincludeCommand(ALincludeCommand node) {
        this.barrier();
    }

    public void caseAHardLincludeCommand(AHardLincludeCommand node) {
        this.barrier();
    }

    public void caseEOF(EOF node) {
        this.barrier();
    }
}

