/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.template;

import java.io.IOException;

public class HtmlWhiteSpaceStripper
implements Appendable {
    private final Appendable out;
    private final int level;
    private boolean nonWsSeen = false;
    private char pendingWs = '\u0000';
    private boolean startHtmlTag = false;
    private boolean inOpenTag = false;
    private boolean inCloseTag = false;
    private boolean inTagName = false;
    private int textAreaScope = 0;
    private int preScope = 0;
    private int verbatimScope = 0;
    private int scriptScope = 0;
    private StringBuilder tagName = new StringBuilder(16);

    public HtmlWhiteSpaceStripper(Appendable out) {
        this(out, 1);
    }

    public HtmlWhiteSpaceStripper(Appendable out, int level) {
        this.out = out;
        this.level = level;
    }

    public String toString() {
        return this.out.toString();
    }

    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    public Appendable append(char c) throws IOException {
        if (this.inOpenTag || this.inCloseTag) {
            if (this.startHtmlTag) {
                if (c == '/') {
                    this.inOpenTag = false;
                    this.inCloseTag = true;
                } else {
                    this.startHtmlTag = false;
                    if (this.isTagNameStartChar(c)) {
                        this.inTagName = true;
                        this.tagName.append(c);
                    }
                }
            } else if (this.inTagName) {
                if (this.isTagNameChar(c)) {
                    this.tagName.append(c);
                } else {
                    this.processTagName();
                    this.inTagName = false;
                }
            }
            if (c == '>') {
                this.inCloseTag = false;
                this.inOpenTag = false;
                this.nonWsSeen = true;
            }
            this.stripLeadingWsAndEmptyLines(c);
        } else {
            if (c == '<') {
                this.inOpenTag = true;
                this.startHtmlTag = true;
            }
            if (this.preScope > 0 || this.verbatimScope > 0 || this.textAreaScope > 0) {
                this.out.append(c);
            } else if (this.scriptScope > 0) {
                this.stripLeadingWsAndEmptyLines(c);
            } else {
                this.stripAll(c);
            }
        }
        return this;
    }

    private void stripLeadingWsAndEmptyLines(char c) throws IOException {
        switch (c) {
            case '\n': {
                if (this.nonWsSeen) {
                    this.out.append(c);
                }
                this.nonWsSeen = false;
                break;
            }
            case '\t': 
            case '\r': 
            case ' ': {
                if (!this.nonWsSeen) break;
                this.out.append(c);
                break;
            }
            default: {
                if (!this.nonWsSeen) {
                    this.nonWsSeen = true;
                }
                this.out.append(c);
            }
        }
    }

    private void stripAll(char c) throws IOException {
        switch (c) {
            case '\n': {
                if (this.nonWsSeen) {
                    this.out.append(c);
                }
                this.pendingWs = '\u0000';
                this.nonWsSeen = false;
                break;
            }
            case '\t': 
            case '\r': 
            case ' ': {
                if (!this.nonWsSeen) break;
                this.pendingWs = c;
                break;
            }
            default: {
                if (this.pendingWs != '\u0000') {
                    this.out.append(this.pendingWs);
                    this.pendingWs = '\u0000';
                }
                this.nonWsSeen = true;
                this.out.append(c);
            }
        }
    }

    private int updateScope(int current, int inc) {
        return (current += inc) < 0 ? 0 : current;
    }

    private void processTagName() {
        int inc;
        this.inTagName = false;
        String name = this.tagName.toString();
        this.tagName.delete(0, this.tagName.length());
        int n = inc = this.inOpenTag ? 1 : -1;
        if ("textarea".equalsIgnoreCase(name)) {
            this.textAreaScope = this.updateScope(this.textAreaScope, inc);
        } else if ("pre".equalsIgnoreCase(name)) {
            this.preScope = this.updateScope(this.preScope, inc);
        } else if ("verbatim".equalsIgnoreCase(name)) {
            this.verbatimScope = this.updateScope(this.verbatimScope, inc);
        } else if ("script".equalsIgnoreCase(name)) {
            this.scriptScope = this.updateScope(this.scriptScope, inc);
        }
    }

    private boolean isTagNameStartChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private boolean isTagNameChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '-' || c == ':' || c == '.';
    }

    private boolean isWs(char c) {
        return c == ' ' || c == '\t' || c == '\r';
    }
}

