/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.ClassInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.Converter;
import com.google.doclava.DocInfo;
import com.google.doclava.Errors;
import com.google.doclava.SinceTagger;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageInfo
extends DocInfo
implements ContainerInfo {
    public static final String DEFAULT_PACKAGE = "default package";
    public static final Comparator<PackageInfo> comparator = new Comparator<PackageInfo>(){

        @Override
        public int compare(PackageInfo a, PackageInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    private String mName;
    private PackageDoc mPackage;
    private ClassInfo[] mAnnotations;
    private ClassInfo[] mInterfaces;
    private ClassInfo[] mOrdinaryClasses;
    private ClassInfo[] mEnums;
    private ClassInfo[] mExceptions;
    private ClassInfo[] mErrors;
    private HashMap<String, ClassInfo> mClasses = new HashMap();

    public PackageInfo(PackageDoc pkg, String name, SourcePositionInfo position) {
        super(pkg.getRawCommentText(), position);
        this.mName = PackageInfo.isEmpty(name) ? DEFAULT_PACKAGE : name;
        this.mPackage = pkg;
    }

    public PackageInfo(String name) {
        super("", null);
        this.mName = name;
    }

    public PackageInfo(String name, SourcePositionInfo position) {
        super("", position);
        this.mName = PackageInfo.isEmpty(name) ? DEFAULT_PACKAGE : name;
    }

    @Override
    public boolean isDefinedLocally() {
        return true;
    }

    @Override
    public String relativePath() {
        String s = this.mName;
        s = s.replace('.', '/');
        s = s + "/package-summary.html";
        return s;
    }

    public String fullDescriptionFile() {
        String s = this.mName;
        s = s.replace('.', '/');
        s = s + "/package-descr.html";
        return s;
    }

    public String fullDescriptionHtmlPage() {
        return this.htmlPage().replace("/package-summary.html", "/package-descr.html");
    }

    @Override
    public ContainerInfo parent() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return this.comment().isHidden();
    }

    @Override
    public boolean checkLevel() {
        return !this.isHidden();
    }

    public String name() {
        return this.mName;
    }

    @Override
    public String qualifiedName() {
        return this.mName;
    }

    public TagInfo[] inlineTags() {
        return this.comment().tags();
    }

    public TagInfo[] firstSentenceTags() {
        return this.comment().briefTags();
    }

    public static ClassInfo[] filterHidden(ClassInfo[] classes) {
        ArrayList<ClassInfo> out = new ArrayList<ClassInfo>();
        for (ClassInfo cl : classes) {
            if (cl.isHidden()) continue;
            out.add(cl);
        }
        return out.toArray(new ClassInfo[0]);
    }

    public void makeLink(Data data, String base) {
        if (this.checkLevel()) {
            data.setValue(base + ".link", this.htmlPage());
        }
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
    }

    public void makeClassLinkListHDF(Data data, String base) {
        this.makeLink(data, base);
        ClassInfo.makeLinkListHDF(data, base + ".annotations", this.getAnnotations());
        ClassInfo.makeLinkListHDF(data, base + ".interfaces", this.getInterfaces());
        ClassInfo.makeLinkListHDF(data, base + ".classes", this.ordinaryClasses());
        ClassInfo.makeLinkListHDF(data, base + ".enums", this.enums());
        ClassInfo.makeLinkListHDF(data, base + ".exceptions", this.exceptions());
        ClassInfo.makeLinkListHDF(data, base + ".errors", this.errors());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
    }

    public ClassInfo[] getAnnotations() {
        if (this.mAnnotations == null) {
            this.mAnnotations = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses((ClassDoc[])this.mPackage.annotationTypes())));
        }
        return this.mAnnotations;
    }

    public ClassInfo[] getInterfaces() {
        if (this.mInterfaces == null) {
            this.mInterfaces = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.interfaces())));
        }
        return this.mInterfaces;
    }

    public ClassInfo[] ordinaryClasses() {
        if (this.mOrdinaryClasses == null) {
            this.mOrdinaryClasses = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.ordinaryClasses())));
        }
        return this.mOrdinaryClasses;
    }

    public ClassInfo[] enums() {
        if (this.mEnums == null) {
            this.mEnums = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.enums())));
        }
        return this.mEnums;
    }

    public ClassInfo[] exceptions() {
        if (this.mExceptions == null) {
            this.mExceptions = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.exceptions())));
        }
        return this.mExceptions;
    }

    public ClassInfo[] errors() {
        if (this.mErrors == null) {
            this.mErrors = ClassInfo.sortByName(PackageInfo.filterHidden(Converter.convertClasses(this.mPackage.errors())));
        }
        return this.mErrors;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public void addClass(ClassInfo cl) {
        this.mClasses.put(cl.name(), cl);
    }

    public HashMap<String, ClassInfo> allClasses() {
        return this.mClasses;
    }

    public boolean isConsistent(PackageInfo pInfo) {
        boolean consistent = true;
        for (ClassInfo cInfo : this.mClasses.values()) {
            if (pInfo.mClasses.containsKey(cInfo.name())) {
                if (cInfo.isConsistent(pInfo.mClasses.get(cInfo.name()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_CLASS, cInfo.position(), "Removed public class " + cInfo.qualifiedName());
            consistent = false;
        }
        for (ClassInfo cInfo : pInfo.mClasses.values()) {
            if (this.mClasses.containsKey(cInfo.name())) continue;
            Errors.error(Errors.ADDED_CLASS, cInfo.position(), "Added class " + cInfo.name() + " to package " + pInfo.name());
            consistent = false;
        }
        return consistent;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

