=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: xhtml output logic, flow

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: tidy -xml scroll.xhtml >> index.tidy
=end
module SiSU_XHTML #XML_SAX derivative
  require SiSU_lib + '/defaults'
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  require SiSU_lib + '/sysenv'
  include SiSU_Env
  require SiSU_lib + '/shared_xml'
  require SiSU_lib + '/xml_format'
  include SiSU_XML_format
  include SiSU_XML_character
  require SiSU_lib + '/rexml'
  include SiSU_Rexml
  @@alt_id_count=0
  @@tablehead=0
  @@tablefoot=''
  @@number_of_cols=0
  class Source
    def initialize(opt)
      @opt=opt
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @env=SiSU_Env::Info_env.new(@opt.fns)
        path=@env.path.output_tell
        loc=@env.url.output_tell
        tool=if @opt.cmd =~/[MV]/; "#{@env.program.web_browser} #{loc}/#{@md.fnb}/#{@md.fn[:xhtml]}\n\t#{@env.program.xml_viewer} #{path}/#{@md.fnb}/#{@md.fn[:xhtml]}"
        elsif @opt.cmd =~/v/; "#{@env.program.web_browser} #{loc}/#{@md.fnb}/#{@md.fn[:xhtml]}"
        else ''
        end
        SiSU_Screen::Ansi.new(@opt.cmd,'invert','XHTML',tool).colorize unless @opt.cmd =~/q/
        SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output_tell}/#{@md.fnb}/#{@md.fn[:xhtml]}").flow if @opt.cmd =~/[MV]/
        my_make=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns)
        @metaverse_array=SiSU_Metaverse::Source.new(@opt).get # metaverse file drawn here
        SiSU_XHTML::Source::Songsheet.new(@md,@metaverse_array,@env).songsheet
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        #file closed in songsheet
      end
    end
    class Songsheet
      def initialize(md,data,dir)
        @md,@data,@env=md,data,dir
      end
      def songsheet
        begin
          SiSU_XHTML::Source::Scroll.new(@md,@data).songsheet
          SiSU_XHTML::Source::Tidy.new(@md,@env).xml if @md.cmd =~/[vVM]/ # test wellformedness, comment out when not in use
          SiSU_Rexml::Rexml.new(@md,@md.fn[:xhtml]).xml if @md.cmd =~/M/ # test rexml parsing, comment out when not in use #debug
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        ensure
        end
      end
    end
    class Scroll
      @@xml={ :body=>[],:sisu=>[],:open=>[],:close=>[],:head=>[] }
      require SiSU_lib + '/shared_txt'
      require SiSU_lib + '/css'
      include SiSU_text_utils
      @@dp=nil
      def initialize(md=nil,data='')
        @md,@data=md,data
        @margin=SiSU_Viz::Margin.new
        @@dp ||=SiSU_Env::Info_env.new.digest.pattern
        @regx=/^(?:(?:<:p[nb]>\s*)?\d~(?:(\S+))?\s+)?(.+?)\s*<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>$/
        @tab="\t"
        @env=SiSU_Env::Info_env.new(@md.fns)
        @char_enc=SiSU_XML_character::Encode.new
        @sys=SiSU_Env::System_call.new
      end
      def songsheet
        pre
        markup
        post
        publish
      end
    protected
      def embedded_endntoes(para='')
        para.gsub!(/~\{(\d+)\s+(.+?)\s*<#{@@dp}>\}~/, 
          '<endnote><number>\1</number><note>\2</note></endnote> ')
        para.gsub!(/~\[([*+]\d+)\s+(.+?)\s*<#{@@dp}>\]~/, 
          '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
        para.gsub!(/~\{([*+]+)\s+(.+?)\s*<#{@@dp}>\}~/, 
          '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
      end
      def extract_endnotes(para='')
        notes=para.scan(/~[{\[]([\d*+]+\s+.+?)\s*<#{@@dp}>[}\]]~/)
        notes.each do |e| 
          s=e.to_s
          util=SiSU_text_utils::Wrap.new(s,70)
          wrap=util.line_wrap
          wrap.gsub!(/^(\d+)\s+(.+?)\s*\Z/m, <<WOK
#{@tab*1}<endnote notenumber="\\1">
#{@tab*2}\\1. \\2
#{@tab*1}</endnote>
WOK
) 
          wrap.gsub!(/^([*+]\d+)\s+(.+?)\s*\Z/m, <<WOK
#{@tab*1}<endnote symbol="\\1">
#{@tab*2}\\1 \\2
#{@tab*1}</endnote>
WOK
) 
          wrap.gsub!(/^([*+]+)\s+(.+?)\s*\Z/m, <<WOK
#{@tab*1}<endnote symbol="\\1.length">
#{@tab*2}\\1 \\2
#{@tab*1}</endnote>
WOK
) 
#KEEP alternative presentation of endnotes
#        wrap.gsub!(/^(\d+)\s+(.+?)\s*\Z/m, <<WOK
##{@tab*1}<p class="endnote" notenumber="\\1">
##{@tab*2}\\1. \\2
##{@tab*1}</p>
#WOK
#) 
          @endnotes << wrap
        end
      end
      def xml_head(meta)
        txt=meta.text
        txt.gsub!(/<br(?: \/)?>/,'')
        txt.gsub!(/ & /,' and ')
        @@xml[:head] <<= if meta.type == 'meta'
          <<WOK
#{@tab}<#{meta.el} class="#{meta.attrib}">
#{@tab*2}#{txt}
#{@tab}</#{meta.el}>
WOK
        else ''
        end
      end
      def xml_structure_ee(para='',lv='',ocn='',hname='') #embedded endnotes
        lv=lv.to_i
        n=lv - 1
        n3=lv + 2
        lv=nil if lv == 0
        embedded_endnotes(para)
        if para[@regx]
          paragraph="#{para[@regx,2]}"
          util=SiSU_text_utils::Wrap.new(paragraph,70)
          wrapped=util.line_wrap
        end
        @@xml[:body] << "#{@tab*0}<object>" << "\n" if para[@regx] 
        @@xml[:body] << "#{@tab*1}<ocn>#{para[@regx,3]}</ocn>" << "\n" if para[@regx,3]
        @@xml[:body] << if lv; %{#{@tab*1}<text class="h#{lv}">#{wrapped}</text>\n} << "\n" 
        else                   %{#{@tab*1}<text class="norm">#{wrapped}</text>\n} # main text, contents, body KEEP
        end
        ##@@xml[:body] << "#{@tab*1}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # old unwrapped main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" if para[@regx]
      end
      def xml_structure(para='',lv='',ocn='',hname='') #extracted endnotes
        lv=lv.to_i
        n=lv - 1
        n3=lv + 2
        lv=nil if lv == 0
        extract_endnotes(para)
        #puts @endnotes
        para.gsub!(/~[{\[]([\d*+]+)\s+(?:.+?)\s*<#{@@dp}>[}\]]~/,'<en>\1</en>') #footnote/endnote clean
        if para[@regx]
          paragraph="#{para[@regx,2]}"
          util=SiSU_text_utils::Wrap.new(paragraph,70)
          wrapped=util.line_wrap
        end
        @@xml[:body] << if para[@regx,3]; %{#{@tab*0}<object id="#{para[@regx,3]}">} << "\n" 
        else                              "#{@tab*0}<object>" << "\n" if para[@regx] 
        end
        #@@xml[:body] << "#{@tab*0}<object>" << "\n" if para[@regx] 
        #@@xml[:body] << "#{@tab*1}<heading>#{lv}</heading>" << "\n" if lv
        @@xml[:body] << %{#{@tab*1}<text class="norm">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n} unless lv  # main text, contents, body KEEP
        @@xml[:body] << %{#{@tab*1}<text class="h#{lv}">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n}  << "\n" if lv # main text, contents, body KEEP
        #@@xml[:body] << %{#{@tab*1}<text heading="#{lv}">\n} << "\n" if lv
        @@xml[:body] << "#{@endnotes}" if @endnotes # main text, endnotes KEEP
        @@xml[:body] << "#{@tab*1}<ocn>#{para[@regx,3]}</ocn>" << "\n" if para[@regx,3]
        ##@@xml[:body] << "#{@tab*1}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # old unwrapped main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" if para[@regx]
        @endnotes=[]
      end
      def group_structure(para='',ocn='')
        para.gsub!(/<:group(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="group">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def poem_structure(para='',ocn='')
        para.gsub!(/<:verse(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="verse">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def code_structure(para='',ocn='')
        para.gsub!(/<:code(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="code">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def table_structure(table='',ocn='') #tables
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n" #if para[@regx] 
        @@xml[:body] << %{#{@tab*1}#{table}\n#{@tab*1}\n} # unless lv  # main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" #if para[@regx]
        @endnotes=[]
      end
      def tidywords(wordlist)
        wordlist.each do |x|
          x.gsub!(/&/,'&amp;') unless x =~/&\S+;/
        end
      end
      def markup
        data=@data
        dir=SiSU_Env::Info_env.new(@md.fns)
        @endnotes=[]
        @rcdc=false
        @level,@cont,@copen,@xml_contents_close=[],[],[],[]
        (0..6).each { |x| @cont[x]=@level[x]=false } 
        (4..6).each { |x| @xml_contents_close[x]='' } 
        data.each do |para|
          para.gsub!(/<:pb>\s*/,'')
          para.gsub!(/<[-~]#>/,'')
          para.gsub!(/<0;\w\d+;[um]\d+><#{@@dp}:#{@@dp}>/,'')
          para.gsub!(/\{(\S+?\.(?:png|jpg|gif)) .+?\}(?:(?:https?|ftp):\/\/\S+|image)/, 
            "<image.path>#{dir.url.images_local}\/\\1</image.path>")
          para.gsub!(/&nbsp;/,' ')
          wordlist=para.scan(/\S+|\n/) #\n needed for tables, check though added 2005w17
          #wordlist=para.scan(/\S+/)
          para=tidywords(wordlist).join(' ').strip
          @char_enc.utf8(para) if @sys.locale =~/utf-?8/i #% utf8
          if para =~/^0~(\S+)\s+(.+?)$/ # for headers
            d_meta=SiSU_text_utils::Header_scan.new(@md,para).meta
            if d_meta; xml_head(d_meta)
	          end
	        end
          @rcdc=true if @rcdc==false and (para =~/~metadata/ or para =~/1~\s+Document Information/)
          if para !~/(^0~|<ENDNOTES>|<EOF>)/ 
            if para =~/.+?<~\d+;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>.*/
              paranum=para[@regx,3]  #/.+?<~(\d+?)>.*/.match(para)[1]
              @p_num=SiSU_XML_format::Paragraph_number.new(@md,paranum)
            end
            @sto=SiSU_text_parts::Split_text_object.new(@md,para).lev_segname_para_ocn
            ### problem in scroll, it appears tables are getting paragraph numbers
            unless @rcdc
              m=/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
              if para =~m
                format_scroll=SiSU_XML_format::Format_scroll.new(@md,@sto.text) if @sto.format =~/i[12]|null/
                case @sto.format
                when /^(1)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body1
                when /^(2)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body2
                when /^(3)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body3
                when /^(4)~(\S+)/ # work on see SiSU_text_parts::Split_text_object
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body4
                when /^(5)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body5
                when /^(6)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body6
                #when /^(i1)$/i
                #  #format_scroll.gsubBody
                #  #para=@sto[:lev_para_ocn].scrIndent1
                #when /^(i2)$/i
                #  format_scroll.gsubBody
                #  para=@sto[:lev_para_ocn].scrIndent2
                #when /^(center)$/i
                #  para.gsub!(/(.+)/,
                #    %{<center>(\\1)</center>})
                #  para=@sto[:lev_para_ocn].scrPara
                #when /^(b|bold)$/i
                #  para.gsub!(/(.+)/,
                #    %{<b>(\\1)</b>})
                #  para=@sto[:lev_para_ocn].scrPara
                #when /null/ # see whether u can improve
                #    if (para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/)
                #      #format_scroll.gsubBody
                #      #para=@sto[:lev_para_ocn].scrPara
                #    end
                else
                  matched=/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>$/mi.match(para)
                  stamp,ocn=matched[0],matched[1]
                  if para =~ /<:verse>/
                    para.gsub!(/#{stamp}/,'')
                    poem_structure(para,ocn)
                  elsif para =~ /<:group>/
                    para.gsub!(/#{stamp}/,'')
                    group_structure(para,ocn)
                  elsif para =~ /<:code>/
                    para.gsub!(/</,'&lt;')
                    para.gsub!(/>/,'&gt;')
                    para.gsub!(/#{stamp}/,'')
                    code_structure(para,ocn)
                  elsif para =~/<!Th?.+/ # tables come as single block #work area 2005w13
                    table=SiSU_Tables::Table_xml.new(para,ocn)
                    para=table.table_split
                    table_structure(para,ocn)
                  else
                    xml_structure(para,nil,nil,nil)
                  end
                  #@@xml[:body] << "#{@tab*6}<object>" << "\n" if para[@regx]
                  #@@xml[:body] << "#{@tab*7}<ocn>#{para[@regx,3]}</ocn>" << "\n" if para[@regx,3]
                  #@@xml[:body] << "#{@tab*7}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # main text, contents, body KEEP
                  #@@xml[:body] << "#{@tab*6}</object>" << "\n" if para[@regx]
                end
              elsif para =~/(Note|Endnotes?)/ and para !~/<~\d+;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
              elsif para =~/(MetaData)/ and para =~/<~(\d+);[m]\d+;\w\d+><#{@@dp}:#{@@dp}>/ #debug 2003w46 add rc info
                format_scroll=Format_scroll.new(@md,'<br /><a name="metadata">MetaData</a>')
                para=format_scroll.bold_para
              elsif para =~/(Owner Details)/ and para !~/<~\d+;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
                format_scroll=Format_scroll.new(@md,'<br /><a name="owner.details">Owner Details</a>')
                @@xml[:owner_details]=format_scroll.bold_para
                para=''
              elsif para =~/(.*)<:#>(.*)/
                one,two=$1,$2
                format_text=Format_text_object.new(one,two)
                para=format_text.seg_no_paranum
              end
              para='' if (para =~/<a name="n\d+">/ and para =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/) # -endnote
              para=case para
              when /<:i1>/
                if para =~/.*<:#>.*$/
                  format_text=Format_text_object.new(para,'')
                  format_text.scr_inden_ocn_e_no_paranum
                end
              when /<:i2>/
                if para =~/.*<:#>.*$/
                  format_text=Format_text_object.new(para,'')
                  format_text.scr_inden_ocn_e_no_paranum
                end
              else para
              end
              if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
                # i don't get the condition for no paranum
              end
              if para =~/<:center>/
                one,two=/(.*)<:center>(.*)/.match(para)[1,2]
                format_text=Format_text_object.new(one,two)
                para=format_text.center
              end
            else #
            end
            para.gsub!(/<:\S+?>/,'') if para ## Clean Prepared Text #bugwatch reinstate
            para.gsub!(/<!.+!>/,'') if para ## Clean Prepared Text #bugwatch reinstate
          end
        end
        6.downto(4) do |x|
          y=x - 1; v=x - 3
          @@xml[:body] << "#{@tab*5}</content>\n#{@tab*y}</contents#{v}>\n" if @level[x] == true
        end
        3.downto(1) do |x|
          y=x - 1
          @@xml[:body] << "#{@tab*y}</heading#{x}>\n" if @level[x] == true
        end
        #6.downto(1) { |x| y=x - 1; @@xml[:body] << "#{@tab*y}</level #{x}>\n" if @level[x] == true } 
      end
      def pre
        rdf=SiSU_XML_tags::RDF.new(@md)
        dir=SiSU_Env::Info_env.new
        #<?xml version="1.0"?>
        #<?xml version="1.0" encoding="UTF-8" standalone="no"?>
        #<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>
        #<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
        #<?xml version="1.0" encoding="UTF-8" standalone="no"?>
        #<?xml version="1.0" encoding="UTF-16" standalone="no"?>
        @@xml[:head],@@xml[:body]=[],[] #added
        css=SiSU_Env::CSS_select.new(@md).xhtml
        encoding=if @sys.locale =~/utf-?8/i #% utf8
          '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'
        else
          '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        end
        @@xml[:open] =<<WOK
#{encoding}
<?xml-stylesheet type="text/css" href="../#{@env.path.style}/#{css}"?>
#{rdf.comment_xml}
<document>
WOK
        @@xml[:head] << %{<head>\n\t<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\n}
        @@xml[:body] << "<body>\n"
      end
      def post
        @@xml[:head] << "</head>\n"
        @@xml[:body] << "</body>\n"
        @@xml[:close] = "</document>\n"
      end
      def publish
        content=[]
        data=@data
        content << @@xml[:open] << @@xml[:head] << @@xml[:body] << @@xml[:metadata]
        content << @@xml[:owner_details] if @md.stmp =~/\w\w/
        content << @@xml[:tail] << @@xml[:close]
        Output.new(@md,content.to_s).xml
        @@xml={} # check whether should be nil
      end
    end
    class Output
      include SiSU_Param
      include SiSU_Env
      def initialize(md,data)
        @md,@data=md,data
      end
      def xml
        @sisu=[]
        @data.each do |para|
          #para.strip!
          para.gsub!(/<:\S+?>/,'')
          para.gsub!(/<!.+?!>/,'')
          para="#{para}\n" unless para.empty?
          @sisu << para
        end
        new_file_data=@sisu.to_s
        @sisu=new_file_data.scan(/.+/)
        filename_plaintext=SiSU_Env::SiSU_file.new(@md).mkdir
        filename_xml=SiSU_Env::SiSU_file.new(@md,@md.fn[:xhtml]).mkfile
        @sisu.each {|para| filename_xml.puts para}
        filename_xml.close
      end
    end
    class Tidy
      def initialize(md,dir)
        @md,@env=md,dir
        @prog=SiSU_Env::Info_program.new #(md.fns) #if md
      end
      def xml
        if @prog.tidy !=false
          if @md.cmd =~/[VM]/
            tell=SiSU_Screen::Ansi.new(@md.cmd,'invert','Using XML Tidy','check document structure')
            tell.colorize unless @md.cmd =~/q/
            tell.grey_open unless @md.cmd =~/q/
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy=SiSU_Env::System_call.new("#{@env.path.output}/#{@md.fnb}/#{@md.fn[:xhtml]}",tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.cmd =~/q/
          end
        end
      end
    end
  end
end
__END__
