# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/cgi.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: generates naive cgi search form for search of sisu database
    (pgsql sqlite)

=end
module  SiSU_CGI                                        #% database building documents
  require_relative 'se'                                 # se.rb
  require_relative 'cgi_pgsql'                          # cgi_pgsql.rb
  require_relative 'cgi_sqlite'                         # cgi_sqlite.rb
  class SearchSQL
    def initialize(opt)
      @opt=opt
      @webserv=@opt.files[0].to_s.strip
    end
    def read
      if @opt.act[:sample_search_form][:db]==:pg        # cgi_pgsql.rb
        SiSU_CGI_PgSQL::SearchPgSQL.new(@opt,@webserv).pgsql
      elsif @opt.act[:sample_search_form][:db]==:sqlite # cgi_sqlite.rb
        SiSU_CGI_SQLite::SearchSQLite.new(@opt,@webserv).sqlite
      else
        puts <<-WOK
  please select database type for which sample search form should be built (pgsql or sqlite)
    sisu --sample-search-form --db=sqlite
    sisu --sample-search-form --db=pg
  other options include
     --webserv-cgi='[cgi-server-name]'
     --webserv-output='[sisu-output-server-with-base-path]'
        WOK
      end
    end
  end
end
__END__
