<?php
/******************************************************************************
 *  SiteBar 3 - The Bookmark Server for Personal and Team Use.                *
 *  Copyright (C) 2003,2004  Ondrej Brablc <http://brablc.com/mailto?o>       *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
 ******************************************************************************/

require_once('./inc/errorhandler.inc.php');
require_once('./inc/page.inc.php');

$um = null;

// If we have configuration and can load database class using it
if (file_exists('./inc/config.inc.php') && @include_once('./inc/database.inc.php'))
{
    $db = Database::staticInstance(true);
    if ($db->connection)
    {
        require_once('./inc/usermanager.inc.php');
        $um = new UserManager();
        Skin::set($um->getParam('user','skin'));
    }
}

if (isset($_REQUEST['install']))
{
    $install = $_REQUEST['install'];

    $code     = '{3F218DFB-00FF-297C-4D54-57696C4A6F6F}';
    $title    = 'SiteBar';
    $url      = Page::baseurl().'/sitebar.php';
    $reg      = '';
    $filename = '';
    $ctxUrl   = Page::baseurl() . "/ctxmenu.php";

    require_once('./inc/converter.inc.php');

    $charsetKey = 'Charset in MS Windows';
    $c = new Converter(!$um || $um->getParam('config','use_conv_engine'),
        (T($charsetKey)==$charsetKey?null:T($charsetKey)));

    $addLink = $c->fromUTF8(T("Add Link to SiteBar"));
    $addPage = $c->fromUTF8(T("Add Page to SiteBar"));

    if ($install)
    {
        $filename = "InstallSiteBar.reg";

        $reg = <<<__INSTALL
REGEDIT4

[HKEY_CLASSES_ROOT\\CLSID\\$code]
@="$title"

[HKEY_CLASSES_ROOT\\CLSID\\$code\\Implemented Categories]

[HKEY_CLASSES_ROOT\\CLSID\\$code\\Implemented Categories\\{00021493-0000-0000-C000-000000000046}]

[HKEY_CLASSES_ROOT\\CLSID\\$code\\InProcServer32]
@="Shdocvw.dll"
"ThreadingModel"="Apartment"

[HKEY_CLASSES_ROOT\\CLSID\\$code\\Instance]
"CLSID"="{4D5C8C2A-D075-11d0-B416-00C04FB90376}"

[HKEY_CLASSES_ROOT\\CLSID\\$code\\Instance\\InitPropertyBag]
"Url"="$url"

[-HKEY_CLASSES_ROOT\\Component Categories\\{00021493-0000-0000-C000-000000000046}\\Enum]

[-HKEY_CLASSES_ROOT\\Component Categories\\{00021494-0000-0000-C000-000000000046}\\Enum]

[HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\Explorer Bars\\$code]
"BarSize"=hex:B4
"Name"="$title"

[HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\$addLink]
"Contexts"=dword:00000022
"Flags"=hex:01
@="$ctxUrl?add=link"

[HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\$addPage]
"Contexts"=hex:01
"Flags"=hex:01
@="$ctxUrl?add=page"

[HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Internet Explorer\\Extensions\\{23F5C49C-74DF-42BA-A194-FF92A3B59FED}]
"ButtonText" = "SiteBar"
"MenuText" = "SiteBar Panel"
"MenuStatusBar"="Display SiteBar Panel"
"Icon" = "%SystemRoot%\\\\system32\\\\SHELL32.dll,173"
"HotIcon" = "%SystemRoot%\\\\system32\\\\SHELL32.dll,173"
"CLSID" = "{E0DD6CAB-2D10-11D2-8F1A-0000F87ABD16}"
"BandCLSID" = "$code"
"Default Visible"="Yes"
__INSTALL;
    }
    else
    {
        $filename = "UnInstallSiteBar.reg";
        $reg = <<<__UNINSTALL
REGEDIT4

[-HKEY_CLASSES_ROOT\\CLSID\\$code]
[-HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\Explorer Bars\\$code]
[-HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Internet Explorer\\Extensions\\{23F5C49C-74DF-42BA-A194-FF92A3B59FED}]
[-HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\Add Link to SiteBar]
[-HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\Add Page to SiteBar]
[-HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\$addLink]
[-HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\$addPage]
__UNINSTALL;
    }

    header("Content-type: application/octet-stream\n");
    header("Content-disposition: attachment; filename=\"$filename\"\n");
    header("Content-transfer-encoding: binary\n");
    header('Content-length: ' . strlen($reg));
    echo $reg;

    exit;
}

Page::head("The Bookmark Server for Personal and Team Use", "index");

// Include skin hook file
include_once(Skin::path().'/hook.php');

$bookmarklet = "w=window;if(w.content){w=w.content};d=w.document;cp=d.characterSet?d.characterSet:d.charset;".
    "w.open('" . Page::baseurl() . "/command.php?command=Add%20Link".
    "&amp;name='+escape(d.title)+'&amp;url='+escape(w.location.href)+(cp?'&amp;cp='+cp:''),'sbBmkWin',".
    "'resizable=yes,dependent=yes,width=210,height=360,top=200,left=300,titlebar=yes,scrollbars=yes');void(0)";

$popup = "javascript:void(window.open('".Page::baseurl()."/sitebar.php" .
    "?target=_blank','sbPopWin',".
    "'directories=no,height=600,width=220,left=0,top=0,scrollbars=yes,location=no,menubar=no, status=no, toolbar=no'))";

?>

<script type="text/javascript">
    function compatible(is, label)
    {
        document.write("<span class='compatible"+ (is?"Yes":"No") +"'>");
        document.write(label);
        document.write("<\/span>");
    }
</script>

<div id="launcher">

  <div>
    <div id="home">
      <a href="http://www.sitebar.org/"><img alt="<?php echo T('SiteBar Homepage')?>" src="<?php echo Skin::imgsrc('logo')?>"></a>
      <br>
      [<a href="http://www.sitebar.org/"><?php echo T('SiteBar Homepage')?></a>]
    </div>

    <div id="tip"><?php echo P('index::tip')?></div>
  </div>

  <div>

    <h2><?php echo T('SiteBar Installation & Launcher')?></h2>

    <table>
      <tr>
        <th><span class='compatibleYes'><?php echo T('Any Browser')?></span></th>
      </tr>
      <tr><td><?php echo P('index::any_browser', array(Page::baseurl(), $popup))?></td></tr>
      <tr>
        <th>
            <script type="text/javascript">
                compatible(window.ActiveXObject && navigator.platform == 'Win32', "Internet Explorer 5+")
            </script>
        </th>
      </tr>
      <tr><td><?php echo P('index::ie_install')?></td></tr>
      <tr><td><?php echo P('index::ie_search', array(Page::baseurl()))?></td></tr>
      <tr>
        <th>
            <script type="text/javascript">
                compatible(window.sidebar && window.sidebar.addPanel, "Mozilla 1+ / Netscape 6+")
            </script>
        </th>
      </tr>
      <tr><td><?php echo P('index::mozilla', array(Page::baseurl(),Page::baseurl(),Page::baseurl()))?></td></tr>
      <tr>
        <th>
            <script type="text/javascript">
                compatible(window.opera && window.print, "Opera 6+")
            </script>
        </th>
      </tr>
      <tr><td><?php echo P('index::opera', array(Page::baseurl()))?></td></tr>
      <tr>
        <th>
            <script type="text/javascript">
                compatible(window.external && window.external.tab_count, "MyIE2")
            </script>
        </th>
      </tr>
      <tr><td><?php echo P('index::myie2_install', array(Page::baseurl(),Page::baseurl()))?></td></tr>
    </table>

    <h2><?php echo T('Content Bookmarklets')?></h2>

    <table>
      <tr>
        <th><?php echo T('Bookmarklet')?></th>
      </tr>
      <tr><td><?php echo P('index::bookmarklet', array($bookmarklet))?></td></tr>
    </table>

    <table class='sponsor'>
      <tr>
        <td><?php  Hook::sponsor() ?></td>
      </tr>
    </table>

  </div>
</div>

<div id="trailer">
    <?php echo P('index::copyright2') ?>
</div>

<?php
Page::foot();
?>
