/* Public domain. */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>
#include "bytestr.h"
#include "webipc.h"

int ipc_accept (int s, char *p, int l, int *trunc)
{
  struct sockaddr_un sa ;
  int dummy = sizeof sa ;
  register int fd ;
  byte_zero((char*)&sa, (unsigned int)dummy) ;
  do
    fd = accept(s, (struct sockaddr *)&sa, &dummy) ;
  while ((fd == -1) && (errno == EINTR)) ;
  if (fd == -1) return -1 ;

  if (p)
  {
    dummy = byte_chr(sa.sun_path, dummy, 0) ;
    *trunc = 1 ;
    if (!l) return fd ;
    if (l < (dummy + 1)) dummy = l - 1 ;
    else *trunc = 0 ;
    byte_copy(p, dummy, sa.sun_path) ;
    p[dummy] = 0 ;
  }
  return fd ;
}
