# unannotation.awk: filter to remove annotations in dictionaries.
#
# Maintainer: SKK Development Team <skk@ring.gr.jp>
# Version: $Id: unannotation.awk,v 1.2 2000/11/27 04:31:34 minakaji Exp $
# Last Modified: $Date: 2000/11/27 04:31:34 $
BEGIN{
    print ";; -*- text -*-";
    ctime = myctime(0);
    this = ARGV[1];
    if (match(this, "\.annotated$") != 0){
	this = substr(this, 1, RSTART - 1);
    } else
	this = this ".unannotated";
    printf(";; %s was generated automatically by unannotation.awk at %s\n",
	   this, ctime);
    getline modeindicator
    if (match(modeindicator, /;; -*- text -*-/) != 0){
	print modeindicator;
    }
}
#$0 !~ /"^;; -\*- text -\*-\n"/{
{
    if (match($0, /^;/) == 0) {
	gsub(";[^/]*/", "/");
    }
    print;
}
function myctime(ts,    format) {
    format = "%a %b %e %H:%M:%S %Y";
    if (ts == 0)
	ts = systime();         # use current time as default
    return strftime(format, ts);
}
# end of unannotation.awk.
