/* # skkinput (Simple Kana-Kanji Input)
 * OffWin.c --- Making OffTheSpotWinWidget.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "OffWinP.h"
#include "config.h"
#include "skkkey.h"
#include "skkel.h"
#include "Canvas.h"
#include "WmcloseShell.h"
#include "MyError.h"
#include "FontMgr.h"
#include "draw.h"
#include "MyDispatch.h"

#ifndef XtNgeometry
#define XtNgeometry		"geometry"
#define XtCGeometry		"Geometry"
#endif

#define offset(field) XtOffsetOf( OffthespotWinRec, offthespotWin.field)
#define goffset(field) XtOffsetOf( WidgetRec, core.field )

static XtResource OFFW_resources[] = {
  /* Ȥ餢꥽*/
  { XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
    goffset(width), XtRImmediate, (XtPointer) 400},
  { XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
    goffset(height), XtRImmediate, (XtPointer) 400},
  /* ߥ˥Хåե礭ꤹġǥեȤΤ͡١ꥵ *
   * Ф褦ˤ褦 */
  { XtNmwidth, XtCMwidth, XtRDimension, sizeof(Dimension),
    offset(minibuf_width), XtRImmediate, (XtPointer)640 },
  /* ʬȤǺä꥽*/
  { XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
    offset(puppixel), XtRString, XtDefaultForeground },
  /* Minibuffer ȿžɽ뤫ɤȤäˤʤ롣*/
  { XtNreverseVideo, XtCReverseVideo, XtRBoolean, sizeof (Boolean),
    offset(reverse_video), XtRImmediate, (XtPointer) FALSE},
  /* offthespot Ѥեȵڤӥ޻եȡ*/
  { XtNfontset, XtCFontset,  XtRString, sizeof( String ),
    offset(fontset_string), XtRImmediate, (XtPointer)DEFAULT_FONTSET },
  /* Minibuffer Window 褹ΤѤڤӥ޻եȡ*/
  { XtNmfontset, XtCFontset,  XtRString, sizeof( String ),
    offset(minibuf_fontset_string), XtRImmediate, DEFAULT_FONTSET },
  /* Minibuffer Window 礭եȤν˺뤫ɤ*/
  { XtNchangeMinibufferFont, XtCChangeMinibufferFont,
    XtRBoolean, sizeof ( Boolean ),
    offset(change_minibuffer_font), XtRImmediate, (XtPointer)TRUE },
  /* skkinput 뤬ĤѤ callback */
  { XtNendNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(endcallback), XtRCallback, (caddr_t)NULL },
  /* skkinput  client ʸѤ callback */
  { XtNfixNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(fixcallback), XtRCallback, (caddr_t)NULL },
  /* key event  client ֤Ѥ callback */
  { XtNkeybackNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(keybackcallback), XtRCallback, (caddr_t)NULL },
  /* egg ߴ j-newline ݤ*/
  { XtNeggLikeNewline, XtCEggLikeNewline, XtRImmediate, sizeof( Boolean ),
    XtOffsetOf( OffthespotWinRec, offthespotWin.buffer.egg_like_newline ),
    XtRImmediate, (XtPointer) FALSE},
  /* chat-adapter-mode ݤ*/
  { XtNchatAdapter, XtCChatAdapter, XtRImmediate, sizeof( Boolean ),
    XtOffsetOf( OffthespotWinRec, offthespotWin.buffer.chat_adapter ),
    XtRImmediate, (XtPointer) FALSE},
  { XtNjisyoDirty, XtCJisyoDirty, XtRImmediate, sizeof( Boolean ),
    XtOffsetOf( OffthespotWinRec, offthespotWin.buffer.jisyo_dirty ),
    XtRImmediate, (XtPointer) FALSE },
  { XtNconversionAttribute, XtCConversionAttribute, XtRImmediate, 
    sizeof( struct ConvAttrsMesg * ),
    offset( camsg ), XtRImmediate, ( XtPointer )NULL },
  /* ߥ˥Хåեξõ롣*/
  { XtNclearMinibuffer, XtCClearMinibuffer, XtRImmediate, sizeof( Boolean ),
    offset( clearMinibuffer ), XtRImmediate, (XtPointer)FALSE },
  /* ¦ɽġ*/
  { XtNsouthCursor, XtCSouthCursor, XtRBoolean, sizeof( Boolean ),
    offset( south_cursor ), XtRImmediate, ( XtPointer )FALSE },
  { XtNclientWindow, XtCClientWindow, XtRImmediate, sizeof( Window ),
    offset( client_window ), XtRImmediate, (XtPointer)None },
  { XtNsetFocus, XtCSetFocus, XtRImmediate, sizeof( int ),
    offset( conversion_set_focus ), XtRImmediate, (XtPointer)FALSE },
  { XtNunsetFocus, XtCUnsetFocus, XtRImmediate, sizeof( int ),
    offset( conversion_unset_focus ), XtRImmediate, (XtPointer)FALSE },
  /* Subwindow ե֤ɥꤹ롣*/
  { XtNprobeWindow, XtCProbeWindow, XtRImmediate, sizeof( Window ),
    offset( probe_window ), XtRImmediate, ( XtPointer )None },
  /* history νѤؿ*/
  { XtNconversionHistory, XtCConversionHistory, XtRImmediate,
    sizeof( HistoryListNode * ), offset( historyAttribute ),
    XtRImmediate, ( XtPointer )NULL },
  { XtNoverTheSpotLikeInput, XtCOverTheSpotLikeInput, XtRBoolean,
    sizeof( Boolean ), offset( overthespotLikeInput ),
    XtRImmediate, ( XtPointer )TRUE },
  { XtNshiftHaTugiDeYukou, XtCShiftHaTugiDeYukou, XtRBoolean,
    sizeof( Boolean ), 
    XtOffsetOf( OffthespotWinRec, offthespotWin.buffer.toggleShiftMode ),
    XtRImmediate, ( XtPointer )FALSE },
  { XtNcontrolHaTugiDeYukou, XtCControlHaTugiDeYukou, XtRBoolean,
    sizeof( Boolean ), 
    XtOffsetOf( OffthespotWinRec, offthespotWin.buffer.toggleControlMode ),
    XtRImmediate, ( XtPointer )FALSE },
} ;

#undef offset
#undef goffset

/*
 * ץȥ
 */
/*
 * ΥåȤƤǤȤʤؿ
 */
static void OFFW_Initialize
( Widget greq, Widget gnew, ArgList args, Cardinal *num_args ) ;
static void OFFW_Realize
( Widget gw, XtValueMask *valueMask, XSetWindowAttributes *attrs ) ;
static void OFFW_Redisplay
( Widget gw, XEvent *event, Region region ) ;
static void OFFW_Destroy( Widget gw ) ;
static Boolean OFFW_SetValues
( Widget current, Widget request, Widget new,
  ArgList args, Cardinal *num_args ) ;
static void KeyDownEventHandler
( Widget w, XEvent *event, String *params, Cardinal *num_params ) ;
static void FocusEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params ) ;

static void OFFW_CreateAllGCs( Widget gw ) ;
static void OFFW_CreateMinibufferGCs( Widget gw ) ;
static void OFFW_ReleaseAllGCs( Widget gw ) ;
static void OFFW_ReleaseMinibufferGCs( Widget gw ) ;

static int OFFW_ChangeAttributes
( Widget gw, unsigned long valuemask, struct ConvAttrs *values ) ;
static void OFFW_resetupModeWindow( Widget gw ) ;
static void OFFW_ReconfigureColor
( Widget gw, unsigned long valuemask ) ;

static void OFFW_ConfigureMinibuffer( Widget gw ) ;

static void OFFW_RedrawScreen( Widget gw ) ;
static int OFFW_ReconfigureFocusPosition
( Widget gw ) ;

static int focusCheck( Widget gw ) ;
/*
 * callbacks
 */
static void Canvas_Redisplay
( Widget gw, Window win ) ;
static void Minibuffer_RedisplayCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void Modeshell_Redisplay
( Widget gw, Window win ) ;
static void Modeshell_Display
( Widget gw, Window win ) ;
static void Canvas_DestroyCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void OFFW_wmMessageCloseCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void OFFW_wmShellDestroyCallback
( Widget gw, caddr_t client, caddr_t caller ) ;

/* common style */
extern void skkinput_bufferInit( struct skkinputBuffer *buffer ) ;
extern int commonKeyEventHandler
( Widget gw, XEvent *xevent, struct skkinputBuffer *buffer ) ;
extern void force_keyboard_quit
( Widget gw, struct skkinputBuffer *buffer ) ;

/*
 * Хѿ
 */
static XtActionsRec offthespotWinActionsTable [] = {
  { "KeyDownEventHandler",	   KeyDownEventHandler },
  { "FocusInEventHandler",	   FocusEventHandler },
  { "FocusOutEventHandler",	   FocusEventHandler },
};

static char defaultOffthespotWinTranslations[] =  
"<Key>:                   KeyDownEventHandler()\n\
 <FocusIn>:               FocusInEventHandler()\n\
 <FocusOut>:              FocusOutEventHandler()\n" ;

OffthespotWinClassRec offthespotWinClassRec = {
    { /* core fields */
    /* superclass		*/	&widgetClassRec,
    /* class_name		*/	"Offthespot",
    /* size			*/	sizeof( OffthespotWinRec ),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	OFFW_Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	OFFW_Realize,
    /* actions			*/	offthespotWinActionsTable,
    /* num_actions		*/	XtNumber( offthespotWinActionsTable ),
    /* resources		*/	OFFW_resources,
    /* num_resources		*/	XtNumber( OFFW_resources ),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	OFFW_Destroy,
    /* resize			*/	NULL,
    /* expose			*/	OFFW_Redisplay,
    /* set_values		*/	OFFW_SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultOffthespotWinTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    }
};

WidgetClass offthespotWinWidgetClass =
( WidgetClass )&offthespotWinClassRec ;

static void OFFW_InitializeHistory( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;

  if( w->offthespotWin.historyAttribute == NULL ){
    return ;
  }
  /* ꤷȤСġ*/
  if( w->offthespotWin.historyAttribute->overthespot_like_input < 0 ){
    /* X Resource ¦ꤹ롣*/
    w->offthespotWin.buffer.overthespot_like_input = 
      w->offthespotWin.overthespotLikeInput ;
  } else {
    /* ήѤ롣*/
    w->offthespotWin.buffer.overthespot_like_input = 
      w->offthespotWin.historyAttribute->overthespot_like_input ;
  }
  /* ҥȥν򤹤롣*/
  w->offthespotWin.buffer.historybuffer =
    w->offthespotWin.historyAttribute->history ;
  w->offthespotWin.buffer.hist_start = 
    w->offthespotWin.historyAttribute->history_start ;
  w->offthespotWin.buffer.hist_end = 
    w->offthespotWin.historyAttribute->history_end ;
  w->offthespotWin.buffer.histcurbackbuffer =
    w->offthespotWin.historyAttribute->histcurbak ;
  w->offthespotWin.buffer.hist_cur = -1 ;
  
  /* ϥ⡼ɤν򤹤롣*/
  w->offthespotWin.buffer.chat_adapter =
    w->offthespotWin.historyAttribute->chat_adapter ;
  w->offthespotWin.buffer.egg_like_newline =
    w->offthespotWin.historyAttribute->egg_nl ;
  
  /* ̾⡼ɤν򤹤롣*/
  w->offthespotWin.buffer.topbuffer->j_mode =
    w->offthespotWin.historyAttribute->j_mode ;
  w->offthespotWin.buffer.topbuffer->j_zenkaku =
    w->offthespotWin.historyAttribute->j_zenkaku ;
  w->offthespotWin.buffer.topbuffer->j_katakana_mode =
    w->offthespotWin.historyAttribute->j_katakana_mode ;
  return ;
}

static void OFFW_Initialize 
( Widget greq, Widget gnew, ArgList args, Cardinal *num_args )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gnew ;
  int i ;

  /* ե٥åɽΤ GC 롣*/
  w->offthespotWin.background = w->core.background_pixel ;
  w->offthespotWin.foreground = w->offthespotWin.puppixel ;
  w->offthespotWin.colormap   = w->core.colormap ;
  w->offthespotWin.oforeground = w->offthespotWin.foreground ;
  w->offthespotWin.obackground = w->offthespotWin.background ;
  
  /* եȥåȤ롣*/
  for( i = 0 ; i < NUMBER_OF_CHARSET ; i ++ ){
    w->offthespotWin.fontset[ i ] = NULL ;
    w->offthespotWin.minibuf_fontset[ i ] = NULL ;
  }
  w->offthespotWin.gc = w->offthespotWin.rgc = NULL ;
  w->offthespotWin.minibuf_gc = w->offthespotWin.minibuf_rgc = NULL ;

  /* ǥեȤΥեȤꤹ롣*/
  fontMgr_copyDefaultFontSet
    ( XtDisplay( gnew ), w->offthespotWin.fontset ) ;
  fontMgr_copyDefaultMinibufFontSet
    ( XtDisplay( gnew ), w->offthespotWin.minibuf_fontset ) ;
  /* ǥեȤΥեȤξȴФƤ*/
  fontMgr_GetFontSetInfo
    ( w->offthespotWin.fontset, 
      &w->offthespotWin.font_height, &w->offthespotWin.font_ascent ) ;
  fontMgr_GetFontSetInfo
    ( w->offthespotWin.minibuf_fontset, 
      &w->offthespotWin.mfont_height, &w->offthespotWin.mfont_ascent ) ;

  /* ԽѤΥХåեγݡ*/
  skkinput_bufferInit( &( w->offthespotWin.buffer ) ) ;
  /*w->offthespotWin.buffer.overthespot_like_input = True ;*/
  w->offthespotWin.buffer.redraw = OFFW_RedrawScreen ;

  /* ޤFocus ϺǽϳƤȻפ衣*/
  w->offthespotWin.is_focus = False ;

  /* Off-the-spot Window ȤƵǽ뤿ɬפѿν*/
  w->offthespotWin.focus_window  = None ;
  w->offthespotWin.input_focus_window = None ;
  w->offthespotWin.spot_x = w->offthespotWin.spot_y = 0 ;
  w->offthespotWin.focus_offset_x =
    w->offthespotWin.focus_offset_y = 0 ;
  /* Ѵ饤Ȥɽΰν򤷤Ƥ*/
  w->offthespotWin.client_area.x = 
    w->offthespotWin.client_area.y = 0 ;
  w->offthespotWin.client_area.height = 
    w->offthespotWin.client_area.width = 0 ;
  /* ơΰνԤ*/
  w->offthespotWin.status_area.x =
    w->offthespotWin.status_area.y = 0 ;
  w->offthespotWin.status_area.height = 
    w->offthespotWin.status_area.width = 0 ;

  /* ХåեȤɽ뤿˻ȤɥõƤ*/
  w->offthespotWin.canvas_probe = False ;
  w->offthespotWin.minibuffer_probe = False ;
  w->offthespotWin.modeshell_probe = False ;

  w->offthespotWin.attribute_mask = 0L ;
  /* 礭ꡣ*/
  w->offthespotWin.cursor_width = 8 ;
  /* history ν򤹤롣*/
  OFFW_InitializeHistory( gnew ) ;

  w->offthespotWin.modeshell_win =
    w->offthespotWin.canvas_win = None ;
  w->offthespotWin.modeshell_width = w->offthespotWin.modeshell_height = 1 ;
  w->offthespotWin.modeshell_border_width = 2 ;
  return ;
}

static void OFFW_ReleaseAllGCs( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  if( w->offthespotWin.gc != NULL )
    XFreeGC( XtDisplay( gw ), w->offthespotWin.gc ) ;
  if( w->offthespotWin.rgc != NULL )
    XFreeGC( XtDisplay( gw ), w->offthespotWin.rgc ) ;
  w->offthespotWin.gc = w->offthespotWin.rgc = NULL ;
  return ;
}

static void OFFW_ReleaseMinibufferGCs( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  if( w->offthespotWin.minibuf_gc != NULL )
    XFreeGC( XtDisplay( gw ), w->offthespotWin.minibuf_gc ) ;
  if( w->offthespotWin.minibuf_rgc != NULL )
    XFreeGC( XtDisplay( gw ), w->offthespotWin.minibuf_rgc ) ;
  w->offthespotWin.minibuf_gc = w->offthespotWin.minibuf_rgc = NULL ;
  return ;
}

static void OFFW_FreeFontSet( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  int i ;

  for( i = 0 ; i < NUMBER_OF_CHARSET ; i ++ ){
    fontMgr_FreeFont
      ( XtDisplay( gw ), w->offthespotWin.fontset[ i ] ) ;
    fontMgr_FreeFont
      ( XtDisplay( gw ), w->offthespotWin.minibuf_fontset[ i ] ) ;
    w->offthespotWin.fontset[ i ] = 
      w->offthespotWin.minibuf_fontset[ i ] = NULL ;
  }
  return ;
}

static void OFFW_CreateAllGCs( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  XGCValues gcvalues ;

  gcvalues.foreground = w->offthespotWin.oforeground ;
  gcvalues.background = w->offthespotWin.obackground ;
  w->offthespotWin.gc = XCreateGC
    ( XtDisplay( gw ), w->offthespotWin.focus_window,
      GCForeground | GCBackground, &gcvalues ) ;

  gcvalues.background = w->offthespotWin.oforeground ;
  gcvalues.foreground = w->offthespotWin.obackground ;
  w->offthespotWin.rgc = XCreateGC
    ( XtDisplay( gw ), w->offthespotWin.focus_window,
      GCForeground | GCBackground, &gcvalues ) ;
  return ;
}

static void OFFW_CreateMinibufferGCs( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  XGCValues gcvalues ;

  gcvalues.foreground = w->offthespotWin.foreground ;
  gcvalues.background = w->offthespotWin.background ;
  w->offthespotWin.minibuf_gc = XCreateGC
    ( XtDisplay( gw ), XtWindow( w->offthespotWin.minibuffer_canvas ),
      GCForeground | GCBackground, &gcvalues ) ;

  gcvalues.background = w->offthespotWin.foreground ;
  gcvalues.foreground = w->offthespotWin.background ;
  w->offthespotWin.minibuf_rgc = XCreateGC
    ( XtDisplay( gw ), XtWindow( w->offthespotWin.minibuffer_canvas ),
      GCForeground | GCBackground, &gcvalues ) ;
  return ;
}

static Window OFFW_CreateSubCanvas
( Widget gw, Window focus_window, int *probe, int border_width )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  Window win ;

  if( border_width <= 0 ){
    win = XCreateSimpleWindow
      ( XtDisplay( gw ), focus_window, 0, 0, 1, 1, 0,
	w->offthespotWin.obackground,
	w->offthespotWin.obackground ) ;
  } else {
    win = XCreateSimpleWindow
      ( XtDisplay( gw ), focus_window, 0, 0, 1, 1, border_width,
	w->offthespotWin.oforeground,
	w->offthespotWin.obackground ) ;
  }
  add_myeventhandler
    ( XtDisplay( gw ), win, XtWindow( gw ), Expose, ExposureMask ) ;
  add_myeventhandler
    ( XtDisplay( gw ), win, XtWindow( gw ), KeyPress, KeyPressMask ) ;
  add_myeventhandler
    ( XtDisplay( gw ), win, XtWindow( gw ), KeyRelease, KeyReleaseMask ) ;
  add_myeventhandler
    ( XtDisplay( gw ), win, XtWindow( gw ), DestroyNotify, SubstructureNotifyMask ) ;
  /* ϤΤɬפˤʤޤǤϡmap ʤ*/
  *probe = False ;
  return win ;
}

/*
 * ߥ˥ХåեβΤ˸ƤӽФؿ
 */
static void OFFW_RealizeMinibuffer( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  Widget minibuffer_popup, minibuffer_canvas ;
  XSizeHints sizehints ;
  unsigned int winwidth, winheight, font_height ;

  winwidth  = w->offthespotWin.minibuf_width ;
  if( w->offthespotWin.change_minibuffer_font ){
    winheight   = w->offthespotWin.font_height ;
    font_height = w->offthespotWin.font_height ;
  } else {
    winheight   = w->offthespotWin.mfont_height ;
    font_height = w->offthespotWin.mfont_height ;
  }
  minibuffer_popup = XtVaCreatePopupShell
    ( "minibuffer", wmcloseShellWidgetClass, gw, XtNinput, TRUE, 
      XtNmappedWhenManaged, TRUE, 
      XtNwidth, winwidth, XtNheight, winheight, 
      XtNcolormap, gw->core.colormap, 
      XtNreverseVideo, w->offthespotWin.reverse_video,
      XtNbackground, w->offthespotWin.background,
      XtNforeground, w->offthespotWin.foreground, NULL ) ;
  XtAddCallback
    ( minibuffer_popup, XtNwmcloseNotify, 
      ( XtCallbackProc )OFFW_wmMessageCloseCallback, gw ) ;
  XtAddCallback
    ( minibuffer_popup, XtNdestroyNotify, 
      ( XtCallbackProc )OFFW_wmShellDestroyCallback, gw ) ;

  /* βˤĤɽѤ widget 롣shellwidget ľ *
   * ܽ񤤤ƤϤޤäȤΤǡġ*/
  minibuffer_canvas = XtVaCreateManagedWidget
    ( "canvas", canvasWidgetClass, minibuffer_popup,
      XtNreverseVideo, w->offthespotWin.reverse_video,
      XtNbackground, w->offthespotWin.background,
      XtNforeground, w->offthespotWin.foreground, NULL ) ;
  w->offthespotWin.minibuffer_probe = False ;
  /* 襤٥ȤåäƤ*/
  XtAddCallback
    ( minibuffer_canvas, XtNredrawNotify,
      ( XtCallbackProc )Minibuffer_RedisplayCallback, gw ) ;
  XtAddCallback
    ( minibuffer_canvas, XtNdestroyNotify, 
      ( XtCallbackProc )Canvas_DestroyCallback, gw ) ;

  /* ˥ߥ˥ХåեξϤƤrealize Ƥȴ*/
  w->offthespotWin.minibuffer_popup  = minibuffer_popup ;
  w->offthespotWin.minibuffer_canvas = minibuffer_canvas ;

  /* 괺ΤġXtPopDown ȤפʤΤʤ*/
  XtRealizeWidget( minibuffer_popup ) ;
  XtRealizeWidget( minibuffer_canvas ) ;

  minibuffer_popup->core.border_width = 0 ;
  /* Ƥ˥ꥵäƤ롩 */
  (void) XtMakeResizeRequest
    ( ( Widget )minibuffer_popup,
      ( Dimension )winwidth, ( Dimension )winheight,
      &minibuffer_popup->core.width,
      &minibuffer_popup->core.height ) ;

  /* ɥΥꥵ¾ꡣ*/
  sizehints.win_gravity = NorthWestGravity ;
  sizehints.base_width  = 0 ; /*minibuffer_popup->core.border_width * 2 ;*/
  sizehints.base_height = 0 ; /*minibuffer_popup->core.border_width * 2 ;*/
  sizehints.width      = winwidth + sizehints.base_width ;
  sizehints.height     = winheight + sizehints.base_height ;
  sizehints.width_inc  = 1 ;
  sizehints.height_inc = font_height ;
  sizehints.min_width  = sizehints.base_width ;
  sizehints.min_height = winheight + sizehints.base_height ;
  sizehints.flags      =
    ( PBaseSize | PMinSize | PResizeInc | USSize | PWinGravity ) ;

  /* Window Manager ˥ҥȤäƤ롣*/
  XSetWMNormalHints
    ( XtDisplay( gw ), XtWindow( minibuffer_popup ), &sizehints ) ;
  /*XFlush( XtDisplay( gw ) ) ;*/
  return ;
}

/*
 * Widget β˸ƤФؿ
 */
static void OFFW_Realize
( Widget gw, XtValueMask *valueMask, XSetWindowAttributes *attrs )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  CoreWidgetClass super =
    ( CoreWidgetClass )XtClass( gw )->core_class.superclass ;

  /* ŬڤʥɥѰդƤ*/
  ( *super->core_class.realize )( gw, valueMask, attrs ) ;

  /* Ѵ饤ȤꤵƤʤ⤷ϡեȤ꤬
   * äƤˤϵưʤ*/
  if( w->offthespotWin.client_window == None ){
    XtDestroyWidget( gw ) ;
    return ;
  }
  if( w->offthespotWin.focus_window == None ){
    w->offthespotWin.focus_window = w->offthespotWin.client_window ;
    /* եΥɥξƤʤΤʤ顢Ѱդ롣*/
    if( !( w->offthespotWin.attribute_mask & CAClientArea ) )
      XGetRectangleOfWindow
	( XtDisplay( gw ), w->offthespotWin.focus_window, 
	  &w->offthespotWin.client_area ) ;
    OFFW_ReconfigureFocusPosition( gw ) ;
  }
  /* Ǥäȡgc 뤳ȤǤ롣*/
  OFFW_CreateAllGCs( gw ) ;

  /* Minibuffer 롣*/
  OFFW_RealizeMinibuffer( gw ) ;
  OFFW_CreateMinibufferGCs( gw ) ;

  /* modeshell ɽΤΥåȤ롣*/
  w->offthespotWin.modeshell_win = OFFW_CreateSubCanvas
    ( gw, w->offthespotWin.client_window, 
      &w->offthespotWin.modeshell_probe, 0 ) ;
  w->offthespotWin.modeshell_width  = 1 ;
  w->offthespotWin.modeshell_height = 1 ;
  /* ʸѤΥХ3ɬפˤʤ롣ϥե
     ˤϤĤȤˤʤ롣*/
  w->offthespotWin.canvas_win = OFFW_CreateSubCanvas
    ( gw, w->offthespotWin.client_window, 
      &w->offthespotWin.canvas_probe, 0 ) ;
  /* */
  XMoveResizeWindow
    ( XtDisplay( gw ), w->offthespotWin.canvas_win,
      w->offthespotWin.client_area.x, w->offthespotWin.client_area.y,
      w->offthespotWin.client_area.width,
      w->offthespotWin.client_area.height ) ;
     
  /* եꤹΤʤ顢focus ѲѤ뤹٤Ƥ */
  /* åȤrealizeǤʤФʤʤ*/
  XtSetKeyboardFocus( w->offthespotWin.minibuffer_popup, gw ) ;
  XtSetKeyboardFocus( w->offthespotWin.minibuffer_canvas, gw ) ;

  /*
   * ΰ֤ʤ⡼ɥƤʤ
   */
  OFFW_resetupModeWindow( gw ) ;
  OFFW_ReconfigureColor( gw, CAColor | CAColormap ) ;

  XMapWindow( XtDisplay( gw ), w->offthespotWin.canvas_win ) ;
  w->offthespotWin.canvas_probe = True ;
  return ;
}

/*
 * SIW  XtDestroyWidget 򤫤˸ƤӽФؿ
 *-----
 * SIW νλ·äƤ롣GC Ƥ顢malloc Ƥ
 * Ƥ롣
 */
static void OFFW_Destroy( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  struct SKKInputNode *node, *pNode ;
  /*
   * XFreeFont( XtDisplay( gw ), w->offthespotWin.fs_kanji ) ;
   * XFreeFont( XtDisplay( gw ), w->offthespotWin.fs_roman ) ;
   * ɤ顢Widget ˳ݤƤ櫓ʤߤʤΤǡ
   * ȤϤޤߤ
   */
  /* Destroy ʾ塢ʲΥɥΥ٥Ȥ̵뤹롣*/
  XSafeSelectInput( XtDisplay( gw ), XtWindow( gw ), NoEventMask ) ;
  remove_allmyeventhandler
    ( XtDisplay( gw ), w->offthespotWin.modeshell_win ) ;
  remove_allmyeventhandler
    ( XtDisplay( gw ), w->offthespotWin.canvas_win ) ;
  XSafeSelectInput
    ( XtDisplay( gw ), XtWindow( w->offthespotWin.minibuffer_popup ),
      NoEventMask ) ;
  XSafeSelectInput
    ( XtDisplay( gw ), XtWindow( w->offthespotWin.minibuffer_canvas ),
      NoEventMask ) ;
  /* Event Queue եå夷Ƥ*/
  XSafeFlush( XtDisplay( gw ) ) ;

  OFFW_ReleaseAllGCs( gw ) ;
  OFFW_ReleaseMinibufferGCs( gw ) ;
  OFFW_FreeFontSet( gw ) ;

  /* ɥ˴롣*/
  if( w->offthespotWin.modeshell_win != None )
    XDestroyWindow( XtDisplay( gw ), w->offthespotWin.modeshell_win ) ;
  if( w->offthespotWin.canvas_win != None )
    XDestroyWindow( XtDisplay( gw ), w->offthespotWin.canvas_win ) ;

  /*
   * ҥȥƤؤ֤
   */
  if( w->offthespotWin.historyAttribute != NULL ){
    /* ҥȥˤĤƿƤ֤ޤ*/
    w->offthespotWin.historyAttribute->history_start =
      w->offthespotWin.buffer.hist_start ;
    w->offthespotWin.historyAttribute->history_end =
      w->offthespotWin.buffer.hist_end ;
    /* ξѴ⡼ɤξˤĤƿƤؤ֤*/
    w->offthespotWin.historyAttribute->overthespot_like_input =
      w->offthespotWin.buffer.overthespot_like_input ;
    /* ޤĤβ̾⡼ɤξƤؤ֤ޤ*/
    if( w->offthespotWin.buffer.topbuffer != NULL ){
      w->offthespotWin.historyAttribute->j_mode =
	w->offthespotWin.buffer.topbuffer->j_mode ;
      w->offthespotWin.historyAttribute->j_zenkaku =
	w->offthespotWin.buffer.topbuffer->j_zenkaku ;
      w->offthespotWin.historyAttribute->j_katakana_mode =
	w->offthespotWin.buffer.topbuffer->j_katakana_mode ;
    }
  }
  /*
   * ХåեƲƤ
   */
  node = w->offthespotWin.buffer.lastbuffer ;
  while( node != NULL ){
    pNode = node->parentbuffer ;
    free_Minibuffer( gw, &( w->offthespotWin.buffer ), node ) ;
    node  = pNode ;
  }
  XtCallCallbacks( gw, XtNendNotify, w->offthespotWin.historyAttribute ) ;
  w->offthespotWin.historyAttribute = NULL ;
  return ;
}

/*
 * ̤褹ؿ
 */
static void OFFW_Redisplay( Widget gw, XEvent *event, Region region )
{
#if 0
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  /* ϲΥߥ󥰤Ǵְä Widget κ褬Ƥ롣*/
  if( w->offthespotWin.buffer.topbuffer == NULL ||
      w->core.being_destroyed ){
#if defined(DEBUG)
    fprintf( stderr, "Illegal Widget Exposure Event.\n" ) ;
#endif
    return ;
  }
#endif
  OFFW_RedrawScreen( gw ) ;
/*  XFlush( XtDisplay( gw ) ) ;*/
  return ;
}

/*
 * 䤳ȥ饤ȤΥå򸫤ơåȤ
 * ꤹؿ
 *----
 * 饤ȥɥΰưΤ饤ȥɥ
 *  lower ꡢ raise ȡɤ褦̵褦ʵ
 * ġɤˤ臘ʤͤʤȤʤΤɤġ
 */
static int OFFW_ReconfigureWindows( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;

  if( w->offthespotWin.minibuffer_probe ){
    XRaiseWindow
      ( XtDisplay( gw ),
	XtWindow( w->offthespotWin.minibuffer_popup ) ) ;
  }
  /* Spot Location ѲˤʸɽƤ륭Хư */
  /* ʤФʤʤν˺ä C-h ѴưԽ */
  /* ʸõ˥ɥĤ뤳Ȥˤʤ롣*/
  XMoveResizeWindow
    ( XtDisplay( gw ), w->offthespotWin.canvas_win,
      w->offthespotWin.client_area.x, w->offthespotWin.client_area.y,
      w->offthespotWin.client_area.width,
      w->offthespotWin.client_area.height ) ;

  OFFW_RedrawScreen( gw ) ;
  w->offthespotWin.camsg = NULL ;
  return True ;
}

static void OFFW_ResizeMinibufferAndModeshell( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  XSizeHints sizehints ;

  if( w->offthespotWin.change_minibuffer_font ){
    if( w->offthespotWin.minibuf_width != 
	w->offthespotWin.minibuffer_popup->core.width ||
	w->offthespotWin.font_height !=
	w->offthespotWin.minibuffer_popup->core.height ){
      /* core width, height ѹƤ*/
      w->offthespotWin.minibuffer_popup->core.width = 
	w->offthespotWin.minibuffer_canvas->core.width = 
	w->offthespotWin.minibuf_width ;
      w->offthespotWin.minibuffer_popup->core.height =
	w->offthespotWin.minibuffer_canvas->core.height = 
	w->offthespotWin.font_height ;
      /* Window 礭ѹ롣*/
      XtResizeWindow( w->offthespotWin.minibuffer_popup ) ;
      XtResizeWindow( w->offthespotWin.minibuffer_canvas ) ;
      
      /* ߥ˥ХåեΥɥޥ͡㡼°롣*/
      sizehints.base_width  = 
	w->offthespotWin.minibuffer_popup->core.border_width * 2 ;
      sizehints.base_height = 
	w->offthespotWin.minibuffer_popup->core.border_width * 2 ;
      sizehints.width_inc  = 1 ;
      sizehints.height_inc = w->offthespotWin.font_height ;
      sizehints.min_width  = sizehints.base_width ;
      sizehints.min_height = w->offthespotWin.font_height +
	sizehints.base_height ;
      sizehints.flags = ( PBaseSize | PMinSize | PResizeInc ) ;
      XChangeWMNormalHints
	( XtDisplay( gw ),
	  XtWindow( w->offthespotWin.minibuffer_popup ),
	  &sizehints ) ;
    }
  } else {
    if( w->offthespotWin.minibuf_width != 
	w->offthespotWin.minibuffer_popup->core.width ||
	w->offthespotWin.mfont_height !=
	w->offthespotWin.minibuffer_popup->core.height ){
      /* core width, height ѹƤ*/
      w->offthespotWin.minibuffer_popup->core.width = 
	w->offthespotWin.minibuffer_canvas->core.width = 
	w->offthespotWin.minibuf_width ;
      w->offthespotWin.minibuffer_popup->core.height =
	w->offthespotWin.minibuffer_canvas->core.height =
	w->offthespotWin.mfont_height ;
      /* Window 礭ѹ롣*/
      XtResizeWindow( w->offthespotWin.minibuffer_popup ) ;
      XtResizeWindow( w->offthespotWin.minibuffer_canvas ) ;
    }
  }
  return ;
}

/*
 * Ѵ饤Ȥʿڤطʿ顼ޥåפѹ줿ˡ
 * GC κԤؿ
 */
static void OFFW_ReconfigureColor( Widget gw, unsigned long valuemask )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  unsigned long mask ;
  XSetWindowAttributes xswa ;

  mask = 0L ;
  /* طʿѹ줿ΤǤ */
  if( valuemask & CAColor ){
    mask |= ( CWBackPixel | CWBorderPixel ) ;
    xswa.background_pixel = w->offthespotWin.obackground ;
    xswa.border_pixel     = w->offthespotWin.oforeground ;
  }
  /* 顼ޥåפѹ줿ΤǤ */
  if( valuemask & CAColormap ){
    mask |= CWColormap ;
    xswa.colormap = w->offthespotWin.colormap ;
  }
  if( mask ){
    /*   ֤󡣤ʤꤷʤȤʤΤġ      *
     * աϳƥɥطʿȥ顼ޥåפκ* 
     * Ƥ롣                                                    *
     * ե꡼֥եȤ衢եȡ                          */
    XChangeWindowAttributes
      ( XtDisplay( gw ), w->offthespotWin.modeshell_win, 
	mask, &xswa ) ;
    XChangeWindowAttributes
      ( XtDisplay( gw ), w->offthespotWin.canvas_win, 
	mask, &xswa ) ;
  }
  /* ѹʤä顢GC Ϻľʤɤ 顼ޥ
     פϤɤΤ */
  if( !( valuemask & CAColor ) )
    return ;

  if( XtIsRealized( gw ) ){
    /* ޤȤäƤ GC Ʋ롣 minibuffer οä *
     * ѹ٤ʡ  */
    OFFW_ReleaseAllGCs( gw ) ;
    OFFW_CreateAllGCs( gw ) ;
  }
  return ;
}

/*
 * åȴ֤ΥåȤؿ
 */
static Boolean OFFW_SetValues
( Widget current, Widget request, Widget new,
  ArgList args, Cardinal *num_args )
{
  OffthespotWinWidget curw = ( OffthespotWinWidget )current ;
  OffthespotWinWidget reqw = ( OffthespotWinWidget )request ;
  OffthespotWinWidget neww = ( OffthespotWinWidget )new ;
  struct ConvAttrsMesg *camsg ;

  /* 񤬽Ƥ顢ľ¹Ԥ롣*/
  if( curw->offthespotWin.buffer.jisyo_dirty !=
      reqw->offthespotWin.buffer.jisyo_dirty ){
    neww->offthespotWin.buffer.jisyo_dirty =
      reqw->offthespotWin.buffer.jisyo_dirty ;
    /* 뤬Ƥʤм¹Ԥʤȡ*/
    if( neww->offthespotWin.modeshell_probe ){
      Modeshell_Redisplay
	( new, neww->offthespotWin.modeshell_win ) ;
    }
    return False ;
  }
  /* Ѵ°ν׵᤬褿ȸդꡣ*/
  if( reqw->offthespotWin.camsg != NULL ){
    int ret ;
    /* Ѵ°ˤǸ­Τɤ *
     * äƤߤäʤ͡                                     *
     * ա֤Ǥ͡äƤߤޤ礦Ĥ󡪡             */
    camsg = reqw->offthespotWin.camsg ;
    reqw->offthespotWin.camsg = neww->offthespotWin.camsg = 
      curw->offthespotWin.camsg = NULL ;

    ret = OFFW_ChangeAttributes
      ( new, camsg->mask, &camsg->value ) ;

    if( XtIsRealized( new ) )
      OFFW_ReconfigureWindows( new ) ;
    return ret ;
  }
  /* ߥ˥ХåեõȤ˾νԤ*/
  if( reqw->offthespotWin.clearMinibuffer ){
    if( curw->offthespotWin.minibuffer_probe ){
      XtPopdown( curw->offthespotWin.minibuffer_popup ) ;
      curw->offthespotWin.minibuffer_probe =
	neww->offthespotWin.minibuffer_probe = False ;
    }
    reqw->offthespotWin.clearMinibuffer =
      neww->offthespotWin.clearMinibuffer = 
      curw->offthespotWin.clearMinibuffer = False ;
    return FALSE ;
  }
  /* ݥåץåפ롣*/
  if( reqw->offthespotWin.conversion_set_focus ){
    reqw->offthespotWin.conversion_set_focus = 
      neww->offthespotWin.conversion_set_focus = 
      curw->offthespotWin.conversion_set_focus = False ;
    if( !neww->offthespotWin.modeshell_probe ){
      XMapWindow( XtDisplay( new ), neww->offthespotWin.modeshell_win ) ;
      neww->offthespotWin.modeshell_probe = True ;
    }
    if( !neww->offthespotWin.canvas_probe ){
      XMapWindow( XtDisplay( new ), neww->offthespotWin.canvas_win ) ;
      neww->offthespotWin.canvas_probe = True ;
    }
    /* ߥ˥ХåեƤ⤷ʤΤ褵롣*/
    OFFW_ConfigureMinibuffer( new ) ;
    return FALSE ;
  }
  /* ݥåץ󤹤롣*/
  if( reqw->offthespotWin.conversion_unset_focus ){
    reqw->offthespotWin.conversion_unset_focus = 
      neww->offthespotWin.conversion_unset_focus = 
      curw->offthespotWin.conversion_unset_focus = False ;
    if( neww->offthespotWin.modeshell_probe ){
      XUnmapWindow( XtDisplay( new ), neww->offthespotWin.modeshell_win ) ;
      neww->offthespotWin.modeshell_probe = False ;
    }
    if( neww->offthespotWin.canvas_probe ){
      XUnmapWindow( XtDisplay( new ), neww->offthespotWin.canvas_win ) ;
      neww->offthespotWin.canvas_probe = False ;
    }
    return FALSE ;
  }
  return( FALSE ) ;
}

static int OFFW_ReconfigureFocusPosition
( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  int x, y, ofx, ofy ;
  Window dummy ;
  int ret = False ;

  /* 饤ȥɥΥ롼ȥɥǤκɸ롣*/
  XTranslateCoordinates
    ( XtDisplay( gw ), w->offthespotWin.client_window,
      RootWindowOfScreen( XtScreen( gw ) ),
      0, 0, &x, &y, &dummy ) ;
  if( w->offthespotWin.focus_window != w->offthespotWin.client_window &&
      w->offthespotWin.focus_window != None ){
    /* եɥΥ饤ȥɥǤκɸ롣*/
    XTranslateCoordinates
      ( XtDisplay( gw ), w->offthespotWin.focus_window,
	w->offthespotWin.client_window, 
	0, 0, &ofx, &ofy, &dummy ) ;
  } else {
    ofx = ofy = 0 ;
  }
  /* 饤ȥɥΥ롼ȥɥǤκɸ򵭲Ƥ*/
  if( w->offthespotWin.client_x != x || w->offthespotWin.client_y != y ){
    w->offthespotWin.client_x = x ;
    w->offthespotWin.client_y = y ;
    ret = True ;
  }
  /* եɥΥ饤ȥɥǤκɸ򵭲Ƥ*/
  if( w->offthespotWin.focus_offset_x != ofx ||
      w->offthespotWin.focus_offset_y != ofy ){
    w->offthespotWin.focus_offset_x = ofx ;
    w->offthespotWin.focus_offset_y = ofy ;
    ret = True ;
  }
  return ret ;
}

/*
 * ʤ굯ưƤʳǥեưȤ̵
 * ꤤ(̿δְ㤤ʤΤ)򲿤Ȥؿ 
 *----
 * Netscape ׵ФƤΤǡޤ
 * οͤˤȤäƤϡNetscape ơNetscape ܸ첽ޤơBus 
 * Error С kinput2  skkinput ΤʤΡ
 * ƤȤ顣錄ᤷǤʾС
 */
static void OFFW_ChangeFocusWindow
( Widget gw, Window focus_win )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;

  /* focus window ˤϤĤƤɥ˴롣*/
  XDestroyWindow( XtDisplay( gw ), w->offthespotWin.canvas_win ) ;
  w->offthespotWin.canvas_win = OFFW_CreateSubCanvas
    ( gw, focus_win, &w->offthespotWin.canvas_probe, 0 ) ;

  XDestroyWindow( XtDisplay( gw ), w->offthespotWin.modeshell_win ) ;
  w->offthespotWin.modeshell_win = OFFW_CreateSubCanvas
    ( gw, focus_win, &w->offthespotWin.modeshell_probe, 
      w->offthespotWin.modeshell_border_width ) ;

  w->offthespotWin.focus_window = focus_win ;
  OFFW_ReleaseAllGCs( gw ) ;
  OFFW_CreateAllGCs( gw ) ;
  return ;
}

/*
 * Ѵ饤ȤΡѴ°ν׵פ򤵤Фؿ
 */
static int OFFW_ChangeAttributes
( Widget gw, unsigned long valuemask, struct ConvAttrs *values )
{
  OffthespotWinWidget w   = ( OffthespotWinWidget )gw ;
  int ret = False, rec_col ;

  if( valuemask & CAFocusWindow ){
#ifdef DEBUG
    fprintf
      ( stderr, "Get focus window (%ld)\n", values->focus_window ) ;
#endif
    /* եäƼºߤΡ Ȥ¤Ϥ⤦ä *
     * ɬפȻפ*/
    if( values->focus_window != None ){
      /* ꤷȦΥեʪˤʤäƤ顢̣Ǥ */
      /* ʤ ȤäǤ*/
      if( w->offthespotWin.focus_window != None ){
	OFFW_ChangeFocusWindow( gw, values->focus_window ) ;
	w->offthespotWin.attribute_mask &= ~( CAStatusArea ) ;
      } else {
	w->offthespotWin.focus_window = values->focus_window ;
      }
      /* Ѵ饤ȤΰФ̵ä鼫Ѱդ *
       * 줬ɤʤݾڤϤʤΤɡѴ *
       * Ȥʤ̵ */
      if( !(( w->offthespotWin.attribute_mask ) & CAClientArea )){
	XGetRectangleOfWindow
	  ( XtDisplay( gw ), w->offthespotWin.focus_window, 
	    &w->offthespotWin.client_area ) ;
      }
      /* ơΰ褬ꤵƤʤä顢Ȥꤢϥ饤
	 ΰѤ롣ΤޤޤǤФ˸ɤΤ
	 ץꥱ¦Ȥ뤳ȡ*/
      if( !(( w->offthespotWin.attribute_mask ) & CAStatusArea ) ){
	w->offthespotWin.status_area = w->offthespotWin.client_area ; 
      }
      OFFW_ReconfigureFocusPosition( gw ) ;
      ret = True ;
    }
  }
  if( valuemask & CAStatusArea ){
    /* ɸνä⤷ɽΰ褬Ƥ硣*/
    if( values->status_area.x != w->offthespotWin.status_area.x ||
        values->status_area.y != w->offthespotWin.status_area.y ||
        values->status_area.width  != w->offthespotWin.status_area.width || 
        values->status_area.height != w->offthespotWin.status_area.height ){
      w->offthespotWin.status_area.x = values->status_area.x ;
      w->offthespotWin.status_area.y = values->status_area.y ;
      w->offthespotWin.status_area.width  = values->status_area.width ;
      w->offthespotWin.status_area.height = values->status_area.height ;
      w->offthespotWin.attribute_mask |= CAStatusArea ;
      ret = True ;
    }
  }
  rec_col = False ;
  /* 顼ޥåפѹ׵᤬褿硣*/
  if( ( valuemask & CAColormap ) &&
     w->offthespotWin.colormap != values->colormap ){
    w->offthespotWin.colormap = values->colormap ;
    rec_col = True ;
  }
  /* طʿʿѹ׵᤬褿硣*/
  if( ( valuemask & CAColor ) &&
     ( w->offthespotWin.obackground != values->background ||
       w->offthespotWin.oforeground != values->foreground ) ){
    w->offthespotWin.obackground = values->background ;
    w->offthespotWin.oforeground = values->foreground ;
    rec_col = True ;
  }
  if( XtIsRealized( gw ) && rec_col ){
    OFFW_ReconfigureColor( gw, valuemask ) ;
    ret = True ;
  }
  /* Ѵ饤ȤɽΰνΤ褿ν*/
  if( valuemask & CAClientArea ){
    /* ɸνä⤷ɽΰ褬Ƥ硣*/
    if( values->client_area.x != w->offthespotWin.client_area.x ||
        values->client_area.y != w->offthespotWin.client_area.y ||
        values->client_area.width != w->offthespotWin.client_area.width || 
        values->client_area.height != w->offthespotWin.client_area.height ){
      /* Ѵ饤ȤɽΰѹФƤ*/
      w->offthespotWin.client_area    = values->client_area ;
#ifdef DEBUG
      fprintf( stderr, "Get client area pos:(%d,%d), size:%d x %d.\n",
	       w->offthespotWin.client_area.x,
	       w->offthespotWin.client_area.y,
	       w->offthespotWin.client_area.width,
	       w->offthespotWin.client_area.height ) ;
#endif
      w->offthespotWin.attribute_mask |= CAClientArea ;
      ret = True ;
    }
  }
  /* ɸȤ׵᤬ƤνԤ*/
  if( valuemask & CASpotLocation ){
    if( w->offthespotWin.focus_window != None ){
      int prev_focus ;
#if defined(DEBUG)
      fprintf( stderr, "CASPOT nanode FOCUSWINDOW miru (%ld).\n",
	      w->offthespotWin.focus_window ) ;
#endif
      prev_focus = w->offthespotWin.is_focus ;
      w->offthespotWin.is_focus = focusCheck( gw ) ;
      if( prev_focus != w->offthespotWin.is_focus ){
	ret = True ;
      }
    }
    OFFW_ReconfigureFocusPosition( gw ) ;
    if( values->spot_x != w->offthespotWin.spot_x ||
	values->spot_y != w->offthespotWin.spot_y ){
#ifdef DEBUG
      fprintf( stderr, "Get Basho Shitei meirei.\n" ) ;
#endif
      /* ֤뤵*/
      w->offthespotWin.spot_x = values->spot_x ;
      w->offthespotWin.spot_y = values->spot_y ;
      ret = True ;
    }
  }
  /* եȾνäν*/
  if( valuemask & CAFonts ){
#ifdef DEBUG
    fprintf( stderr, "FONT WO KIRIKAERU.\n" ) ;
#endif
    /* եȾ򹹿롣λ饤¦ΥեȤξ
     * ƹ碌ΤȤ롣㤨饤ȤեȤ
     * ꤷƤʤƥǥեȤΥեȤȤȤˤʤꡢΥե
     * Ȥι⤵ʤƤġ(ɤΤ) */
    if( fontMgr_GetFontSetInfo
	( values->fontset,
	  &w->offthespotWin.font_height,
	  &w->offthespotWin.font_ascent ) ){
      /* եȥåȤ򥳥ԡ롣*/
      fontMgr_CopyFontSet
	( XtDisplay( gw ), w->offthespotWin.fontset, values->fontset ) ;
      /* ߥ˥Хåեȥ⡼ɥ礭롣*/
      if( XtIsRealized( gw ) )
	OFFW_ResizeMinibufferAndModeshell( gw ) ;
      ret = True ;
    }
  }
  /* եȤι⤵˴ؤƤˤϡġ*/
  if( valuemask & CALineSpacing ){
    if( values->linespacing > 0 ){
      w->offthespotWin.font_height = values->linespacing ;
      ret = True ;
    }
  }
  return ret ;
}

/*
 * 줿Ȥ٥ȤνԤؿ
 *----
 * Υ줿ȤԲǽʾ礬Τǡ줿Ȥ
 * Ǿ꤯ư褦˺ʤФʤʤ
 */
static void KeyDownEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;

  if( commonKeyEventHandler( gw, xevent, &( w->offthespotWin.buffer ) ) )
    OFFW_RedrawScreen( gw ) ;
  return ;
}

/*
 * ߥޥեƤ뤫ɤå뤿δؿ
 *-----
 * ΤƤХȤơեΰư˾꤯ȡ
 * Pointer ¸ߤƤ뤳ȤƨƤޤȤġʤʬ
 * 뤫
 */
static int focusCheck( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  Window mouse_focus, rootwin, childwin ;
  int ret_focus_state ;
  int rootx, rooty, winx, winy ;
  unsigned int winmask ;
  
  /* ޤޥΥեåäƤͤդ롣*/
  XGetInputFocus
    ( XtDisplay( gw ), &mouse_focus, &ret_focus_state ) ;

#if defined(DEBUG)
  fprintf( stderr, "Mouse Focus Window:(%ld)\n", mouse_focus ) ;
#endif
  if( mouse_focus == None || mouse_focus == PointerRoot )
    return False ;

  if( w->offthespotWin.input_focus_window != None ){
    if( mouse_focus == w->offthespotWin.input_focus_window )
      return True ;
  } 
  if( XQueryPointer
     ( XtDisplay( gw ), mouse_focus,
       &rootwin, &childwin, &rootx, &rooty, &winx, &winy, 
       &winmask ) ){
#if defined(DEBUG)
    fprintf
      ( stderr, "Focus Root Window:(%ld), Focus Child Window:(%ld)\n",
        rootwin, childwin ) ;
#endif
    /* Ѵ饤ȤޥΥեäƤ롢⤷ */
    /* ϤλҶޥΥեäƤΤʤ True */
    if( w->offthespotWin.focus_window == childwin ){
      if( w->offthespotWin.input_focus_window == None ){
	w->offthespotWin.input_focus_window = mouse_focus ;
      }
      return True ;
    }
    if( w->offthespotWin.focus_window == mouse_focus )
      return True ;
    /* ߥ˥ХåեɥƤ⤢衣*/
    if( w->offthespotWin.minibuffer_probe ){
      Window win = XtWindow( w->offthespotWin.minibuffer_popup ) ;
      if( win == childwin || win == mouse_focus )
	return True ;
    }
  }
  return False ;
}

/*
 * ե蘆줿νԤؿ
 */
static void FocusEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  int prev_focus ;

  /* եɥޤäƤʤΤˡʥեIN ʤ */
  /* äƤ礸ʤ*/
  if( w->offthespotWin.focus_window == None )
    return ;
  /* ޤϥե򼺤äΤȹͤ롣*/
  prev_focus = w->offthespotWin.is_focus ;
  w->offthespotWin.is_focus = focusCheck( gw ) ;
  /* ̤νĥηѲΤǡ*/
  if( prev_focus != w->offthespotWin.is_focus )
    OFFW_RedrawScreen( gw ) ;
  return ;
}

/*
 * ʲΥեϡOffthespotWinWidget ΥΰǤ롣
 */

/*
 * skkinput ɽؿ
 *-----
 * ϺʬԤʤ
 */
static void OFFW_FullDrawWindow
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, GC rgc, int start_pos, int x, int y, int width, int height, 
  struct SKKInputNode *node, struct myChar *text, 
  int cursor_width, int font_height, int font_ascent, int is_focus )
{
  int pos, cursor_flag ;
  int cx, cy ;
  int xdiff ;

  pos         = start_pos ;
  cursor_flag = False ;

  cx = cy = 0 ;

  while( !IS_END_OF_STRING( *text ) ){
    xdiff = myCharTextWidth( fontset, text, 1 ) ;
    /* ɽʤΤɤȽꤹ롣*/
    if( pos == node->cur_pos ){
      if( node->cur_exist ){
	skkinputDrawCursor
	  ( disp, win, gc, rgc,
	    x, y, font_ascent, xdiff, font_height, is_focus ) ;
	cursor_flag = True ;
      }
      cx = x ;
      cy = y ;
    }
    /* ̤αüޤ褷ΤɤȽǤ롣*/
    if( ( x + xdiff ) >= width ){
      XDrawLine( disp, win, gc, x, y, width, y + font_height ) ;
      x = 0 ;
      y += font_height ;
      /* ̤βޤǽڤäΤɤȽǤ롣*/
      if( y >= height )
	goto exit_loop ;
    }
    if( IS_ASCII_EQUAL( *text, '\n' ) ){
      /* ԥɤȯν*/
      x =  0 ;
      y += font_height ;
      /* ̤βޤǽڤäΤɤȽǤ롣*/
      if( y >= height )
	goto exit_loop ;
    } else {
      if( cursor_flag ){
	if( is_focus ){
	  skkwin_jputMyChar
	    ( disp, win, fontset, rgc, gc, 
	      x, font_ascent, *text, font_height, font_ascent, True ) ;
	} else {
	  skkwin_jputMyChar
	    ( disp, win, fontset, gc, rgc, 
	      x, font_ascent, *text, font_height, font_ascent, True ) ;
	}
	cursor_flag = False ;
      } else {
	skkwin_jputMyChar
	  ( disp, win, fontset, gc, rgc, 
	    x, font_ascent, *text, font_height, font_ascent, False ) ;
      }
      x += xdiff ;
    }
    text ++ ;
    pos ++ ;
  }
  /* Ǹޤǥ뤬ɽƤʤäΤʤ顢ǸιԤ˥ *
   * ɽ롣*/
  if( pos == node->cur_pos && node->cur_exist ){
    /* Ԥɬפꡩ */
    if( ( x + cursor_width ) > width ){
      skkwin_jputchar
	( disp, win, fontset, gc, x, y, '\\', False ) ;
      x  = 0 ;
      y += font_height ;
    }
    skkinputDrawCursor
      ( disp, win, gc, rgc, x, y, font_ascent, 
	cursor_width, font_height, is_focus ) ;
    cx = x ;
    cy = y ;
  }

exit_loop:
  node->prev_cx = cx ; 
  node->prev_cy = cy ;
  return ;
}
/*
 * ⡼ɥɥ֤˰ư硢ȤޤǤɽ
 * ƤޤȤʴؿ
 */
static void OFFW_resetupModeWindow( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  int x, y, modeshell_width, modeshell_height ;

  /* Ϥ֤ˤĤƤϽ⿧(NorthWest)˸ꤷƤ
     */
  x = w->offthespotWin.status_area.x ;
  y = w->offthespotWin.status_area.y ;

  /* modeshell 礭*/
  modeshell_width  = getWidthOfModeLine
    ( w->offthespotWin.fontset,
      w->offthespotWin.buffer.topbuffer,
      w->offthespotWin.buffer.jisyo_dirty,
      w->offthespotWin.buffer.overthespot_like_input ) ;
  modeshell_height = w->offthespotWin.font_height ;

  /* 礭ΤǤ뤫ɤȽǤ롣*/
  if( w->offthespotWin.modeshell_width != modeshell_width ||
      w->offthespotWin.modeshell_height != modeshell_height ){
    w->offthespotWin.modeshell_width  = modeshell_width ;
    w->offthespotWin.modeshell_height = modeshell_height ;
    XResizeWindow
      ( XtDisplay( gw ), w->offthespotWin.modeshell_win,
	modeshell_width, modeshell_height ) ;
  }
  if( XtIsRealized( gw ) ){
    /* ⡼ɥɥ¸ߤƤʤääƤޤ*/
    if( !w->offthespotWin.modeshell_probe ){
      w->offthespotWin.modeshell_probe = True ;
      XMoveWindow( XtDisplay( gw ), w->offthespotWin.modeshell_win, x, y ) ;
      XMapWindow( XtDisplay( gw ), w->offthespotWin.modeshell_win ) ;
    } else {
      /* ɽ֤ν򤹤롣*/
      XMoveWindow
	( XtDisplay( gw ), w->offthespotWin.modeshell_win, x, y ) ;
    }
    /* ⡼ɥ饤ɽ롣*/
    Modeshell_Display( gw, w->offthespotWin.modeshell_win ) ;
  }
  return ;
}

/*
 * skkinput β̤򤤤ľؿ
 *-----
 * ̤礭ѹʤɤԤ줿ˤϤδؿƤФ뤳Ȥ
 * ʤ롣
 */
static void OFFW_RedrawScreen( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;

  /* 褵롣*/
  if( w->offthespotWin.canvas_probe )
    Canvas_Redisplay( gw, w->offthespotWin.canvas_win ) ;
  /* ⡼ɥɥɽ롣*/
  OFFW_resetupModeWindow( gw ) ;
  /* mini-buffer ɽ롣*/
  OFFW_ConfigureMinibuffer( gw ) ;
  return ;
}

/* ǡΰ֤̳˽ФΤɤȽǤʤФʤ *
 * ʤ*/
static void OFFW_ConfigureMinibufferPosition
( Widget gw, int *rx, int *ry )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  XWindowAttributes xwa ;
  int x, y, mwidth, mheight ;
  int win_gravity ;
  XSizeHints sizehints ;

  win_gravity = NorthWestGravity ;

  /* Root Window 礭Ƥ*/
  XGetWindowAttributes
    ( XtDisplay( gw ), RootWindowOfScreen( XtScreen( gw ) ), &xwa ) ;
      
  /* ⤦äȤȤɬפꡣ*/
  y = w->offthespotWin.client_y + w->offthespotWin.focus_offset_y + 
    w->offthespotWin.status_area.height +
    w->offthespotWin.minibuffer_popup->core.border_width ;
  x = w->offthespotWin.client_x + w->offthespotWin.focus_offset_x ;

  mheight = w->offthespotWin.minibuffer_popup->core.border_width * 2 +
    ( ( w->offthespotWin.change_minibuffer_font )?
      w->offthespotWin.font_height : w->offthespotWin.mfont_height ) ;
  mwidth = w->offthespotWin.minibuffer_popup->core.border_width * 2 +
    w->offthespotWin.minibuf_width ;

  if( y + mheight > xwa.height ){
    y = w->offthespotWin.client_y - mheight -
      w->offthespotWin.minibuffer_popup->core.border_width * 2 ;
    if( y < 0 ){
      y = xwa.height - mheight -
	w->offthespotWin.minibuffer_popup->core.border_width * 2 ;
    }
    if( y < 0 ){
      y = 0 ;
    } else {
      win_gravity = SouthWestGravity ;
    }
  }
  if( x + mwidth > xwa.width ){
    x = xwa.width - mwidth ;
    if( x < 0 ){
      x = 0 ;
    } else {
      if( win_gravity == NorthWestGravity ){
	win_gravity = NorthEastGravity ;
      } else {
	win_gravity = SouthEastGravity ;
      }
    }
  } else if( x < 0 ){
    x = 0 ;
  }
  /* Window Manager ˥ҥȤäƤ롣XSetWMNormalHints * 
   * ʬ񴹤ʤ褦ʤΤǡ hints ɤߤȤäƤ麹*
   * ؤȤˡȤʤФʤʤ*/
  sizehints.flags = PWinGravity ;
  sizehints.win_gravity = win_gravity ;
  XChangeWMNormalHints
    ( XtDisplay( gw ),
      XtWindow( w->offthespotWin.minibuffer_popup ),
      &sizehints ) ;
  *rx = x ;
  *ry = y ;
  return ;
}

/*
 * ߥ˥Хåեɥ֡礭Ԥؿ
 *----
 * 礭ϼ¤ꤷƤޤ󡣺ǽꤷǤ̤˥ߥ
 * Хåե򲿽֤ɤΤʡĤȽǤ˻Ȥ櫓Ǥ
 */
static void OFFW_ConfigureMinibuffer( Widget gw )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  struct SKKInputNode *node = w->offthespotWin.buffer.topbuffer ;
  struct SKKInputNode *mNode = w->offthespotWin.buffer.lastbuffer ;

  if( mNode == node ){
    /* ɽ٤ƥȤ̵äˤϡ*/
    if( IS_END_OF_STRING( node->mtextbuffer[ 0 ] ) ){
      /* УϣХåפ֤ä顢Ĥ롣*/ 
      if( w->offthespotWin.minibuffer_probe ){
	XtPopdown( w->offthespotWin.minibuffer_popup ) ;
	w->offthespotWin.minibuffer_probe = False ;
      }
      return ;
    }
  }
  /* ߥ˥ХåեϵƤʤΡ ƤʤΤä鵯ɬ *
   * 衣*/
  if( !w->offthespotWin.minibuffer_probe ){
    int x, y ;
    OFFW_ConfigureMinibufferPosition( gw, &x, &y ) ;

    /* ꤵ줿֤˥ߥ˥Хåեư롣*/
    XtMoveWidget
      ( w->offthespotWin.minibuffer_popup, x, y ) ;
    /* Popup 롣*/
    XtPopup( w->offthespotWin.minibuffer_popup, XtGrabNone ) ;
    w->offthespotWin.minibuffer_probe = True ;
  }
  /* Хľ褦׵Ф*/
  XtVaSetValues
    ( w->offthespotWin.minibuffer_canvas, 
      XtNredrawRequest, True, NULL ) ;
  return ;
}    

static void Canvas_Redisplay
( Widget gw, Window win )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  int linenum, cur_line, maxline, spos, sty, edy ;
  struct myChar *ptr ;
  struct SKKInputNode *node = w->offthespotWin.buffer.topbuffer ;

  /* Canvas  popup ƤʤеѲ롣popup ޤǤ˥ե
     νʤɤ򤹤Τǡʲν¹ԤƤϺ櫓Ǥ롣*/
  if( !w->offthespotWin.canvas_probe )
    return ;

  XClearWindow( XtDisplay( gw ), win ) ;

  /* ɽǽԿ롣*/
  maxline = w->offthespotWin.client_area.height /
    w->offthespotWin.font_height ;
  /* ߡƥȤϲԤޤɽʤФʤʤΤ򻻽Ф롣*/
  linenum = skkinput_GetLineNum
    ( w->offthespotWin.fontset, node->textbuffer,
      w->offthespotWin.client_area.width, w->offthespotWin.cursor_width,
      node->cur_pos, &cur_line ) ;
  /* ɽǽԿĶƤν֤ϰϤ *
   * ǰֺǽιԤֹ椬Ǥ⾮ʤ褦ꤹ롣*/
  if( linenum >= maxline && cur_line >= maxline ){
    int startline = cur_line - maxline + 1 ;
    /* ꤵ줿꤫ɽʤФʤʤΤǡΰ֤򻻽Ф롣*/
    spos = skkinput_FindStartLine
      ( w->offthespotWin.fontset, node->textbuffer,
	startline, w->offthespotWin.client_area.width ) ;
    ptr = node->textbuffer + spos ;
  }  else {
    spos = 0 ;
    /* ˰ֺǽʸɽǽǤ롣*/
    ptr = node->textbuffer ;
  }    
  sty = w->offthespotWin.font_ascent ;
  edy = sty + maxline * w->offthespotWin.font_height ;
  /* Window  buffer ʸɽ롣*/
  OFFW_FullDrawWindow
    ( XtDisplay( gw ), win,
      w->offthespotWin.fontset, 
      w->offthespotWin.gc, w->offthespotWin.rgc,
      spos, 0, sty, w->offthespotWin.client_area.width, edy, 
      node, ptr, w->offthespotWin.cursor_width, 
      w->offthespotWin.font_height, w->offthespotWin.font_ascent,
      w->offthespotWin.is_focus ) ;
  return ;
}

/*
 * δؿϸߤξǤκ褷ޤpopup/popdown ʤɤ
 * ƤФäƤƤ뤳Ȥˤޤꥢ꤫ʤ Ǥ⡢
 * ѲڤäưͿΤϿ(Ĥޤ offthespotWinWidget)ʤΤ
 * 顢ҶǤȤ餻äƤΤϡġo
 */
static void Minibuffer_RedisplayCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )client ;
  struct SKKInputNode *mNode ;
  struct SKKInputNode *node ;
  struct skkinputManagedFont **fontset ;
  int fontascent, fontheight ;

  if( !w->offthespotWin.minibuffer_probe )
    return ;

  if( w->offthespotWin.change_minibuffer_font ){
    fontset    = w->offthespotWin.fontset ;
    fontheight = w->offthespotWin.font_height ;
    fontascent = w->offthespotWin.font_ascent ;
  } else {
    fontset    = w->offthespotWin.minibuf_fontset ;
    fontheight = w->offthespotWin.mfont_height ;
    fontascent = w->offthespotWin.mfont_ascent ;
  }
  XClearWindow( XtDisplay( gw ), XtWindow( gw ) ) ;

  /* mini-buffer ɽ롣*/
  node  = w->offthespotWin.buffer.topbuffer ;
  mNode = w->offthespotWin.buffer.lastbuffer ;

  if( mNode == node ){
    /* ɽ٤ƥȤ̵äˤϡ*/
    if( IS_END_OF_STRING( node->mtextbuffer[ 0 ] ) )
      return ;

    /* ĤߤäȤʤɬɽ˽ФƤ褦ˤ롣*/
    XRaiseWindow
      ( XtDisplay( gw ), XtWindow( gw ) ) ;
    skkwin_jputstring
      ( XtDisplay( gw ), XtWindow( gw ), 
	fontset, w->offthespotWin.minibuf_gc,
	0, fontascent, node->mtextbuffer ) ;
  } else {
    /* ĤߤäȤʤɬɽ˽ФƤ褦ˤ롣*/
    XRaiseWindow
      ( XtDisplay( gw ), XtWindow( gw ) ) ;

    if( !IS_END_OF_STRING( mNode->mtextbuffer[ 0 ] ) ){
      skkwin_jputstring
	( XtDisplay( gw ), XtWindow( gw ),
	  fontset, w->offthespotWin.minibuf_gc,
	  0, fontascent, mNode->mtextbuffer ) ;
    } else {
      struct myChar *toptext ;
      int toppos ;

      /* Window  buffer ʸɽ롣*/
      OTSW_CalcTopPositionOfBuffer
	( fontset, mNode->textbuffer, 0, mNode->cur_pos, gw->core.width,
	  &toptext, &toppos ) ;
      OTSW_FullDrawTopBufferTopLine
	( XtDisplay( gw ), XtWindow( gw ), fontset, 
	  w->offthespotWin.minibuf_gc, w->offthespotWin.minibuf_rgc, 
	  toptext, toppos, fontascent, fontheight,
	  gw->core.width,
	  !IS_END_OF_STRING( mNode->textbuffer[ mNode->cur_pos ] ),
	  w->offthespotWin.cursor_width,
	  mNode->cur_pos, mNode->cur_exist, 
	  w->offthespotWin.is_focus ) ;
    }
  }
  return ;
}

/*
 * modeshell window ˥⡼ɤɽ򤹤ؿ
 */
static void Modeshell_Display
( Widget gw, Window win )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  struct SKKInputNode *node = w->offthespotWin.buffer.topbuffer ;
  unsigned long mode_status ;

  /* ⡼ɥɥ¸ߤƤʤä񤫤ʤ*/
  if( !w->offthespotWin.modeshell_probe )
    return ;
  /* ߤξ֤򸫤롣*/
  mode_status =
    ( ( skkinput_GetModelineNumber( node ) ) |
      ( w->offthespotWin.buffer.jisyo_dirty << 3 ) |
      ( w->offthespotWin.buffer.overthespot_like_input << 4 ) ) ;
  if( w->offthespotWin.prevModeStatus != mode_status ){
    /* ľΤ˥ɥõ롣*/
    XClearWindow( XtDisplay( gw ), win ) ;
    w->offthespotWin.prevModeStatus = mode_status ;
  }
  /* ⡼ɥ饤ɽ롣ʬɽľбͽǤϤ롣*/
  fullDrawModeLine
    ( XtDisplay( gw ), win,
      w->offthespotWin.fontset, w->offthespotWin.gc,
      node, 0, w->offthespotWin.font_ascent,
      w->offthespotWin.buffer.jisyo_dirty,
      w->offthespotWin.buffer.overthespot_like_input ) ;
  return ;
}

/*
 * modeshell window ˥⡼ɤɽ򤹤ؿ
 */
static void Modeshell_Redisplay
( Widget gw, Window win )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )gw ;
  struct SKKInputNode *node = w->offthespotWin.buffer.topbuffer ;

  /* ⡼ɥɥ¸ߤƤʤä񤫤ʤ*/
  if( !w->offthespotWin.modeshell_probe )
    return ;
  /* ľΤ˥ɥõ롣*/
  XClearWindow( XtDisplay( gw ), win ) ;
  /* ⡼ɥ饤ɽ롣ʬɽľбͽǤϤ롣*/
  fullDrawModeLine
    ( XtDisplay( gw ), win,
      w->offthespotWin.fontset, w->offthespotWin.gc,
      node, 0, w->offthespotWin.font_ascent,
      w->offthespotWin.buffer.jisyo_dirty,
      w->offthespotWin.buffer.overthespot_like_input ) ;
  w->offthespotWin.prevModeStatus =
    ( ( skkinput_GetModelineNumber( node ) ) |
      ( w->offthespotWin.buffer.jisyo_dirty << 3 ) |
      ( w->offthespotWin.buffer.overthespot_like_input << 4 ) ) ;
  return ;
}

/*
 * Canvas Widget ˸ƤӽФ륳Хåؿ
 */
static void Canvas_DestroyCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  XtRemoveAllCallbacks( gw, XtNredrawNotify ) ;
  XtRemoveAllCallbacks( gw, XtNdestroyNotify ) ;
  return ;
}

static void OFFW_wmMessageCloseCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  OffthespotWinWidget w = ( OffthespotWinWidget )client ;
  
  force_keyboard_quit( ( Widget )w, &( w->offthespotWin.buffer ) ) ;
  return ;
}

static void OFFW_wmShellDestroyCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  /* ƤΥХåؿ˴Ƥ*/
  XtRemoveAllCallbacks( gw, XtNwmcloseNotify ) ;
  XtRemoveAllCallbacks( gw, XtNdestroyNotify ) ;
  return ;
}
