/* # skkinput (Simple Kana-Kanji Input)
 * buffers.h
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * Mule ˤ buffer ΤɬפޤȤ᤿إå
 * ե "buffers.h"
 */
#ifndef buffers_h
#define buffers_h

/*
 * ɤޤեɤ߹ࡣ
 */
#include "kanji.h"

/*
 * skkinput ֤ˤĤƵҤǤ
 */
#define J_HENKAN_MODE_OFF	(0)
#define J_HENKAN_OFF		(0)
#define J_KANA_MODE_OFF		(0)
#define J_OKURIGANA_OFF		(0)
#define J_HENKAN_MODE_ON	(1<<3)
#define J_HENKAN_ON		(1<<2)
#define J_KANA_MODE_ON		(1<<1)
#define J_OKURIGANA_ON		(1)
#define SKKINPUT_MAXKEYINPUT	(8)

/*
 * ѿηѰդ롣ޤ¤ΤƤȤǤ͡
 */
/* (skkserv)η̤Ǽ빽¤..list */
typedef struct _SkkinpSearchVector {
  struct myChar text[ TEXTBUFSIZE ] ;
  int used ;
  struct _SkkinpSearchVector *next ;
} SkkinpSearchVector ;

/* 񤫤̤䤹뤿ι¤...index */
typedef struct _VectorIndex {
  SkkinpSearchVector *node ;	/* ߤθ䡣*/
  int position ;
  int length ;		/* Ĺ*/
  struct _VectorIndex *next ;	/* θ䡣*/
  struct _VectorIndex *prev ;	/* θ䡣*/
} VectorIndex ;

/* elisp ˤޡѤι¤Ρ*/
struct Marker {
  int *pos ;
  int cf ;
} ;

/*
 * mule ˤ buffer Ĥ빽¤Ρĸ汢̵ͤ礭ʤ
 * Ƥޤޤ⤦ȤʤʤϺǤʬ褷ƥ
 * ĤʤĤȤΤ̵̤⤷ʤǤǤ⡢mule ϥĤ
 * ʤ
 */
struct SKKInputNode {
  /* int number ; */
  /*
   * ʬѤʬ
   */
  int prev_cx, prev_cy ;
  /* ΥɥκκǽʸϥƥȤβХܤ *
   * 줿Τ*/
  int prev_start_pos ;
  /*
   * ϤδѤʬ
   */
  /* ѤʸǼХåե*/
  struct myChar textbuffer[ TEXTBUFSIZE ] ;
  struct myChar mtextbuffer[ TEXTBUFSIZE ] ;
  /* ѴΤ j-prefix  줬 rom-kana-rule-list ˤ *
   * ܤˤ֤ɽˤʤ롣äˤϴǤ*
   * ʤƤƤޤäɡĺ٤Ϥɤ? */
  struct myChar j_prefix[ TEXTBUFSIZE ] ;
  /* ѴоݤȤʤʸݴɤХåեʤΤǤ롣*/
  struct myChar j_henkan_key[ TEXTBUFSIZE ] ;
  struct myChar j_henkan_key2[ TEXTBUFSIZE ] ;
  struct myChar j_search_key[ TEXTBUFSIZE ] ;
  struct myChar j_num_list[ TEXTBUFSIZE ] ;

  /* (;_;) 餱Ĥɤġ*/

  /* κɸ*/
  int cur_pos, cur_pos2, cur_pos3, cur_pos4 ;
  int cur_pos_backup ;
  /* ΰưǽʺǾ͡*/
  int cur_pos_top ;
  /* ޡ֡*/
  int mark_pos ;
  /* 뤬뤫ݤŪ˥뤬꤬ *
   * 뤳Ȥ롣*/
  int cur_exist ;
  /* Ѵ⡼ɤ˰ܹԤƤ뤫ɤ*/
  int j_henkan_mode ;
  /* Ѵ椫ݤ( Ĥޤϡɤ)*/
  int j_henkan_on ;
  /* ̾椫ݤ*/
  int j_kana_mode ;
  /* 겾̾椫ݤ*/
  int j_okurigana_mode ;
  /* ̾Ҳ̾*/
  int j_katakana_mode ;
  /* ̾Ϥγϰ֡*/
  int j_kana_start_point ;
  /* Ѵʸγϰ֡*/
  int j_henkan_start_point ;
  /* Ѵʸνλ֡*/
  int j_henkan_end_point ;
  /* 겾̾γϰ֡*/
  int j_okurigana_start_point ;
  int j_okurigana_offset ;
  /* 겾̾*/
  struct myChar j_okuri_chara ;
  /* abbrev-mode ɤ*/
  int j_abbrev ;
  /* ϥ⡼ɤɤ*/
  int j_zenkaku ;
  /* ̾ϥ⡼ɤɤ*/
  int j_mode ;
  
  /* ޤǤѴ*/
  int j_henkan_count ;
  /* Ѵư椫 */
  int j_henkan_show_candidate_mode ;
  /* ߥ˥ХåեΤ˺줿ΤȤ롣*/
  int j_minibuff_usage ;
  /* ľʸϥ⡼ɤǤäȤƤ롣*/
  int j_input_by_code_or_menu_mode ;
  int j_input_by_code_or_menu_point ;
  int j_input_by_code_current_code ;
  int j_input_by_code_current_charset ;
  /*
   * Elisp ˤޡΤꡣ
   */
  /* ߤΥޡΰ֡*/
  struct Marker markers[ MAXMARKERNUM ] ;
  /* ޡλѾ*/
  int marker_usage ;

  /* search ѡ*/
  SkkinpSearchVector *j_henkan_vector_top ;
  VectorIndex *j_henkan_vector_index_top, *j_current_henkan_vector_index ;
  int j_henkan_vector_index_length ;

  /* completion ѡ*/
  SkkinpSearchVector *j_completion_vector_top ;
  VectorIndex *j_completion_vector_index_top,
    *j_current_completion_vector_index ;
  int j_completion_mode ;

  /* mini-buffer ѡ*/
  struct SKKInputNode *minibuffer ;
  struct SKKInputNode *parentbuffer ;
} ;

struct SKKTangoInfo {
  int tangotype ;
  char *henkankey ;
  char *string ;
  VectorIndex *vector ;
  VectorIndex **vectortop ;
  int okuri ;
} ;

/*
 * ޻̾Ѵ§
 */
struct skk_rom_kana_rule {
  struct myChar *state ;
  struct myChar *next ;
  struct myChar *houtput ;
  struct myChar *koutput ;
} ;

/*
 *ʸʸΥڥ(cons?)
 */
struct chara_string_pair {
  unsigned char chara ;
  unsigned char *string ;
} ;

#endif
