/* # skkinput (Simple Kana-Kanji Input)
 * protocol.h --- Kinput Protocol
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef protocol_h
#define protocol_h

/* $BJQ49%5!<%P$N%W%m%U%#!<%k$,F~$k%W%m%Q%F%#L>(B */
#define CONVERSION_PROFILE	"_CONVERSION_PROFILE"

/* $BJQ49%5!<%P$NJQ49B0@-$N%W%m%Q%F%#$N%?%$%W(B */
#define CONVERSION_ATTRIBUTE_TYPE	"_CONVERSION_ATTRIBUTE_TYPE"

/* $B%W%m%H%3%k%P!<%8%g%sL>(B */
#define PROTOCOL_VERSION	"PROTOCOL-2.0"

#define MAKE_CONVERSION_ATTRIBUTE( code, len ) \
( ( unsigned long )( ( ( unsigned long )( code ) ) << 16 ) + ( len ) )

enum {
  CONVERSION_PROFILE_PROTOCOL_VERSION = 1,
  CONVERSION_PROFILE_SUPPORTED_STYLES,
  CONVERSION_PROFILE_SUPPORTED_EXTENSIONS,
  CONVERSION_PROFILE_EXTENSION_DATA,
} ;

/* $B%/%i%$%"%s%H$+$iB0@-$NJQ99$,DLCN$5$l$?;~$K2?$,JQ99$5$l$?$N$+$r8+(B *
 * $B@Z$k$N$KMxMQ$5$l$k(B */
enum {
  CONVERSION_ATTRIBUTE_NASHI = 0,
  CONVERSION_ATTRIBUTE_HA_INDIRECT,
  CONVERSION_ATTRIBUTE_FOCUS_WINDOW,
  CONVERSION_ATTRIBUTE_BASHO_SHITEI,
  CONVERSION_ATTRIBUTE_CLIENT_AREA,
  CONVERSION_ATTRIBUTE_STATUS_AREA,
  CONVERSION_ATTRIBUTE_COLORMAP,
  CONVERSION_ATTRIBUTE_COLOR,
  CONVERSION_ATTRIBUTE_BACKGROUND_PIXMAP,
  CONVERSION_ATTRIBUTE_LINE_SPACING,
  CONVERSION_ATTRIBUTE_FONT_ATOMS,
  CONVERSION_ATTRIBUTE_CURSOR,
} ;

/*
 * $BF~NOJ}<0$d%$%Y%s%H$NAw$jJ}!"%W%m%H%3%k$N3HD%Ey$NB0@-(B
 */
#define CONVERSION_ATTRIBUTE_NYUURYOKU_HOUSHIKI		(128)
#define CONVERSION_ATTRIBUTE_EVENT_NO_TOBASHIKATA	(129)
#define CONVERSION_ATTRIBUTE_KAKUCHOU			(255)

/*
 * $BF~NOJ}<0$@$C$?>l9g$K2?$,;XDj$G$-$k$N$+!#$=$N<oN`$K$D$$$F!#(B
 */
#define CONVERSION_NYUURYOKU_HOUSHIKI_SEPARATEMADO	(1L)
#define CONVERSION_NYUURYOKU_HOUSHIKI_OFFTHESPOT	(2L)
#define CONVERSION_NYUURYOKU_HOUSHIKI_OVERTHESPOT	(4L)

/*
 * $BF~NOAk$,=PMh$?;~$K%$%Y%s%H$r$I$N$h$&$KHt$P$9$N$+$r;XDj$9$k$N$KMxMQ!#(B
 */
#define CONVERSION_EVENT_TOBASHI_NASHI			(0L)
#define CONVERSION_EVENT_TOBASHI_ZENBU_SKKINPUT_HE	(1L)
#define CONVERSION_EVENT_TOBASHI_FOCUS_NO_HOUHE		(2L)

/*
 * $B$=$NB>!#(B
 */
#define ULONG_UPPER16BIT(data)	\
  (((( unsigned long )( data )) >> 16 ) & 0xffffL )
#define ULONG_LOWER16BIT(data)	\
  ((( unsigned long )( data )) & 0xffffL )
#define USHORT_UPPER16BIT(data) \
  (( unsigned short )(((( unsigned long )( data )) >> 16 ) & 0xffffL ))
#define USHORT_LOWER16BIT(data) \
  (( unsigned short )(((( unsigned long )( data )) & 0xffffL )))

#define LENGTH_OF_ATTRIBUTE(data)	\
  ( ULONG_LOWER16BIT( ( data ) ) )
#define CODE_OF_ATTRIBUTE(data)		\
  ( ULONG_UPPER16BIT( ( data ) ) )
#endif
