/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMClientP_h)
#define	XIMClientP_h

#include "XIMClient.h"
#include "XIMInputMethod.h"
#include <X11/CoreP.h>
#include "varbuffer.h"
#include "tqueue.h"

typedef struct {
	TQueue				m_queInputMessage ;
	Boolean				m_fBigEndian ;
	Atom				m_atProtocol ;
	Atom				m_atReadWrite ;
	Atom				m_atMoreData ;
	TVarbuffer			m_vbufAuthProtocolNameList ;
	int					m_nAuthProtocol ;
	TVarbuffer			m_vbufOutput ;
	Boolean				m_fDispatching ;
	Boolean				(*m_pDispatcher)(Widget) ;
	Window				m_wndClient ;
	unsigned short		m_uInputMethodID ;
	XIMInputMethod*		m_lstInputMethod ;
	Widget				m_wgProtocol ;
	XtCallbackList		m_lstCbkDestroy ;
}	XIMClientPart ;

typedef struct tagXIMClientRec {
	CorePart			core ;
	XIMClientPart		ximClient ;
}	XIMClientRec ;

typedef struct {
	int					dummy ;
}	XIMClientClassPart ;

typedef struct tagXIMClientClassRec {
	CoreClassPart		core_class ;
	XIMClientClassPart	ximClient_class ;
}	XIMClientClassRec ;

extern	XIMClientClassRec	ximClientClassRec ;

#endif

