# Copyright 2001 Free Software Foundation, Inc.             -*- Autoconf -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

dnl A good portion of the content of this script originated from the
dnl distributions of either S-Lang (http://www.s-lang.org) or some
dnl of the early S-Lang modules.
dnl -*- sh -*-

AC_DEFUN(JD_INIT,dnl {{{
[
#These variable are initialized by JD init function
CONFIG_DIR=`pwd`
cd $srcdir
if test "`pwd`" != "$CONFIG_DIR"
then 
  AC_MSG_ERROR("This software does not support configuring from another directory.   See the INSTALL file")
fi

AC_SUBST(CONFIG_DIR)dnl
# Note: these will differ if one is a symbolic link
if test -f /usr/bin/dirname; then
  JD_Above_Dir=`dirname $CONFIG_DIR`
else
# system is a loser
  JD_Above_Dir=`cd ..;pwd`
fi
JD_Above_Dir2=`cd ..;pwd`
])dnl}}}

AC_DEFUN(JD_SET_OBJ_SRC_DIR, dnl {{{
[
#---------------------------------------------------------------------------
# Set the source directory and object directory.   The makefile assumes an
# abcolute path name.  This is because src/Makefile cds to OBJDIR and compiles
# the src file which is in SRCDIR
#---------------------------------------------------------------------------
SRCDIR=$CONFIG_DIR
if test "$1" != "."
then
  if test -z "$1"
  then
    SRCDIR=$SRCDIR/src
  else
    SRCDIR=$SRCDIR/$1
  fi
fi

OBJDIR=$SRCDIR/"$ARCH"objs
ELFDIR=$SRCDIR/elf"$ARCH"objs
AC_SUBST(SRCDIR)dnl
AC_SUBST(OBJDIR)dnl
AC_SUBST(ELFDIR)dnl
])dnl}}}

dnl  RPATH (-R or -rpath) handling {{{

RPATH=""
AC_SUBST(RPATH)dnl

AC_DEFUN(JD_INIT_RPATH,
[
case "$host_os" in
  *linux*|*solaris* )
    if test "X$GCC" = Xyes
    then
      if test "X$ac_R_nospace" = "Xno"
      then
        RPATH="-Wl,-R,"
      else
        RPATH="-Wl,-R"
      fi
    else
      if test "X$ac_R_nospace" = "Xno"
      then
        RPATH="-R "
      else
	RPATH="-R"
      fi
    fi
  ;;
  *osf*)
    if test "X$GCC" = Xyes
    then
      RPATH="-Wl,-rpath,"
    else
      RPATH="-rpath "
    fi
  ;;
esac
])

AC_DEFUN(JD_SET_RPATH,
[
if test "X$1" != "X"
then
  if test "X$RPATH" = "X"
  then 
    JD_INIT_RPATH
    if test "X$RPATH" != "X"
    then
      RPATH="$RPATH$1"
    fi
  else
    RPATH="$RPATH:$1"
  fi
fi
])
dnl }}}

AC_DEFUN(JD_SIMPLE_LIB_DIR,dnl {{{
[
changequote(<<, >>)dnl
define(<<JD_UP_NAME>>, translit($1, [a-z], [A-Z]))dnl
changequote([, ])dnl
JD_UP_NAME[]_LIB_DIR=$JD_Above_Dir/$1/libsrc/"$ARCH"objs
JD_UP_NAME[]_INCLUDE=$JD_Above_Dir/$1/libsrc

if test ! -d "[$]JD_UP_NAME[]_INCLUDE"
then
   JD_UP_NAME[]_LIB_DIR=$JD_Above_Dir/$1/src/"$ARCH"objs
   JD_UP_NAME[]_INCLUDE=$JD_Above_Dir/$1/src
   if test ! -d "[$]JD_UP_NAME[]_INCLUDE"
   then
     echo ""
     echo WARNING------Unable to find the JD_UP_NAME directory
     dnl echo You may have to edit $CONFIG_DIR/src/Makefile.
     echo ""
   fi
fi

AC_SUBST(JD_UP_NAME[]_LIB_DIR)dnl
AC_SUBST(JD_UP_NAME[]_INCLUDE)dnl
undefine([JD_UP_NAME])dnl
])dnl }}}

AC_DEFUN(JD_FIND_GENERIC,dnl {{{
[
changequote(<<, >>)dnl
define(<<JD_UP_NAME>>, translit($1, [a-z], [A-Z]))dnl
changequote([, ])dnl
# Look for the JD_UP_NAME package
#JD_UP_NAME[]_INCLUDE=""
#JD_UP_NAME[]_LIB_DIR=""

# This list consists of "include,lib include,lib ..."
JD_Search_Dirs="$JD_Above_Dir2/$1/libsrc,$JD_Above_Dir2/$1/libsrc/"$ARCH"objs \
                $JD_Above_Dir/$1/libsrc,$JD_Above_Dir/$1/libsrc/"$ARCH"objs \
		$JD_Above_Dir2/$1/src,$JD_Above_Dir2/$1/src/"$ARCH"objs \
                $JD_Above_Dir/$1/src,$JD_Above_Dir/$1/src/"$ARCH"objs"

test "x$exec" = "xNONE" && exec="$ac_default_prefix"
test "x$exec_prefix" = "xNONE" && exec_prefix="$prefix"
JD_Search_Dirs="$JD_Search_Dirs \
                $includedir,$libdir \
		$prefix/include,$exec_prefix/lib \
		$HOME/include,$HOME/lib"

if test -n "$ARCH"
then
 JD_Search_Dirs="$JD_Search_Dirs $HOME/include,$HOME/$ARCH/lib"
 JD_Search_Dirs="$JD_Search_Dirs $HOME/include,$HOME/sys/$ARCH/lib"
fi

if test -n "$slangdir" ; then
 JD_Search_Dirs="$slangdir/include,$slangdir/lib $JD_Search_Dirs"
fi

# Now add the standard system includes.  The reason for doing this is that 
# the other directories may have a better chance of containing a more recent
# version.

test "x$exec" = "xNONE" && exec="$ac_default_prefix"
test "x$exec_prefix" = "xNONE" && exec_prefix="$prefix"
JD_Search_Dirs="$JD_Search_Dirs \
                /usr/local/include,/usr/local/lib \
		/usr/include,/usr/lib \
		/usr/include/$1,/usr/lib \
		/usr/include/$1,/usr/lib/$1"

echo looking for the JD_UP_NAME library

for include_and_lib in $JD_Search_Dirs
do
  # Yuk.  Is there a better way to set these variables??
  generic_include=`echo $include_and_lib | tr ',' ' ' | awk '{print [$]1}'`
  generic_lib=`echo $include_and_lib | tr ',' ' ' | awk '{print [$]2}'`
  echo Looking for $1.h in $generic_include
  echo and lib$1.a in $generic_lib
  if test -r $generic_include/$1.h && test -r $generic_lib/lib$1.a
  then
    echo Found it.
    JD_UP_NAME[]_LIB_DIR="$generic_lib"
    JD_UP_NAME[]_INCLUDE="$generic_include"
    break
  else
    if test -r $generic_include/$1.h && test -r $generic_lib/lib$1.so
    then
      echo Found it.
      JD_UP_NAME[]_LIB_DIR="$generic_lib"
      JD_UP_NAME[]_INCLUDE="$generic_include"
      break
    fi
  fi
done

if test -n "[$]JD_UP_NAME[]_LIB_DIR"
then
    jd_have_$1="yes"
else
    echo Unable to find the $JD_UP_NAME library.  
    dnl echo You may have to edit $CONFIG_DIR/src/Makefile.
    JD_UP_NAME[]_INCLUDE=$JD_Above_Dir/$1/src
    JD_UP_NAME[]_LIB_DIR=$JD_Above_Dir/$1/src/"$ARCH"objs
    jd_have_$1="no"
fi

JD_UP_NAME[]_INC="-I[$]JD_UP_NAME[]_INCLUDE"
JD_UP_NAME[]_LIB="-L[$]JD_UP_NAME[]_LIB_DIR"
JD_SET_RPATH([$]JD_UP_NAME[]_LIB_DIR)

# gcc under solaris is often not installed correctly.  Avoid specifying
# -I/usr/include.
if test "[$]JD_UP_NAME[]_INC" = "-I/usr/include"
then
    JD_UP_NAME[]_INC=""
fi

if test "[$]JD_UP_NAME[]_LIB" = "-L/usr/lib"
then
    JD_UP_NAME[]_LIB=""
    RPATH_[]JD_UP_NAME=""
fi

AC_SUBST(JD_UP_NAME[]_LIB)dnl
AC_SUBST(JD_UP_NAME[]_INC)dnl
AC_SUBST(JD_UP_NAME[]_LIB_DIR)dnl
AC_SUBST(JD_UP_NAME[]_INCLUDE)dnl
dnl AC_SUBST(RPATH_[]JD_UP_NAME)dnl
undefine([JD_UP_NAME])dnl
])dnl }}}

AC_DEFUN(JD_FIND_SLANG, dnl {{{
[
JD_FIND_GENERIC(slang)
])dnl }}}

dnl C / C++ compiler settings {{{

AC_DEFUN(GCC_WARNINGS,
[
dnl This originated from JD_GCC_WARNINGS
AC_ARG_ENABLE(warnings,
	      [  --enable-warnings       turn on GCC compiler warnings],
	      [gcc_warnings=$enableval])
if test -n "$GCC" ; then
  CFLAGS="$CFLAGS -fno-strength-reduce -fno-strict-aliasing"
  if test -n "$gcc_warnings" ; then

  CFLAGS="$CFLAGS -Wall -W -pedantic -Winline -Wmissing-prototypes \
 -Wnested-externs -Wpointer-arith -Wcast-align -Wshadow -Wstrict-prototypes"
    # Now trim excess whitespace
    CFLAGS=`echo $CFLAGS`
  else
    # Always ensure that at least -Wall is specified for all GCC compiles
	case " $CFLAGS " in
	   *[\	\ ]-Wall[\	\ ]*) ;;
	   *) CFLAGS="$CFLAGS -Wall" ;;
	esac
  fi
fi
])

IEEE_CFLAGS=""
dnl-------------------------------------------------------------------------
AC_DEFUN(JD_IEEE_CFLAGS,
[
case "$host_cpu" in
  *alpha* )
    if test "$GCC" = yes
    then
      IEEE_CFLAGS="-mieee"
    else
      IEEE_CFLAGS="-ieee_with_no_inexact"
    fi
    ;;
  * )
    IEEE_CFLAGS=""
esac
])

AC_DEFUN(JD_ANSI_CC,
[

AC_PROG_CC
AC_PROG_CPP
AC_PROG_GCC_TRADITIONAL
AC_ISC_POSIX
AC_AIX

dnl #This stuff came from Yorick config script
dnl
dnl # HPUX needs special stuff
dnl
AC_EGREP_CPP(yes,
[#ifdef hpux
  yes
#endif
], [
AC_DEFINE(_HPUX_SOURCE)
if test "$CC" = cc; then CC="cc -Ae"; fi
])dnl
dnl
dnl #Be sure we've found compiler that understands prototypes
dnl
AC_MSG_CHECKING(C compiler that understands ANSI prototypes)
AC_TRY_COMPILE([ ],[
 extern int silly (int);], [
 AC_MSG_RESULT($CC looks ok.  Good.)], [
 AC_MSG_RESULT($CC is not a good enough compiler)
 AC_MSG_ERROR(Set env variable CC to your ANSI compiler and rerun configure.)
 ])dnl
])dnl
dnl #----------------------------------------------------------------------


AC_DEFUN(AC_ELF_COMPILER,
[

dnl # This macro was originally based upon the S-Lang JD_ELF_COMPILER

dnl #-------------------------------------------------------------------------
dnl # Check for dynamic linker
dnl #-------------------------------------------------------------------------
DYNAMIC_LINK_LIB=""
AC_CHECK_HEADER(dlfcn.h,[
  AC_DEFINE(HAVE_DLFCN_H)
  AC_CHECK_LIB(dl,dlopen,[
    DYNAMIC_LINK_LIB="-ldl"
    AC_DEFINE(HAVE_DLOPEN)
   ],[
    AC_CHECK_FUNC(dlopen,AC_DEFINE(HAVE_DLOPEN))
    if test "$ac_cv_func_dlopen" != yes
    then
      AC_MSG_WARN(cannot perform dynamic linking)
    fi
   ])])
AC_SUBST(DYNAMIC_LINK_LIB)

ELFLIB="lib${PACKAGE_NAME}.so"
ELFLIB_MAJOR="\$(ELFLIB).\$(ELF_MAJOR_VERSION)"
ELFLIB_MAJOR_MINOR="\$(ELFLIB).\$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION)"

dnl # ---------------------------------------------------------------------
dnl # Find path to GCC, since rest of macro requires it (added by mnoble)
dnl # ---------------------------------------------------------------------

CC_PATH=`AS_DIRNAME([$CC])`
AC_PATH_PROG([GCC_PATH],[gcc],[gcc],[$PATH $CC_PATH /usr/local/bin])

STRIP="strip"		dnl default to standard UNIX / X11 settings
SH_EXT=.so
PATH_SEP=$PATH_SEPARATOR

AC_PROG_CXX

case "$host_os" in

  *linux* )
    DYNAMIC_LINK_FLAGS="-Wl,-export-dynamic"
    ELF_CC="$GCC_PATH"
    ELF_CFLAGS="\$(CFLAGS) -fPIC"

    ELF_LINK_FLAGS="-shared -Wl,-soname#"
    ELF_LINK="$GCC_PATH $ELF_LINK_FLAGS"
    ELF_LINK_CMD="\$(ELF_LINK),\$(ELFLIB_MAJOR)"
    CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
    CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK),\$(ELFLIB_MAJOR)"

    ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="$GCC_PATH \$(CFLAGS) -shared -fPIC"
    ;;

  *solaris* )
    if test "$GCC" = yes ; then
      DYNAMIC_LINK_FLAGS=""
      ELF_CC="$GCC_PATH"
      ELF_CFLAGS="\$(CFLAGS) -fPIC"

      ELF_LINK_FLAGS="-shared -Wl,-ztext -Wl,-h#"
      ELF_LINK="$GCC_PATH $ELF_LINK_FLAGS"
      ELF_LINK_CMD="\$(ELF_LINK),\$(ELFLIB_MAJOR)"
      CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
      CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK),\$(ELFLIB_MAJOR)"

      ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
      CC_SHARED="$GCC_PATH \$(CFLAGS) -G -fPIC"
    else
      DYNAMIC_LINK_FLAGS=""
      ELF_CC="cc"
      ELF_CFLAGS="\$(CFLAGS) -KPIC"
      ELF_LINK_FLAGS="-G -h#"
      ELF_LINK="cc \$(ELF_CFLAGS)  $ELF_LINK_FLAGS"
      ELF_LINK_CMD="\$(ELF_LINK)\$(ELFLIB_MAJOR)"
      CXX_ELF_LINK="\$(CXX) \$(ELF_CFLAGS) $ELF_LINK_FLAGS"
      CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK)\$(ELFLIB_MAJOR)"

      if test `basename $CXX` != "CC"; then
	AC_MSG_ERROR(only Solaris CC compiler supported in this context)
      fi

      CXX_VERSION=`$CXX -V 2>&1| sed "s/.*\([[1-9]][[1-9]]*\.[[1-9]][[1-9\]]*\).*/\1/"`
      case $CXX_VERSION in
       3*) AC_MSG_ERROR(compiler is too old);;
       4*) CXX_LIBS="-lC";;
       *)  CXX_LIBS="-lCstd -lCrun";;
      esac

      ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
      CC_SHARED="cc \$(CFLAGS) -G -KPIC"

    fi
    ;;

   # osr5 or unixware7 with current or late autoconf
  *sco3.2v5* | *unixware-5* | *sco-sysv5uw7*)
     if test "$GCC" = yes ; then 
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="$GCC_PATH"
       ELF_CFLAGS="\$(CFLAGS) -fPIC"
       ELF_LINK_FLAGS="-shared -Wl,-h#"
       ELF_LINK="$GCC_PATH $ELF_LINK_FLAGS"
       ELF_LINK_CMD="\$(ELF_LINK),\$(ELFLIB_MAJOR)"
       CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
       CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK),\$(ELFLIB_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="$GCC_PATH \$(CFLAGS) -G -fPIC"
     else
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="cc"
       ELF_CFLAGS="-K pic"
       # ELF_LINK="ld -G -z text -h#"
       ELF_LINK_FLAGS="-G -z text -h#"
       ELF_LINK="cc $ELF_LINK_FLAGS"
       ELF_LINK_CMD="\$(ELF_LINK)\$(ELFLIB_MAJOR)"
       CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
       CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK)\$(ELFLIB_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="cc \$(CFLAGS) -G -K pic"
     fi
     ;;

  *irix6.5* )
     echo "Note: ELF compiler for host_os=$host_os may not be correct"
     echo "double-check: 'mode_t', 'pid_t' may be wrong!"
     if test "$GCC" = yes ; then 
       # not tested
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="$GCC_PATH"
       ELF_CFLAGS="\$(CFLAGS) -fPIC"
       ELF_LINK_FLAGS="-shared -Wl,-h#"
       ELF_LINK="$GCC_PATH $ELF_LINK_FLAGS"
       ELF_LINK_CMD="\$(ELF_LINK),\$(ELFLIB_MAJOR)"
       CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
       CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK),\$(ELFLIB_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="$GCC_PATH \$(CFLAGS) -shared -fPIC"
     else
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="cc"
       ELF_CFLAGS="-K pic"     # default anyhow
       ELF_LINK_FLAGS="-shared -o #"
       ELF_LINK="cc $ELF_LINK_FLAGS"
       ELF_LINK_CMD="\$(ELF_LINK)\$(ELFLIB_MAJOR)"
       CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
       CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK)\$(ELFLIB_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="cc \$(CFLAGS) -shared -K pic"
     fi
     ;;

  *darwin* )

     STRIP=":"
     DYNAMIC_LINK_FLAGS=""
     ELF_CC="cc"
     ELF_CFLAGS="\$(CFLAGS) -fno-common"
     ELF_LINK_FLAGS="-dynamiclib -single_module"
     ELF_LINK="cc $ELF_LINK_FLAGS"
     dnl The Darwin linker didn't seem to like a compatibility version
     dnl (major version) of 0, so until SLgtk reaches 1.0 we omit it.
     dnl ELF_LINK_CMD="\$(ELF_LINK) -install_name \$(install_lib_dir)/\$(ELFLIB_MAJOR) -compatibility_version \$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION) -current_version \$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION)"
     ELF_LINK_CMD="\$(ELF_LINK) -install_name \$(install_lib_dir)/\$(ELFLIB_MAJOR) -current_version \$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION)"

     CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
     CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK) -install_name \$(install_lib_dir)/\$(ELFLIB_MAJOR) -current_version \$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION)"

     ELF_DEP_LIBS="$LDFLAGS \$(DL_LIB)"
     CC_SHARED="cc -bundle -flat_namespace -undefined suppress \$(CFLAGS) -fno-common"
     ELFLIB="lib${PACKAGE_NAME}.dylib"
     ELFLIB_MAJOR="lib${PACKAGE_NAME}.\$(ELF_MAJOR_VERSION).dylib"
     ELFLIB_MAJOR_MINOR="lib${PACKAGE_NAME}.\$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION).dylib"
     ;;

  *cygwin* )
    ELF_CC="$CC"
    ELF_CFLAGS="\$(CFLAGS)"
    ELF_LINK_FLAGS="-shared"
    ELF_LINK="$CC $ELF_LINK_FLAGS"
    ELF_LINK_CMD="\$(ELF_LINK)"
    CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
    CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm"
    CC_SHARED="$CC \$(CFLAGS) -shared"
    ;;

  *mingw* )

    SH_EXT=.dll
    ELF_CC="$CC"
    ELF_CFLAGS="\$(CFLAGS)"
    ELF_LINK_FLAGS="-shared"
    ELF_LINK="$CC $ELF_LINK_FLAGS"
    ELF_LINK_CMD="\$(ELF_LINK)"
    CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
    CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm"
    CC_SHARED="$CC \$(CFLAGS) -shared"
    dnl avoid Unix/Win CR/LF issues
    COLLAPSE_BLANKS_FOR_REGR_TESTS="-b"
    CONFIG_DIR=`pwd -W`
    PATH_SEP=';'
    ;;

  * )
    STRIP=":"
    echo "Note: ELF compiler for host_os=$host_os may be wrong"
    ELF_CC="$CC"
    ELF_CFLAGS="\$(CFLAGS) -fPIC"
    ELF_LINK_FLAGS="-shared"
    ELF_LINK="$CC $ELF_LINK_FLAGS"
    ELF_LINK_CMD="\$(ELF_LINK)"
    CXX_ELF_LINK="\$(CXX) $ELF_LINK_FLAGS"
    CXX_ELF_LINK_CMD="\$(CXX_ELF_LINK)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="$CC \$(CFLAGS) -shared -fPIC"
esac

AC_SUBST(ELF_CC)
AC_SUBST(ELF_CFLAGS)
AC_SUBST(ELF_LINK)
AC_SUBST(ELF_LINK_FLAGS)
AC_SUBST(ELF_LINK_CMD)
AC_SUBST(CXX_ELF_LINK)
AC_SUBST(CXX_ELF_LINK_CMD)
AC_SUBST(CXX_LIBS)
AC_SUBST(ELF_DEP_LIBS)
AC_SUBST(DYNAMIC_LINK_FLAGS)
AC_SUBST(CC_SHARED)
AC_SUBST(ELFLIB)
AC_SUBST(ELFLIB_MAJOR)
AC_SUBST(ELFLIB_MAJOR_MINOR)
AC_SUBST(STRIP)
AC_SUBST(SH_EXT)
AC_SUBST(COLLAPSE_BLANKS_FOR_REGR_TESTS)
AC_SUBST(PATH_SEP)
])

AC_DEFUN(AC_CC_DEBUG_INFO, dnl {{{
[
AC_ARG_ENABLE(ccdebug,
	      [  --enable-ccdebug	  include -g debug info in ALL compiled C code],
	      [ccdebug=$enableval])

if test -n "$ccdebug" ; then
    cflags_has_dash_g=`echo $CFLAGS | grep -w "\-g"`
    if test -z "$cflags_has_dash_g" ; then
	CFLAGS="-g $CFLAGS"
    fi
    ELF_CFLAGS="-g $ELF_CFLAGS"
fi
])dnl }}}
dnl }}}

AC_DEFUN(JD_UPPERCASE, dnl#{{{
[
changequote(<<, >>)dnl
define(<<$2>>, translit($1, [a-z], [A-Z]))dnl
changequote([, ])dnl
])
#}}}

AC_DEFUN(JD_WITH_LIBRARY, dnl#{{{
[
JD_UPPERCASE($1,JD_ARG1)
AC_ARG_WITH($1,
  [  --with-$1=DIR		Use DIR/lib and DIR/include for $1],
  [jd_with_$1_arg=$withval], [jd_with_$1_arg=no])
case "x$jd_with_$1_arg" in
xno)
  ;;
x)
  AC_MSG_ERROR(--with-$1 requres a value)
  ;;
*)
   JD_ARG1[]_INC=-I$jd_with_$1_arg/include
   JD_ARG1[]_LIB=-L$jd_with_$1_arg/lib
   JD_SET_RPATH($jd_with_$1_arg/lib)
  ;;
esac

AC_ARG_WITH($1lib,
  [  --with-$1lib=DIR		$1 library in DIR],
  [jd_with_$1lib_arg=$withval], [jd_with_$1lib_arg=no])
case "x$jd_with_$1lib_arg" in
xno)
  ;;
x)
  AC_MSG_ERROR(--with-$1lib requres a value)
  ;;
*)
   JD_ARG1[]_INC=-I$jd_with_$1lib_arg
   JD_ARG1[]_LIB=-L$jd_with_$1lib_arg
   JD_SET_RPATH($jd_with_$1lib_arg)
  ;;
esac

AC_ARG_WITH($1inc, 
  [  --with-$1inc=DIR		$1 include files in DIR],
  [jd_with_$1inc_arg=$withval], [jd_with_$1inc_arg=no])
case "x$jd_with_$1inc_arg" in
x)
  AC_MSG_ERROR(--with-$1inc requres a value)
  ;;
xno)
  ;;
*)
   JD_ARG1[]_INC=-I$jd_with_$1inc_arg
  ;;
esac
AC_SUBST(JD_ARG1[]_INC)
AC_SUBST(JD_ARG1[]_LIB)
])
dnl#}}}

AC_DEFUN(JD_SLANG_MODULE_INSTALL_DIR, dnl#{{{
[
MODULE_INSTALL_DIR=$libdir/slang/modules
SL_FILES_INSTALL_DIR=$datadir/slsh/local-packages
AC_SUBST(MODULE_INSTALL_DIR)
AC_SUBST(SL_FILES_INSTALL_DIR)
])
#}}}

AC_DEFUN(AC_FIND_SLANG, dnl {{{
[

test "x$prefix" = "xNONE" && prefix="$ac_default_prefix"
JD_WITH_LIBRARY(slang)
if test -z "$SLANG_INC" ; then
   SLANG_INC="-I$prefix/include"
   echo "S-Lang include directory not specified, defaulting to $SLANG_INC"
   AC_SUBST(SLANG_INC)
fi
if test -z "$SLANG_LIB" ; then
   SLANG_LIB="-L$prefix/lib"
   echo "S-Lang lib directory not specified, defaulting to $SLANG_LIB"
   JD_SET_RPATH($prefix/lib)
   AC_SUBST(SLANG_LIB)
fi

inc=`echo $SLANG_INC | cut -c 3-`
if test -z "$inc" ; then
   inc=$prefix/include/slang.h
else
   inc=$inc/slang.h
fi
if test -f $inc ; then
   slver=`grep -w SLANG_VERSION [$]inc|grep "#define"|tr '\t' ' '|cut -d' ' -f3`
   required_slang_version_as_int=`echo $1 | tr '.' '0'`
   if test -z "$slver" || test $slver -lt $required_slang_version_as_int ; then
	AC_MSG_ERROR([S-Lang $1 or greater is required for this software])
   fi
   SLANG_VERSION=$slver
else
   AC_MSG_ERROR([could not find include/slang.h])
fi
SLANG_LIB_STATIC=`echo $SLANG_LIB| cut -c 3-`/libslang.a
AC_SUBST(SLANG_LIB_STATIC)
AC_SUBST(SLANG_VERSION)

JD_SLANG_MODULE_INSTALL_DIR
])dnl }}}

AC_DEFUN(AC_FIND_SLSH, dnl {{{
[
if test -n "$slangdir" && test -x $slangdir/bin/slsh ; then
 slsh=$slangdir/bin/slsh
else
  AC_PATH_PROG([slsh],[slsh],[],[/bin /usr/bin /usr/local/bin /opt/local/bin $PATH])
fi
if test -z "$slsh" ; then
   dnl default to using slsh bundled/built with SLIRP/SLgtk
   dnl (requires prior invocation of JD_INIT)
   slsh=$CONFIG_DIR/slsh
fi
AC_SUBST(slsh)
])dnl }}}

AC_DEFUN(AC_GET_DATE, dnl {{{
[
AC_PATH_PROG([DATE],[date],[],[/bin /usr/bin /usr/local/bin $PATH])
if test -n "$DATE" ; then
   date=`${DATE}`
else
   date=unknown
fi
AC_SUBST(date)
])dnl }}}

AC_DEFUN(SAFE_AC_PROG_FC, dnl {{{
[
   dnl The AC_PROG_FC macro in autoconf 2.59 is broken, in that it aborts when
   dnl a FORTRAN compiler cannot be found, instead of simply setting FC=""
   pushdef([AC_MSG_ERROR], [HAVE_FC=0])
   AC_PROG_FC
   if test -z "$FC" || test "X$FC" = "Xno"; then
	FC=
	HAVE_FC=0
   else
	HAVE_FC=1
   fi
   popdef([AC_MSG_ERROR])
   AC_SUBST(HAVE_FC)
])dnl }}}

AC_DEFUN(SAFE_AC_FC_MANGLE, dnl {{{
[
   pushdef([AC_MSG_ERROR], [FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX= ; FC_MANGLE_EXTRA_USCORE=0; FCRPATH= ;])
   if test $HAVE_FC -eq 1 ; then
	AC_FC_WRAPPERS
	AC_FC_FUNC(a)
	case $a in
	   A)	FC_MANGLE_UPCASE=1; FC_MANGLE_SUFFIX="";;
	   A_)	FC_MANGLE_UPCASE=1; FC_MANGLE_SUFFIX="_";;
	   A__)	FC_MANGLE_UPCASE=1; FC_MANGLE_SUFFIX="__";;
	   a)	FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX="";;
	   a_)	FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX="_";;
	   a__)	FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX="__";;
	   *)	AC_MSG_WARN([unknown Fortran mangling convention])
		FC_MANGLE_UPCASE=0; FC_MANGLE_SUFFIX="_"
		;;
	esac

	AC_FC_FUNC(_,a)
	case $a in
	_${FC_MANGLE_SUFFIX})   FC_MANGLE_EXTRA_USCORE=0;;
	_${FC_MANGLE_SUFFIX}_)  FC_MANGLE_EXTRA_USCORE=1;;
	*)   AC_MSG_WARN([unknown Fortran extra-underscore mangling convention])
	     FC_MANGLE_EXTRA_USCORE=0;;
	esac

	SAVE_RPATH=$RPATH
	RPATH=""
	for l in $FCLIBS; do
	   opt=`echo $l | cut -c1-2`
	   if test "$opt" = "-L" ; then
		JD_SET_RPATH(`echo $l | cut -c3-`)
	   else
		FCLIBS_NAMES="$FCLIBS_NAMES $l"
	   fi
	done
	FCRPATH=$RPATH
	RPATH=$SAVE_RPATH
   fi
   popdef([AC_MSG_ERROR])
   AC_SUBST(FC_MANGLE_UPCASE)
   AC_SUBST(FC_MANGLE_SUFFIX)
   AC_SUBST(FC_MANGLE_EXTRA_USCORE)
   AC_SUBST(FCRPATH)
   AC_SUBST(FCLIBS_NAMES)
])dnl }}}

AC_DEFUN(GET_TYPE_MNEMONIC_I, dnl {{{
[
  case $2 in
	1)  $1[]_mnemonic=${3}char;;
	$ac_cv_sizeof_short) $1[]_mnemonic=${3}short;;
	$ac_cv_sizeof_int) $1[]_mnemonic=${3}int ;;
	$ac_cv_sizeof_long) $1[]_mnemonic=${3}long ;;
	$ac_cv_sizeof_long_long) $1[]_mnemonic=${3}llong;;
	*) AC_MSG_ERROR([could not determine type mnemonic for $1]);;
  esac
  AC_SUBST($1[]_mnemonic)
])
dnl }}}

AC_DEFUN(GET_TYPE_MNEMONIC_R, dnl {{{
[
  case $2 in
	$ac_cv_sizeof_float) $1[]_mnemonic=float ;;
	$ac_cv_sizeof_double) $1[]_mnemonic=double;;
	$ac_cv_sizeof_long_double) $1[]_mnemonic=ldouble;;
	*)  $1[]_mnemonic=unsupported;;
  esac
  AC_SUBST($1[]_mnemonic)
])
dnl }}}

AC_DEFUN(AC_SLIRP_FINALIZE, dnl {{{
[
   if ! test -s VERSION ; then
	AC_MSG_ERROR([could not find VERSION file])
   fi

   AC_SUBST(nvec)
   AC_ARG_WITH(nvec,
      [  --with-nvec=NUM		Set maximum number of function arguments
				which may be vectorized (default==10)],
	nvec=$withval, nvec=10)

   JD_UPPERCASE(AC_PACKAGE_NAME,MODULE_NAME)

   MAJOR_VERSION=`cat VERSION | cut -d. -f1`
   MINOR_VERSION=`cat VERSION | cut -d. -f2`
   MICRO_VERSION=`cat VERSION | cut -d. -f3`

   MODULE_NAME[]_VERSION_STRING=${MAJOR_VERSION}.${MINOR_VERSION}.${MICRO_VERSION}
   MODULE_NAME[]_VERSION=`expr \( 10000 \* $MAJOR_VERSION \) + \( 100 \* $MINOR_VERSION \) + $MICRO_VERSION`

   if test -n "$DEVEL_BUILD" ; then
	DEVEL_BUILD=true
   fi

   if test -f REVISION ; then
	REVISION=`cat REVISION | grep -v \#`
   else
	REVISION=
   fi
   MODULE_NAME[]_REVISION=$REVISION

   AC_SUBST(MODULE_NAME[]__VERSION)
   AC_SUBST(MODULE_NAME[]_VERSION_STRING)
   AC_SUBST(MODULE_NAME[]_REVISION)
   AC_SUBST(DEVEL_BUILD)
   AC_DEFINE_UNQUOTED(MODULE_NAME[]_VERSION,$MODULE_NAME[]_VERSION)
   AC_DEFINE_UNQUOTED(MODULE_NAME[]_VERSION_STRING,"$MODULE_NAME[]_VERSION_STRING")

   AC_CHECK_SIZEOF(short)
   AC_CHECK_SIZEOF(int)
   AC_CHECK_SIZEOF(long)
   AC_CHECK_SIZEOF(long long)
   AC_CHECK_SIZEOF(unsigned long long)
   AC_CHECK_SIZEOF(float)
   AC_CHECK_SIZEOF(double)
   AC_CHECK_SIZEOF(long double)
   AC_CHECK_SIZEOF(char *)
   AC_CHECK_SIZEOF(ptrdiff_t)
   AC_CHECK_SIZEOF(size_t)

   GET_TYPE_MNEMONIC_I(ptrdiff_t, $ac_cv_sizeof_ptrdiff_t)
   GET_TYPE_MNEMONIC_I(size_t, $ac_cv_sizeof_size_t, u)
   GET_TYPE_MNEMONIC_I(int16, 2)
   GET_TYPE_MNEMONIC_I(uint16, 2, u)
   GET_TYPE_MNEMONIC_I(int32, 4)
   GET_TYPE_MNEMONIC_I(uint32, 4, u)
   GET_TYPE_MNEMONIC_I(int64, 8)
   GET_TYPE_MNEMONIC_I(uint64, 8, u)
   GET_TYPE_MNEMONIC_I(long_long, $ac_cv_sizeof_long_long)
   GET_TYPE_MNEMONIC_I(ulong_long, $ac_cv_sizeof_long_long, u)
   AC_LANG_PUSH(C++)
   AC_CHECK_SIZEOF(bool)
   AC_LANG_POP()
   if test $ac_cv_sizeof_bool -eq 0 ; then
	ac_cv_sizeof_bool=1
   fi
   GET_TYPE_MNEMONIC_I(bool, $ac_cv_sizeof_bool)
   GET_TYPE_MNEMONIC_R(float32, 4)
   GET_TYPE_MNEMONIC_R(float64, 8)
   GET_TYPE_MNEMONIC_R(float96, 12)
   test $ac_cv_sizeof_long_long -eq 0
   HAVE_LONG_LONG=$?
   AC_SUBST(HAVE_LONG_LONG)
])
dnl }}}
