Name:		slat
Version:	1.2.6
Release:	1
Source:		%{name}-%{version}.tar.gz
Vendor:		The MITRE Corporation

URL:		http://selinux.sf.net/
Packager:	SELinux project <http://selinux.sf.net/>
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot

Summary:	Tools for information flow analysis of SELinux policies
License:	GPL
Group:		System Environment/Base

PreReq:		/sbin/install-info

%description 
Security-Enhanced Linux Analysis Tools (slat) provide a systematic way
to determine if security goals are achieved by a given SELinux policy
configuration.  In particular, slat is concerned with information flow
security goals, which describe desired paths by which information
moves throughout a system.  We provide a simple syntax in which to
express these goals, and tools that check a policy configuration
against the goals.

# disable build root strip policy
%define __spec_install_post /usr/lib/rpm/brp-compress || :
%define debug_package %{nil}
# Binaries created by O'Caml will fail to find the bytecode they
# contain if they are stripped.

%prep
%setup -q

%build
%configure
make

%install
rm -rf %{buildroot}
%makeinstall

%clean
rm -rf %{buildroot}

%post
if [ -f %{_infodir}/%{name}.info.gz ]; then
  /sbin/install-info %{_infodir}/%{name}.info.gz %{_infodir}/dir
fi

%postun
if [ $1 -eq 0 ]; then
  if [ -f %{_infodir}/%{name}.info.gz ]; then
    /sbin/install-info --delete %{_infodir}/%{name}.info.gz %{_infodir}/dir
  fi
fi

%files
%defattr (-, root, root)
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%{_bindir}/*
%{_libdir}/*
%{_includedir}/%{name}/*
%{_mandir}/man1/*
%{_infodir}/*
%{_datadir}/%{name}/*
