/*
  Semantic actions called during parsing and input file setup.
  Copyright (C) 2005 The MITRE Corporation

  Author: John D. Ramsdell

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

#if !defined ACTION_H
#define ACTION_H

#ifdef __cplusplus
extern "C"
{
#endif

/* To use the formula parser, you must implement the following three
   action routines, and the symbol interface.  */

/* Called when the parser finds a labeled transition system. */
void parsed_lts(lts_t);
/* Called when the parser finds a sequence of diagrams. */
void parsed_diagrams(diagram_list_t);
/* Called when the parser finds a transition. */
void parsed_transition(tran_t);

/* This routine sets the input file to be used by the formula parser.
   When given a null pointer, input is taken from the standard input
   stream.  */
int setfile(const char *);

/* In addition to setting the input file, you must

   1. initialize the symbol table with

      intern_init();

   2. declare the formula stack with

      formula_stack(stack);

   3. and finally invoke the parser with

      i = yyparse();

   A side-effect of a successful parse will be a call to one of the
   above action routines.  */

#ifdef __cplusplus
}
#endif

#endif
