/*****************************************************************
/
/ File   :   AdmHndlr.c
/ Author :   David Corcoran
/ Date   :   October 15, 1999
/ Purpose:   This handles administrative functions like reset/power.
/            See http://www.linuxnet.com for more information.
/ License:   See file LICENSE
/
******************************************************************/

#include "LinuxDefines.h"
#include "AdmHndlr.h"
#include "serial.h"


ULONG Adm_SetWWT( ULONG ulWWT ) {
  IO_UpdateReturnBlock( ulWWT );
  return STATUS_SUCCESS;
}

ULONG Adm_SetMode( ULONG ulMode, ULONG ulWWT ) {

  unsigned char pcSetModeA[6] = {0x61, 0x00, 0x00, 0x10, 0x00, 0x00};
  unsigned char pcSetModeB[6] = {0x61, 0x10, 0x00, 0x00, 0x4D, 0x00};  
  unsigned char pcSetMode[6];
  char BackByte;
  int i;

  if ( ulMode == 0 ) {
    memcpy(pcSetMode, pcSetModeA, 6);
  } else if ( ulMode == 1 ) {

  if ( ulWWT > 0 ) {
    pcSetModeB[1] = 0x11;
    pcSetModeB[5] = ulWWT;
  }

  memcpy(pcSetMode, pcSetModeB, 6);

  } else {
    return STATUS_UNSUCCESSFUL;
  }

  for (i=0; i<6; i++) {
    if ( IO_Write(pcSetMode[i]) ) {
      if ( IO_Read( 1, &BackByte ) ) {
	if ( BackByte == 0x62 ) {
	  continue;
	} else {
	  return STATUS_UNSUCCESSFUL;
	}
      }
    }
  }

  return STATUS_SUCCESS;  
}
