#ifndef _SLGSL_MODULE_H_
#define _SLGSL_MODULE_H_

extern void slgsl_reset_errors (void);
extern void slgsl_check_errors (char *module_name);


typedef struct
{
   double x;
   double *xp;
   SLang_Array_Type *at;
   unsigned int num_elements;
   unsigned int inc;
}
SLGSL_Double_Array_Type;

typedef struct
{
   int x;
   int *xp;
   SLang_Array_Type *at;
   unsigned int num_elements;
   unsigned int inc;
}
SLGSL_Int_Array_Type;

extern int slgsl_create_d_array (SLGSL_Double_Array_Type *a, SLGSL_Double_Array_Type *b);
extern void slgsl_free_i_array (SLGSL_Int_Array_Type *a);
extern void slgsl_free_d_array (SLGSL_Double_Array_Type *a);
extern int slgsl_push_i_array (SLGSL_Int_Array_Type *a, int do_free);
extern int slgsl_push_d_array (SLGSL_Double_Array_Type *a, int do_free);

extern int slgsl_pop_d_array (SLGSL_Double_Array_Type *a, int);
extern int slgsl_pop_i_array (SLGSL_Int_Array_Type *a, int);
extern int slgsl_pop_dd_array (SLGSL_Double_Array_Type *a, SLGSL_Double_Array_Type *b, int);
extern int slgsl_pop_id_array (SLGSL_Int_Array_Type *a, SLGSL_Double_Array_Type *b, int);
extern int slgsl_pop_idd_array (SLGSL_Int_Array_Type *a, SLGSL_Double_Array_Type *b, SLGSL_Double_Array_Type *c, int);
extern int slgsl_pop_iid_array (SLGSL_Int_Array_Type *a, SLGSL_Int_Array_Type *b, SLGSL_Double_Array_Type *c, int);
extern int slgsl_pop_iidd_array (SLGSL_Int_Array_Type *a, SLGSL_Int_Array_Type *b, SLGSL_Double_Array_Type *c, SLGSL_Double_Array_Type *d, int);
extern int slgsl_pop_ddd_array (SLGSL_Double_Array_Type *a, SLGSL_Double_Array_Type *b, SLGSL_Double_Array_Type *c, int);
extern int slgsl_pop_dddd_array (SLGSL_Double_Array_Type *a, SLGSL_Double_Array_Type *b, 
				 SLGSL_Double_Array_Type *c, SLGSL_Double_Array_Type *d, int);


extern void slgsl_do_d_d_fun (char *fun, double (*f)(double));
extern void slgsl_do_d_i_fun (char *fun, double (*f)(int));
extern void slgsl_do_d_dd_fun (char *fun, double (*f)(double, double));
extern void slgsl_do_d_ddd_fun (char *fun, double (*f)(double, double, double));
extern void slgsl_do_d_dddd_fun (char *fun, double (*f)(double, double, double,double));
extern void slgsl_do_d_id_fun (char *fun, double (*f)(int, double));
extern void slgsl_do_d_idd_fun (char *fun, double (*f)(int, double, double));
extern void slgsl_do_d_iid_fun (char *fun, double (*f)(int, int, double));
extern void slgsl_do_d_iidd_fun (char *fun, double (*f)(int, int, double, double));
extern void slgsl_do_i_d_fun (char *fun, int (*f)(double));

extern int init_gslcdf_module_ns (char *);
extern void deinit_gslcdf_module (void);

extern int init_gslconst_module_ns (char *);
extern void deinit_gslconst_module (void);

extern int init_gslfft_module_ns (char *);
extern void deinit_gslfft_module (void);

extern int init_gslinterp_module_ns (char *);
extern void deinit_gslinterp_module (void);

extern int init_gslmatrix_module_ns (char *);
extern void deinit_gslmatrix_module (void);

extern int init_gslrand_module_ns (char *);
extern void deinit_gslrand_module (void);

extern int init_gslsf_module_ns (char *);
extern void deinit_gslsf_module (void);

#endif
