
AC_PREREQ(2.52)

AC_DEFUN(AC_SLGTK_STATIC_MODULE_INIT,
[

abs_builddir=`pwd`
if test "$abs_builddir" = "$prefix" ; then
   AC_MSG_ERROR([Using the current directory as the installation directory is prohibited])
fi

AC_PATH_PROG([slsh],[slsh],[],
   			[$PATH /usr/local/bin /opt/local/bin /usr/bin /bin])

if test -z "$slsh" ; then
   AC_MSG_ERROR([Cannot find an slsh installation])
fi

slsh_dir=`AS_DIRNAME($slsh)`
slsh_parent_dir=`AS_DIRNAME($slsh_dir)`
if test "x$prefix" = "xNONE" ; then
   prefix=$slsh_parent_dir
else
   if test "$prefix" != "$slsh_parent_dir" ; then
	AC_MSG_WARN([$prefix != parent directory of bin/slsh])
   fi
fi

AC_MSG_CHECKING(SLang version as reported by slsh)
slang_major_ver=`$slsh --version | grep -i library |cut -d: -f2|cut -d. -f1`
slang_major_ver=`echo $slang_major_ver | tr -d [:space:]`
AC_MSG_RESULT($slang_major_ver)

AC_MSG_CHECKING(That module was compiled with same S-Lang major version as slsh)
$slsh slangver.sl
if test $? -eq 0 ; then
   AC_MSG_RESULT(yes)
else
   AC_MSG_ERROR(no)
fi

slgtk_conf_dir=$sysconfdir/slgtk
case $slang_major_ver in
  1*) MODULE_INSTALL_RELATIVE_PATH=slang/modules ;;
  *) MODULE_INSTALL_RELATIVE_PATH=slang/v$slang_major_ver/modules ;;
esac
MODULE_INSTALL_DIR=$libdir/$MODULE_INSTALL_RELATIVE_PATH

SL_FILES_INSTALL_DIR=$datadir/slsh/local-packages
AC_SUBST(MODULE_INSTALL_DIR)
AC_SUBST(MODULE_INSTALL_RELATIVE_PATH)
AC_SUBST(SL_FILES_INSTALL_DIR)

AC_SUBST(slsh)
AC_SUBST(slgtk_conf_dir)
])
