
% A simple function to streamline inspection/testing of a widget
% appearance, by doing all the work necessary to make it appear
% within a window.  An optional callback is supported, which can
% be attached to a button with the specified label.  This can be
% used, e.g., to provides a very convenient printing hook.
%
% The displayed widget will become an ancestor of the window
% created here, and thus will be destroyed when it goes away.

require("gtk");

static variable action_cb = NULL;
static variable action_cb_args = NULL;

define wdisplay()
{
   variable widget, label;
   switch (_NARGS)
	{ case 0: usage("wdisplay(widget [, action_button_label, "+
				"action_button_callback, [, cbarg1, ...]]"); }
	{ case 1: widget = (); label = NULL; }
	{ case 2: (widget,label) = (); }
	{ action_cb_args = __pop_args(_NARGS-3); (widget,label,action_cb) = ();}

   variable win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   if (gtk_main_level() == 0)
	() = g_signal_connect(win,"destroy",&gtk_main_quit);

   variable vbox = gtk_vbox_new(FALSE,FALSE);
   gtk_container_add(win,vbox);

   gtk_container_add(vbox,widget);
   gtk_widget_realize(widget);
   () = g_signal_connect(vbox,"destroy",&gtk_container_remove,widget);

   variable hbox = gtk_hbox_new(FALSE,FALSE);
   gtk_box_pack_end(vbox,hbox,FALSE,FALSE,0);

   variable button = gtk_button_new_with_label("Quit");
   gtk_box_pack_start(hbox,button,FALSE,FALSE,0);
   () = g_signal_connect_swapped(button,"clicked",&gtk_widget_destroy,win);

   if (label != NULL) {

	button = gtk_button_new_with_label(label);
	gtk_box_pack_end(hbox,button,FALSE,FALSE,0);

	if (action_cb != NULL)
	   () = g_signal_connect_swapped(button,"clicked",action_cb,
						__push_args(action_cb_args));
   }

   variable hsep = gtk_hseparator_new();
   gtk_box_pack_end(vbox,hsep,FALSE,FALSE,5);
   gtk_widget_show_all (win);

   if (gtk_main_level() > 0) {
	while (gtk_events_pending())
	   () = gtk_main_iteration_do(FALSE);
   }
   else
      gtk_main();
}

provide("wdisplay");
