
typedef struct _Slirp_Ref {
   SLtype		sltype;
   size_t		sizeof_refd_type;
   void			**data;
   unsigned int		flags;
#define	REF_FLAG_FREE_DATA_DURING_FINALIZE	0x1
#define	REF_FLAG_IS_MMT_REF			0x2
   SLang_Array_Type	*array;
   SLang_Ref_Type	*ref;
   SLang_MMT_Type	*mmt;		/* supports passing around arrays */
   					/* of indeterminate size	  */
} Slirp_Ref;

static Slirp_Ref*  ref_new(SLtype t, size_t sizeof_refd_type, void *d)
{
   Slirp_Ref *ref;

   if ((ref = (Slirp_Ref*)SLcalloc( sizeof(Slirp_Ref), 1)) != NULL) {
	ref->sltype = t;
	ref->sizeof_refd_type = sizeof_refd_type;
	ref->data = (void**)d;
   }

   return ref;
}

static int ref_finalize(Slirp_Ref *sref)
{
   int status = 0;
   if (sref == NULL) return 0;

   if (sref->ref) {

        void *ref_value = NULL; SLtype ref_type = 0; double dc[2];

	/* wrap aggregate/opaque types in mmt before ref assign; mmt will
	   be freed when the associated S-Lang object goes out of scope */
	if (sref->flags & REF_FLAG_IS_MMT_REF) {
#ifdef NUM_RESERVED_OPAQUES
	   void *opaque_value = **((void ***)sref->data);
	   if (opaque_value == NULL) {
		ref_value = NULL;
		ref_type = SLANG_NULL_TYPE;
	   }
	   else {
		SLang_MMT_Type *mmt = create_opaque_mmt(sref->sltype,
							opaque_value, 0);
		ref_value = &mmt;
		ref_type = sref->sltype;
	   }
#endif
	}
	else {

	   ref_type = sref->sltype;

	   if (ref_type == SLANG_COMPLEX_TYPE &&
					sref->sizeof_refd_type < sizeof(dc)) {
		float *fc = (float*) *sref->data;
		dc[0] = fc[0];
		dc[1] = fc[1];
		ref_value = dc;
	   }
	   else
		ref_value = *sref->data;
	}

	status = SLang_assign_to_ref (sref->ref, ref_type, ref_value);
	SLang_free_ref(sref->ref);
   }
   else if (sref->array)
	SLang_free_array(sref->array);
   else if (sref->mmt)
	SLang_free_mmt(sref->mmt);

   if (sref->flags & REF_FLAG_FREE_DATA_DURING_FINALIZE)
	SLfree((char*)*sref->data);

   SLfree((char*)sref);

   return status;
}

static unsigned int  ref_get_size(Slirp_Ref *sref, int which_dimension)
{
   /* Trick: avoid strict compiler warnings if this func winds up unused */
   unsigned int size = (unsigned int)&ref_get_size;

   /* Slirp_Ref encapsulates arrays, S-Lang refs, and S-Lang mmt types,   */
   /* the latter two of which are considered to point to a single object  */

   if (sref->array) {
	if (which_dimension == 0)
	   size = (unsigned int)sref->array->num_elements;
	else if (which_dimension < 0)
	   size = sref->array->num_dims;
	else {
	   which_dimension--;
	   if ((unsigned int)which_dimension < sref->array->num_dims)
		size = (unsigned int)sref->array->dims[which_dimension];
	   else
		size = 0;
	}
   }
   else
	   size = 1;

   return size;
}

#ifdef __cplusplus
extern "C" 
#endif
int _SLang_get_class_type (SLtype t);          /* quasi-public  */


#ifdef NUM_RESERVED_OPAQUES
static SLtype sltype_to_opaque_ptr_type(SLtype sltype)
{
   Reserved_Opaque_Type *pt;

   if (sltype > Last_Reserved_Opaque_Type) return opaque_ptr_Type;

   /* Sequential search (see above), but should still be less than O(n)   */
   /* since list is ordered by expected frequency of use for each SLtype. */
   pt = Reserved_Opaque_Types;
   while (pt->name) {
	if (pt->masked_type == sltype)
	   return *pt->type;
	pt++;
   }
   return 0;
}
#endif

static int pop_array_or_ref(Slirp_Ref *sref, int nullable, int defaultable)
{
   SLtype type;
   unsigned int objtype;
#ifdef NUM_RESERVED_OPAQUES
   unsigned int is_opaque;
#endif

   if (sref == NULL) {
	SLang_verror(SLEI, (char*)"Attempted to pop into a NULL reference");
	return -1;
   }

   if (defaultable && SLang_Num_Function_Args < defaultable) {
	sref->ref   = NULL;	/* observe that only NULL can be */
	*sref->data = NULL;	/* assigned as the default value */
	return 0;
   }
   
   objtype = SLang_peek_at_stack();

   if (nullable && objtype == SLANG_NULL_TYPE) {
	sref->ref   = NULL;
	*sref->data = NULL;
	return SLang_pop_null ();
   }

   type = sref->sltype;

#ifdef NUM_RESERVED_OPAQUES
   is_opaque =(type >= First_Opaque_Type && sltype_to_slirp_type(type) != NULL);
   if (is_opaque) sref->flags |= REF_FLAG_IS_MMT_REF;
#endif

   switch(objtype) {

	case SLANG_ARRAY_TYPE:

	   if (SLang_pop_array_of_type(&sref->array,type) == -1)
		return -1;

#ifdef NUM_RESERVED_OPAQUES
	   if (is_opaque) {

	      	Slirp_Opaque *ot;
	      	unsigned int i = sref->array->num_elements;
		SLang_MMT_Type** mmts = (SLang_MMT_Type**)sref->array->data;
		void **arr = (void**)SLmalloc(i * sizeof(void*) );
		if (arr == NULL)
		   return -1;

		while (i--) {
		   ot = (Slirp_Opaque*) SLang_object_from_mmt (mmts[i]);
		   if (ot == NULL) {
			SLfree((char*)arr);
			return -1;
		   }
		   arr[i] = ot->instance;
		}

		*sref->data = (void*)arr;
		sref->flags |= REF_FLAG_FREE_DATA_DURING_FINALIZE;
	   }
	   else
#endif
		*sref->data = sref->array->data;

	   break;

	case SLANG_REF_TYPE:

	   /* Refs can only send values one-way (C to S-Lang, not reverse) */
	   if (SLang_pop_ref(&sref->ref) == -1)
		return -1;

	   /* Ref is assumed to point to a scalar instance of the  */
	   /* refd type, so declare enough space to hold one such. */
	   *sref->data = (void*)SLmalloc(sref->sizeof_refd_type);
	   if (*sref->data == NULL) return -1;
	   memset(*sref->data, 0, sref->sizeof_refd_type);
	   sref->flags |= REF_FLAG_FREE_DATA_DURING_FINALIZE;
	   break;

	case SLANG_CHAR_TYPE:		/* treat scalar instances of basic */
	case SLANG_UCHAR_TYPE:		/* types as 1-elementn arrays      */
	case SLANG_SHORT_TYPE:
	case SLANG_USHORT_TYPE:
	case SLANG_INT_TYPE:
	case SLANG_UINT_TYPE:
	case SLANG_LONG_TYPE:
	case SLANG_ULONG_TYPE:
	case SLANG_FLOAT_TYPE:
	case SLANG_COMPLEX_TYPE:
	case SLANG_DOUBLE_TYPE:

	{  /* Accomodate FORTRAN-style pass by reference semantics */

	   if (map_scalars_to_refs && 
		 	SLang_pop_array_of_type(&sref->array,type) == 0) {

		*sref->data = (void*)SLmalloc(sref->sizeof_refd_type);
		if (*sref->data == NULL) return -1;

		if (sref->sizeof_refd_type == sref->array->sizeof_type)
		   memcpy(*sref->data,sref->array->data,sref->sizeof_refd_type);
		else if (type == SLANG_COMPLEX_TYPE) {
		   double *dc = (double*) sref->array->data;
		   float  *fc = (float*) *sref->data;
		   fc[0] = (float)dc[0];
		   fc[1] = (float)dc[1];
		}
		else  {
		   SLang_verror(SL_TYPE_MISMATCH, (char*)
			"mismatched type sizes, when popping scalar as ref");
		   return -1;
		}

		sref->flags |= REF_FLAG_FREE_DATA_DURING_FINALIZE;
		break;
	   }
	}			/* intentional fallthrough */

	default:

	   {
#ifdef NUM_RESERVED_OPAQUES
		SLtype opaque_ptr = sltype_to_opaque_ptr_type(type);
		if (opaque_ptr) {

		   Slirp_Opaque *otp;
		   if (SLang_pop_opaque(opaque_ptr, NULL, &otp) == -1)
			return -1;

		   *sref->data = otp->instance;
		   sref->mmt = otp->mmt;
		   return 0;
		}
#endif
		SLang_verror(SL_TYPE_MISMATCH,
				(char*)"context requires array or reference");
		return -1;
	   }
   }

   return 0;
}
