
% GtkOpaque (gpointer et al) {{{

slirp_define_opaque("GtkOpaque");	% This definition must remain first
slirp_map_opaque("GList*");
slirp_map_opaque("GClosure*");
slirp_map_opaque("GScanner*");
slirp_map_opaque("GSList*");
slirp_map_opaque("GTypePlugin*");
slirp_map_opaque("GTypeInstance*");
slirp_map_opaque("GTypeClass*");
slirp_map_opaque("GValue*");
slirp_map_opaque("PangoFontDescription*");
slirp_map_opaque("PangoContext*");
slirp_map_opaque("PangoLayout*");
slirp_map_opaque("PangoAttrList*");
slirp_map_opaque("gpointer");
slirp_map_opaque("gconstpointer");

slirp_map_opaque("GtkArg*");
slirp_map_opaque("GtkRequisition*");
slirp_map_opaque("GtkSelectionData*");

slirp_map_opaque("GdkAtom");
slirp_map_opaque("GdkColormap*");
slirp_map_opaque("GdkDragContext*");

slirp_map_opaque("GdkEvent*");
slirp_map_opaque("GdkFont*");
slirp_map_opaque("GdkDisplay*");
slirp_map_opaque("GdkVisual*");
slirp_map_opaque("GdkScreen*");
slirp_map_opaque("GParamSpec*");	% mapped to opaque (even though its
					% a struct), because it has several
					% aggregate -- as well as private --
					% fields, some of which can change
					% dynamically (e.g qdata)

slirp_map_opaque("GtkTreeModel*");
slirp_map_opaque("cairo_t*");
slirp_map_opaque("cairo_surface_t*");
slirp_map_opaque("cairo_content_t*");
% }}}

% GObject {{{

slirp_define_opaque("GObject");		% default parent to GtkOpaque
slirp_map_opaque("GtkAccessible*");
slirp_map_opaque("AtkObject*");
slirp_map_opaque("GtkIconFactory*");
%slirp_map_opaque("GtkIMContext*");
%slirp_map_opaque("GtkIMContextSimple*");
%slirp_map_opaque("GtkIMMulticontext*");
slirp_map_opaque("GtkRcStyle*");

slirp_map_opaque("GtkSettings*");

%slirp_map_opaque("GtkSizeGroup*");
slirp_map_opaque("GtkStyle*");

slirp_map_opaque("GtkTextMark*");
slirp_map_opaque("GtkTextTagTable*");
%slirp_map_opaque("GtkTreeModelSort*");
slirp_map_opaque("GtkTreeSelection*");
slirp_map_opaque("GtkWindowGroup*");
slirp_map_opaque("GdkDragContext*");

slirp_map_opaque("GdkImage*");
slirp_map_opaque("GdkPixbufFormat*");
slirp_map_opaque("GdkDevice*");

slirp_map_opaque("GtkAccelGroup*");	% These need g_object_ref()
slirp_map_opaque("GtkListStore*");	% for unparented instances
slirp_map_opaque("GtkTreeStore*");
slirp_map_opaque("GtkTextBuffer*");
slirp_map_opaque("GtkTextChildAnchor*");
slirp_map_opaque("GtkTextTag*");

slirp_define_opaque("GdkDrawable");
slirp_map_opaque("GdkWindow*");
slirp_define_opaque("GdkPixmap","GdkDrawable","g_object_unref");
slirp_define_opaque("GdkBitmap","GdkDrawable","g_object_unref");
slirp_define_opaque("GdkGC","GObject","g_object_unref");
slirp_define_opaque("GdkPixbuf","GObject","g_object_unref");
slirp_define_opaque("GdkPixbufAnimation", "GObject", "g_object_unref");
% }}}

% GtkObject {{{

slirp_define_opaque("GtkObject","GObject","slgtk_object_destroyer");
% GtkObject children are defined as unique S-Lang types
% to prevent them from being downcast to GtkWidget
slirp_define_opaque("GtkCellRenderer","GtkObject");
slirp_define_opaque("GtkCellRendererPixbuf","GtkCellRenderer");
slirp_define_opaque("GtkCellRendererText","GtkCellRenderer");
slirp_define_opaque("GtkCellRendererToggle","GtkCellRenderer");
slirp_define_opaque("GtkItemFactory","GtkObject");
slirp_define_opaque("GtkTreeViewColumn","GtkObject");
slirp_define_opaque("GtkTooltips","GtkObject");
slirp_define_opaque("GtkAdjustment","GtkObject");
% }}}

% GtkWidget {{{

% A NULL freer/finalizer prevents GtkWidget from using the GtkObject finalizer
slirp_define_opaque("GtkWidget","GtkObject",NULL);
slirp_map_opaque("GtkAccelLabel*");
slirp_map_opaque("GtkAlignment*");
slirp_map_opaque("GtkArrow*");
slirp_map_opaque("GtkAspectFrame*");
slirp_map_opaque("GtkBin*");
slirp_map_opaque("GtkBox*");
slirp_map_opaque("GtkButton*");
slirp_map_opaque("GtkButtonBox*");
slirp_map_opaque("GtkCalendar*");
slirp_map_opaque("GtkCheckButton*");
slirp_map_opaque("GtkCheckMenuItem*");
slirp_map_opaque("GtkColorSelection*");
slirp_map_opaque("GtkColorSelectionDialog*");
slirp_map_opaque("GtkCombo*");
slirp_map_opaque("GtkContainer*");
slirp_map_opaque("GtkCurve*");
slirp_map_opaque("GtkData*");
slirp_map_opaque("GtkDialog*");
slirp_map_opaque("GtkDrawingArea*");
slirp_map_opaque("GtkEditable*");
slirp_map_opaque("GtkEntry*");
slirp_map_opaque("GtkEventBox*");
slirp_map_opaque("GtkFileSelection*");
slirp_map_opaque("GtkFixed*");
slirp_map_opaque("GtkFontSelection*");
slirp_map_opaque("GtkFontSelectionDialog*");
slirp_map_opaque("GtkFrame*");
slirp_map_opaque("GtkGammaCurve*");
slirp_map_opaque("GtkHandleBox*");
slirp_map_opaque("GtkHBox*");
slirp_map_opaque("GtkHButtonBox*");
slirp_map_opaque("GtkHPaned*");
slirp_map_opaque("GtkHRuler*");
slirp_map_opaque("GtkHScale*");
slirp_map_opaque("GtkHScrollbar*");
slirp_map_opaque("GtkHSeparator*");
slirp_map_opaque("GtkImage*");
slirp_map_opaque("GtkInputDialog*");
slirp_map_opaque("GtkInvisible*");
slirp_map_opaque("GtkItem*");
slirp_map_opaque("GtkLabel*");
slirp_map_opaque("GtkLayout*");
slirp_map_opaque("GtkMenu*");
slirp_map_opaque("GtkMenuBar*");
slirp_map_opaque("GtkMenuItem*");
slirp_map_opaque("GtkMenuShell*");
slirp_map_opaque("GtkMisc*");
slirp_map_opaque("GtkNotebook*");
slirp_map_opaque("GtkOptionMenu*");
slirp_map_opaque("GtkPacker*");
slirp_map_opaque("GtkPaned*");
slirp_map_opaque("GtkPlug*");
slirp_map_opaque("GtkPreview*");
slirp_map_opaque("GtkProgress*");
slirp_map_opaque("GtkProgressBar*");
slirp_map_opaque("GtkRadioButton*");
slirp_map_opaque("GtkRadioMenuItem*");
slirp_map_opaque("GtkImageMenuItem*");
slirp_map_opaque("GtkRange*");
slirp_map_opaque("GtkRuler*");
slirp_map_opaque("GtkScale*");
slirp_map_opaque("GtkScrollbar*");
slirp_map_opaque("GtkScrolledWindow*");
slirp_map_opaque("GtkSeparator*");
slirp_map_opaque("GtkSocket*");
slirp_map_opaque("GtkSpinButton*");
slirp_map_opaque("GtkStatusbar*");
slirp_map_opaque("GtkTable*");
slirp_map_opaque("GtkTearoffMenuItem*");
slirp_map_opaque("GtkTextView*");
slirp_map_opaque("GtkTipsQuery*");
slirp_map_opaque("GtkToggleButton*");
slirp_map_opaque("GtkToolbar*");

slirp_map_opaque("GtkTreeView*");
slirp_map_opaque("GtkVBox*");
slirp_map_opaque("GtkVButtonBox*");
slirp_map_opaque("GtkViewport*");
slirp_map_opaque("GtkVPaned*");
slirp_map_opaque("GtkVRuler*");
slirp_map_opaque("GtkVScale*");
slirp_map_opaque("GtkVScrollbar*");
slirp_map_opaque("GtkVSeparator*");
slirp_map_opaque("GtkWindow*");
% }}}

% Miscellaneous {{{

slirp_define_opaque("GdkCursor","GtkOpaque","gdk_cursor_unref");
slirp_define_opaque("GdkRegion","GtkOpaque","gdk_region_destroy");
slirp_define_opaque("GtkIconSource","GtkOpaque","gtk_icon_source_free");
slirp_define_opaque("GtkIconSet","GtkOpaque","gtk_icon_set_unref");

slirp_define_opaque("GtkTreeIter","GtkOpaque","gtk_tree_iter_free");
slirp_define_opaque("GtkTextIter","GtkOpaque","gtk_text_iter_free");
slirp_define_opaque("GtkTreePath","GtkOpaque","gtk_tree_path_free");

slirp_map_char("gchar");		% Strictly speaking these mappings
slirp_map_uchar("guchar");		% are not required, as SLIRP would
slirp_map_string("gchar*");		% generate them automatically from
slirp_map_ushort("gshort");		% gtypes.h and glibconfig.h, but
slirp_map_ushort("gushort");		% presently those files are not
slirp_map_int("gint");			% included during code generation.
slirp_map_uint("guint");
slirp_map_long("glong");
slirp_map_ulong("gulong");
slirp_map_float("gfloat");
slirp_map_double("gdouble");
slirp_map_int("gboolean");

slirp_map_int32("gint32");
slirp_map_uint32("guint32");
slirp_map_char("gint8");
slirp_map_ref("gint8*");
slirp_map_uchar("guint8");
slirp_map_uint16("guint16");
slirp_map_int16("gint16");
slirp_map_uint32("GQuark");
slirp_map_uint16("gunichar2");
slirp_map_uint32("gunichar");

slirp_map_struct("GdkColor*");
slirp_map_struct("GdkRectangle*");
slirp_map_struct("GtkAllocation*");	% An instance of GdkRectangle
slirp_map_struct("GdkPoint*");

slirp_map_int("GdkModifierType");
slirp_map_int("GdkVisualType");
slirp_map_int("GdkByteOrder");
slirp_map_ulong("GType");
slirp_map_ulong("GtkType");

slirp_map_macro("GTK_WIDGET_VISIBLE",  "int (GtkWidget *w)");
slirp_map_macro("GTK_WIDGET_MAPPED",   "int (GtkWidget *w)");
slirp_map_macro("GTK_WIDGET_REALIZED", "int (GtkWidget *w)");
slirp_map_macro("GTK_WIDGET_TOPLEVEL", "int (GtkWidget *w)");
slirp_map_macro("GTK_WIDGET_STATE", "int (GtkWidget *w)");
slirp_map_macro("GTK_WIDGET_IS_SENSITIVE", "int (GtkWidget *w)");
slirp_map_macro("GTK_WIDGET_SENSITIVE", "int (GtkWidget *w)");
slirp_map_macro("GTK_WIDGET_CAN_FOCUS", "int (GtkWidget *w)");
% }}}

% NULL arg acceptors % {{{
% How do I know which Gtk/Glib/etc funcs accept null args?
% Several ways, in order of decreasing reliability:
%	- by looking at the .defs files
%	- the documentation
%	- by inspection of Gtk testgtk.c (both the source code and
%	  runtime behavior)
%
% In early releases of SLgtk I attempted to automate this, but
% it wasn't really worth the effort to maintain (given that 
% relatively few funcs actually support NULL arguments)

accepts_null_args["gtk_menu_item_set_submenu"] = [2];
accepts_null_args["gtk_aspect_frame_new"] = [1];
accepts_null_args["gtk_dialog_new_with_buttons"] = [1,2,4];
accepts_null_args["gtk_file_selection_new"] = [1];
accepts_null_args["gtk_frame_new"] = [1];
accepts_null_args["gtk_hscale_new"] = [1];
accepts_null_args["gtk_hscrollbar_new"] = [1];
accepts_null_args["gtk_item_factory_new"] = [3];
accepts_null_args["gtk_image_new_from_image"] = [1,2];
accepts_null_args["gtk_image_new_from_pixmap"] = [1,2];
accepts_null_args["gtk_image_get_pixmap"] = [2,3];
accepts_null_args["gtk_layout_new"] = [1,2];
accepts_null_args["gtk_label_new"] = [1];
accepts_null_args["gtk_message_dialog_new"] = [1,5];
accepts_null_args["gtk_pixmap_new"] = [2];
accepts_null_args["gtk_progress_bar_new_with_adjustment"] = [1];
accepts_null_args["gtk_radio_button_new"] = [1];
accepts_null_args["gtk_radio_button_new_with_label"] = [1];
accepts_null_args["gtk_radio_button_new_from_widget"] = [1];
accepts_null_args["gtk_radio_button_new_with_label_from_widget"] = [1];
accepts_null_args["gtk_radio_menu_item_new_with_label"] = [1];
accepts_null_args["gtk_scrolled_window_new"] = [1,2];
accepts_null_args["gtk_spin_button_new"] = [1];
accepts_null_args["gtk_text_buffer_new"] = [1];
accepts_null_args["gtk_tooltips_set_tip"] = [3,4];
accepts_null_args["gtk_toolbar_append_widget"] = [4];
accepts_null_args["gtk_tree_view_new_with_model"] = [1];
accepts_null_args["gtk_viewport_new"] = [1,2];
accepts_null_args["gtk_vscale_new"] = [1];
accepts_null_args["gtk_vscrollbar_new"] = [1];
accepts_null_args["gdk_pixmap_new"] = [1];
%accepts_null_args["gdk_pixmap_create_from_xpm"] = [2,3];
%accepts_null_args["gdk_pixmap_colormap_create_from_xpm"] = [1,2,3,4];
accepts_null_args["gdk_pixmap_create_from_data"] = [1];
accepts_null_args["gdk_draw_pixbuf"] = [2];
accepts_null_args["gdk_pixbuf_new_from_file"] = [2];
accepts_null_args["gdk_pixbuf_get_from_drawable"] = [1,3];
accepts_null_args["gdk_window_set_icon"] = [2,3,4];
accepts_null_args["gdk_window_set_back_pixmap"] = [2];
accepts_null_args["g_list_append"] = [1];
% }}}

#ignore {{{
gtk_accel_group_activate		% gtk/gtkaccelgroup.h: "internal" funcs
gtk_accel_group_get_entry
gtk_accel_group_lock_entry
gtk_accel_group_unlock_entry
gtk_accel_group_add
gtk_accel_group_remove
gtk_accel_group_handle_add
gtk_accel_group_handle_remove
gtk_accel_group_create_add
gtk_accel_group_create_remove
gtk_accel_groups_from_object
gtk_accel_group_entries_from_object
gtk_accel_group_find			% avoid messy prototype parsing for now

gtk_adjustment_get_value		% The GtkAdjustment interface is
					% incomplete: it shows a get_value()
					% method but no methods for other
					% fields.  So we ignore get_value()
					% here and use scandefs.sl to generate
					% accessors for all fields
gtk_button_box_child_requisition
gtk_window_remove_embedded_xid
gtk_window_add_embedded_xid
gtk_window_reposition
gtk_window_set_geometry_hints
gtk_window_set_policy				% deprecated in GTK 2.x

gtk_widget_new
gtk_widget_newv
gtk_widget_set
gtk_widget_class_install_style_property_parser
gtk_widget_class_install_style_property
gtk_widget_reset_shapes				% !!! "internal" func
gtk_widget_style_get
gtk_widget_style_get_property
gtk_widget_style_get_valist
gtk_requisition_copy

gtk_dialog_new_with_buttons		% !!!  var arglists not supported
gtk_dialog_add_buttons			% !!!  var arglists not supported

gtk_container_foreach
gtk_container_foreach_full
gtk_container_forall
gtk_container_children			% !!! needs GSList* support first
gtk_container_get_toplevels		% !!! needs GSList* support first
gtk_container_query_child_args		% !!! GtkArg not supported
gtk_container_child_getv		% !!! GtkArg not supported
gtk_container_child_setv		% !!! GtkArg not supported
gtk_container_add_with_args		% !!! var arglists not
gtk_container_addv			% !!! GtkArg not supported
gtk_container_child_set			% !!!  var arglists not supported
gtk_container_child_get			% !!!  var arglists not supported

% New container funcs for GTK2.x
gtk_container_propagate_expose
gtk_container_class_install_child_property
gtk_container_class_find_child_property
gtk_container_class_list_child_properties
gtk_container_add_with_properties
gtk_container_child_get
gtk_container_child_set_valist
gtk_container_child_get_valist
gtk_container_child_set_property
gtk_container_child_get_property
gtk_container_get_focus_chain
gtk_container_set_focus_chain

gtk_init			% gtk_init() is called automatically by SLgtk
gtk_init_check			% module internals, so no need to wrap it
gtk_init_check_abi_check
gtk_init_abi_check
gtk_init_add
gtk_exit			% deprecated in Gtk 2.x
gtk_propagate_event
gtk_idle_add
gtk_quit_add
gtk_quit_add_full
gtk_quit_remove_by_data
gtk_timeout_add
gtk_timeout_add_full
gtk_idle_add_priority
gtk_idle_add_full
gtk_idle_remove_by_data
gtk_input_add_full
gtk_input_remove
gtk_key_snooper_install
gtk_get_default_language
gtk_main_quit				% coded by hand, for user-friendliness;
					% will automatically remove from stack
					% args registered by signal_connect
gtk_type_check_object_cast
gtk_object_new				% Many gtk_object_* functions are
gtk_object_newv				% deprecated in Gtk2.x, in favor of
gtk_object_ref				% the corresponding g_object_* calls
gtk_object_unref			% in the lower-level glib/gobject
gtk_object_weakref
gtk_object_weakunref
gtk_object_set
gtk_object_get
gtk_object_get_data
gtk_object_get_user_data
gtk_object_get_data_by_id
gtk_object_set_data
gtk_object_set_data_full
gtk_object_set_user_data
gtk_object_set_data_by_id
gtk_object_set_data_by_id_full
gtk_object_remove_data
gtk_object_remove_data_by_id
gtk_object_remove_no_notify

gtk_signal_connect			% The Gtk-level signal funcs are
gtk_signal_connect_object		% deprecated, in favor of the low-
gtk_signal_connect_after		% level GObject (g_signal_*) versions
gtk_signal_connect_object_after
gtk_signal_connect_full
gtk_signal_connect_while_alive
gtk_signal_connect_object_while_alive
gtk_signal_disconnect_by_data
gtk_signal_disconnect_by_func
gtk_signal_handler_block_by_func
gtk_signal_handler_unblock_by_func
gtk_signal_handler_block_by_data
gtk_signal_handler_unblock_by_data
gtk_signal_handler_pending_by_func
gtk_signal_add_emission_hook
gtk_signal_add_emission_hook_full
gtk_signal_remove_emission_hook
gtk_signal_query
gtk_signal_init
gtk_signal_new
gtk_signal_newv
gtk_signal_emit
gtk_signal_emit_by_name
gtk_signal_emitv
gtk_signal_emitv_by_name
gtk_signal_handlers_destroy
gtk_signal_set_funcs

gtk_menu_popup				% coded manually, avoids use of
					% GtkMenuFunc and other little-used
					% parameters (per Gtk docs)

gtk_menu_attach_to_widget		% no support for GtkMenuDetachFunc

gtk_type_init				% Most of the dynamic type system is
gtk_type_unique				% not, and may never be, supported
gtk_type_set_chunk_alloc
gtk_type_parent
gtk_type_parent_class
gtk_type_children_types
gtk_type_new
gtk_type_free
gtk_type_describe_heritage
gtk_type_describe_tree
gtk_type_check_object_cast
gtk_type_check_class_cast
gtk_type_register_enum
gtk_type_register_flags
gtk_type_enum_get_values
gtk_type_flags_get_values
gtk_type_enum_find_value
gtk_type_flags_find_value
gtk_type_set_varargs_type
gtk_type_get_varargs_type
gtk_type_query

gtk_preview_get_info
gtk_tooltips_data_get		% may not need coding by hand
 
gtk_color_selection_palette_from_string
gtk_color_selection_palette_to_string
gtk_color_selection_set_change_palette_hook
gtk_color_selection_set_color			% deprecated in GTK2.x
gtk_color_selection_get_color			% deprecated in GTK2.x
gtk_color_selection_get_current_color		% coded by hand,for friendliness

gtk_label_get				% deprecated in GTK2.x
gtk_image_get				% deprecated in GTK2.x
gtk_image_set				% deprecated in GTK2.x
gtk_file_selection_get_selections	% !!! just laziness on my part
gtk_list_store_set			% coded manually
gtk_list_store_set_value		% coded manually
gtk_rc_get_default_files
gtk_style_ref				% deprecated in GTK2.x
gtk_style_unref				% deprecated in GTK2.x
gtk_style_get_font			% deprecated in GTK2.x
gtk_style_set_font			% deprecated in GTK2.x
gtk_draw_hline				% deprecated in GTK2.x
gtk_draw_vline				% deprecated in GTK2.x
gtk_draw_shadow				% deprecated in GTK2.x
gtk_draw_polygon			% deprecated in GTK2.x
gtk_draw_arrow				% deprecated in GTK2.x
gtk_draw_diamond			% deprecated in GTK2.x
gtk_draw_box				% deprecated in GTK2.x
gtk_draw_flat_box			% deprecated in GTK2.x
gtk_draw_check				% deprecated in GTK2.x
gtk_draw_option				% deprecated in GTK2.x
gtk_draw_tab				% deprecated in GTK2.x
gtk_draw_shadow_gap			% deprecated in GTK2.x
gtk_draw_box_gap			% deprecated in GTK2.x
gtk_draw_extension			% deprecated in GTK2.x
gtk_draw_focus				% deprecated in GTK2.x
gtk_draw_slider				% deprecated in GTK2.x
gtk_draw_handle				% deprecated in GTK2.x
gtk_draw_expander			% deprecated in GTK2.x
gtk_draw_layout				% deprecated in GTK2.x
gtk_draw_resize_grip			% deprecated in GTK2.x

gtk_toolbar_append_item
gtk_tree_store_new
gtk_tree_store_set
gtk_tree_view_get_search_equal_func
gtk_tree_view_set_search_equal_func
gtk_tree_view_set_destroy_count_func
gtk_tree_view_column_new_with_attributes	% coded manually

gtk_text_buffer_get_iter_at_offset		% these were coded manually
gtk_text_buffer_get_iter_at_line_offset
gtk_text_buffer_get_iter_at_line
gtk_text_buffer_get_start_iter
gtk_text_buffer_get_end_iter
gtk_text_buffer_insert_with_tags
gtk_text_buffer_create_tag

gdk_image_new_bitmap			% per Gtk/Gdk 2.x docs, tis very broken
gdk_pixbuf_ref				% deprecated in favor of g_object_ref
gdk_pixbuf_unref			% deprecated in favor of g_object_unref
gdk_pixbuf_new_from_xpm_data		% s/b coded manually
%"gdk_pixbuf_get_pixels			% probably s/b coded manually

gdk_pixmap_create_from_xpm		% coded manually
gdk_pixmap_colormap_create_from_xpm
gdk_pixmap_create_from_xpm_d
gdk_pixmap_colormap_create_from_xpm_d

gdk_colormap_ref			% deprecated in Gtk2.x
gdk_colormap_unref			% deprecated in Gtk2.x
gdk_colormap_get_system_size		% deprecated in Gtk2.x
gdk_colormap_change			% deprecated in Gtk2.x
gdk_colors_store			% deprecated in Gtk2.x
gdk_colors_alloc			% deprecated in Gtk2.x
gdk_colors_free				% deprecated in Gtk2.x
gdk_color_white				% deprecated in Gtk2.x
gdk_color_black				% deprecated in Gtk2.x
gdk_color_alloc				% deprecated in Gtk2.x
gdk_color_change			% deprecated in Gtk2.x
gdk_color_parse				% coded manually, to deal with odd API
					% (wants GdkColor* reference)
gdk_region_polygon			% will be coded manually, eventually
gdk_color_free				% need to think about this more; to
gdk_color_copy				% see why, comment out and rerun CG

gdk_event_put			% these event functions will likely
gdk_event_get			% never be needed in s-lang guilets
gdk_event_peek			% but could be implemented as soon
gdk_event_new			% as pop_event() is made available
gdk_event_copy
gdk_event_free

gdk_drawable_set_data			% deprecated in Gtk2.x
gdk_drawable_get_data			% deprecated in Gtk2.x
gdk_drawable_ref			% deprecated in Gtk2.x
gdk_drawable_unref			% deprecated in Gtk2.x

gdk_event_get_type			% these event funcs are superfluous,
gdk_event_get_graphics_expose		% given that in SLgtk events are SLang
gdk_event_get_time			% structs with these fields set per
gdk_event_get_state			% the underlying C event struct
gdk_event_get_coords
gdk_event_get_root_coords
gdk_event_get_axis
gdk_query_depths

g_value_c_init 				% these became private in 2.6, but
g_value_types_init			% are still listed in the public .h
g_enum_types_init			%   .
g_param_type_init       		%   .
g_boxed_type_init       		%   .
g_object_type_init 			%   .
g_param_spec_types_init			%   .
g_value_transforms_init 		%   .
g_signal_init				%   .

g_signal_get_invocation_hint
g_signal_list_ids
g_list_remove_link
g_list_free_1
g_list_alloc
g_list_pop_allocator
g_object_set_data			% coded manually
g_object_get_data			% coded manually
g_type_value_table_peek			% See above for comments on type system
g_type_add_class_cache_func
g_type_remove_class_cache_func
g_type_class_unref
g_type_class_unref_uncached
g_type_class_ref
g_type_class_peek
g_type_class_peek_parent
g_type_interface_peek
g_type_interface_peek_parent
g_type_get_qdata
g_type_set_qdata
g_type_children	
g_type_interfaces
g_type_interface_prerequisites
_g_type_debug_flags
g_param_spec_set_qdata			% coded manually
g_param_spec_get_qdata			% coded manually
g_param_spec_steal_qdata		% coded manually
#end % }}}

% Replacement macro substitutions
slirp_substitute_macro("G_BEGIN_DECLS", EMPTY);
slirp_substitute_macro("G_END_DECLS", EMPTY);
slirp_substitute_macro("CAIRO_BEGIN_DECLS", EMPTY);
slirp_substitute_macro("CAIRO_END_DECLS", EMPTY);

#typedef GdkPixbuf* GDK_PIXBUF_REFD

#retmap GDK_PIXBUF_REFD
   g_object_ref(retval);
   (void) SLang_push_opaque(GdkPixbuf_Type,  retval, 0);
#end

#prototype
   NT_STR_ARRAY_FREE gdk_pixbuf_format_get_extensions(GdkPixbufFormat *);
   GDK_PIXBUF_REFD gdk_pixbuf_animation_get_static_image(GdkPixbufAnimation* );
#end

provide("slirprc-gtk");
