#ifndef VTKSLICERVOLUMERENDERINGCUDA_H_
#define VTKSLICERVOLUMERENDERINGCUDA_H_

#include "vtkSlicerModuleGUI.h"
#include "vtkVolumeRenderingCuda.h"
#include "vtkVolumeRenderingCudaLogic.h"

class vtkCudaVolumeMapper;
class vtkVolume;
class vtkVolumeProperty;
class vtkRenderWindow;
class vtkRenderer;

class vtkKWWidget;
class vtkKWTypeChooserBox;
class vtkKWMatrixWidget;
class vtkKWMenuButton;
class vtkKWVolumePropertyWidget;
class vtkKWHistogramSet;
class vtkKWRange;
class vtkSlicerNodeSelectorWidget;

class VTK_VOLUMERENDERINGCUDA_EXPORT vtkVolumeRenderingCudaGUI : public vtkSlicerModuleGUI
{
 public:
 //BTX
  typedef vtkSlicerModuleGUI SuperClass;
 //ETX
  static vtkVolumeRenderingCudaGUI* New();
  vtkTypeMacro(vtkVolumeRenderingCudaGUI, vtkSlicerModuleGUI);

  /// Logic part
  vtkGetObjectMacro(Logic, vtkVolumeRenderingCudaLogic);
  // this does not work vtkSetObjectMacro(Logic, vtkVolumeRenderingCudaLogic);
  virtual void SetLogic(vtkVolumeRenderingCudaLogic *logic)
  {
    this->Logic=logic;
  }

  virtual void SetModuleLogic(vtkSlicerLogic *logic)
  {
    this->SetLogic( dynamic_cast<vtkVolumeRenderingCudaLogic*> (logic) );
    //this->SetLogic( (vtkVolumeRenderingCudaLogic*) (logic) );
  }

  void DeleteWidget(vtkKWWidget* widget);

  // Description:
  // Process events generated by Logic
  virtual void ProcessLogicEvents ( vtkObject *caller, unsigned long event,
                                    void *callData ){};

  /// GUI part
  virtual void BuildGUI ( );
  // This method releases references and key-bindings,
  // and optionally removes observers.
  virtual void TearDownGUI ( );

  // Description:
  // Methods for adding module-specific key bindings and
  // removing them.
  virtual void CreateModuleEventBindings ( );
  virtual void ReleaseModuleEventBindings ( );

  // Description:
  // Add obsereves to GUI widgets
  virtual void AddGUIObservers ( );
  
  // Description:
  // Remove obsereves to GUI widgets
  virtual void RemoveGUIObservers ( );
  virtual void RemoveMRMLNodeObservers ( );
  virtual void RemoveLogicObservers ( );
  

  // Description:
  // Process events generated by GUI widgets
  virtual void ProcessGUIEvents ( vtkObject *caller, unsigned long event,
                                  void *callData );
  
  // Description:
  // Process events generated by MRML
  virtual void ProcessMRMLEvents ( vtkObject *caller, unsigned long event,
                                   void *callData);
  
    // Description:
    // Get/Set the main slicer viewer widget, for picking
    vtkGetObjectMacro(ViewerWidget, vtkSlicerViewerWidget);
    virtual void SetViewerWidget(vtkSlicerViewerWidget *viewerWidget);

    // Description:
    // Get/Set the slicer interactorstyle, for picking
    vtkGetObjectMacro(InteractorStyle, vtkSlicerViewerInteractorStyle);
    virtual void SetInteractorStyle(vtkSlicerViewerInteractorStyle *interactorStyle);

  // Description:
  // Methods describe behavior at module enter and exit.
  virtual void Enter ( );
  virtual void Exit ( );
  
  void PrintSelf(ostream& os, vtkIndent indent);
  

  void ScheduleRender();
  bool RenderScheduled;

 protected:
  vtkVolumeRenderingCudaGUI();
  virtual ~vtkVolumeRenderingCudaGUI();


  vtkVolumeRenderingCudaGUI(const vtkVolumeRenderingCudaGUI&); // not implemented
  void operator=(const vtkVolumeRenderingCudaGUI&); // not implemented

private:
  void CreateMapper();
  void DeleteMapper();

private:
  // Description:
  // Pointer to the module's logic class
  vtkVolumeRenderingCudaLogic *Logic;

  vtkCudaVolumeMapper* CudaMapper;
  vtkVolume* CudaVolume;
  vtkVolumeProperty* CudaVolumeProperty;
  
  vtkSlicerViewerWidget *ViewerWidget;
  vtkSlicerViewerInteractorStyle *InteractorStyle;

  vtkKWMenuButton* RenderModeChooser;
  vtkKWMenuButton* RayCastingMethodChooser;
  vtkKWMenuButton* InterpolationMethodChooser;
  vtkKWMenuButton* RenderObjectModeChooser;
  vtkKWMenuButton* VolumeRenderDirectionChooser;
  vtkKWVolumePropertyWidget* VolumePropertyWidget;

  vtkKWRange* ThresholdRange;
  vtkKWScale* ScaleFactorScale;

  vtkKWHistogramSet* Histograms;

  vtkSlicerNodeSelectorWidget* NS_ImageData;
  vtkSlicerNodeSelectorWidget* NS_SliceMatrix;

  vtkRenderWindow* IVWindow;
  vtkRenderer* IVRenderer;

  vtkMRMLScalarVolumeNode* SelectedImageData;
  vtkMRMLLinearTransformNode* SelectedSliceMatrix;

  vtkMatrix4x4* SliceMatrix;
  vtkImageData* ImageData;

};

#endif /*VTKSLICERVOLUMERENDERINGCUDA_H_*/
