package SliMP3::Buttons::ScreenSaver;

# $Id: ScreenSaver.pm,v 1.29 2003/05/12 18:22:29 blackketter Exp $

# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License, 
# version 2.

use strict;
use File::Spec::Functions qw(:ALL);
use File::Spec::Functions qw(updir);
use POSIX qw(strftime);

use SliMP3::Buttons::Common;
use SliMP3::Buttons::Playlist;
use SliMP3::Misc;
use SliMP3::Strings qw(string);
use SliMP3::Prefs;

# Each button on the remote has a function:
my %functions = (
	'done' => sub  {
		my ($client
		   ,$funct
		   ,$functarg) = @_;
		SliMP3::Buttons::Common::popMode($client);
		SliMP3::Display::update($client);
		#pass along ir code to new mode if requested
		if (defined $functarg && $functarg eq 'passback') {
			SliMP3::IR::resendButton($client);
		}
	}
);

sub getFunctions {
	return \%functions;
}

sub screenSaver {
	my $client = shift;
	
	my $now = Time::HiRes::time();
	$::d_time && msg("screenSaver idle display " . ($now - SliMP3::IR::lastIRTime($client) - SliMP3::Prefs::get("screensavertimeout")) . "(mode:" . SliMP3::Buttons::Common::mode($client) . ")\n");
	my $mode = SliMP3::Buttons::Common::mode($client);
	
	# dim the screen if we're not playing...  will restore brightness on next IR input.
	if (SliMP3::Prefs::get("screensavertimeout") && 
			 SliMP3::Prefs::clientGet($client, 'autobrightness') &&
			 SliMP3::IR::lastIRTime($client) &&
			 SliMP3::IR::lastIRTime($client) < $now - SliMP3::Prefs::get("screensavertimeout") && 
			 $mode ne 'screensaver' &&
			 $mode ne 'block' &&
			 $mode ne 'off' &&
			 SliMP3::Playlist::playmode($client) ne 'play' &&
			 SliMP3::VFD::vfdBrightness($client)) {
		SliMP3::VFD::vfdBrightness($client,1);
	}

	if (SliMP3::Animation::animating($client)) {
		# if we're animating, let the animation play out
	} elsif ($mode eq 'block') {
		# blocked mode handles its own updating of the screen.
	} elsif (SliMP3::Prefs::get("screensavertimeout") && 
			 SliMP3::IR::lastIRTime($client) < $now - SliMP3::Prefs::get("screensavertimeout") && 
			 SliMP3::Playlist::count($client) > 0 &&
			 $mode ne 'screensaver' &&
			 $mode ne 'block' &&
			 $mode ne 'off') {
		
		# we only go into screensaver mode if we've timed out and we're playing something
		# and we're not off or blocked
		if (SliMP3::Prefs::get("screensaverjump")) {
			if ($mode eq 'playlist') {
				SliMP3::Buttons::Playlist::jump($client);
				my $linefunc = $client->lines();
				SliMP3::Animation::scrollBottom($client, &$linefunc($client));
			} else {
				SliMP3::Buttons::Common::pushMode($client,'playlist');
				SliMP3::Display::update($client);		
			}
		} else {
			SliMP3::Buttons::Common::pushMode($client,'screensaver');
			SliMP3::Display::update($client);		
		} 
	} else {
		# try to scroll the bottom, if necessary
		my $linefunc = $client->lines();
		SliMP3::Animation::scrollBottom($client, &$linefunc($client));
	}
	# Call ourselves again after 1 second
	SliMP3::Timers::setTimer($client, ($now + 1.0), \&screenSaver);
}

sub wakeup {
	my $client = shift;
	my $button = shift;
	
	SliMP3::IR::setLastIRTime($client, Time::HiRes::time());

	if (!SliMP3::Prefs::clientGet($client, 'autobrightness')) { return; };
	
	my $curBrightnessPref;
	
	if (SliMP3::Buttons::Common::mode($client) eq 'off') {
		$curBrightnessPref = SliMP3::Prefs::clientGet($client, 'powerOffBrightness');
	} else {
		$curBrightnessPref = SliMP3::Prefs::clientGet($client, 'powerOnBrightness');		
	} 
	
	if ($curBrightnessPref != SliMP3::VFD::vfdBrightness($client)) {
		SliMP3::VFD::vfdBrightness($client, $curBrightnessPref);
	}
	
	# wake up our display if it is off and the player isn't in standby and we're not adjusting the 
	# brightness
	if ($button && 
		$button ne 'brightness_down' &&
		$button ne 'brightness_up' && 
		$button ne 'brightness_toggle' &&
		SliMP3::VFD::vfdBrightness($client) == 0 &&
		SliMP3::Buttons::Common::mode($client) ne 'off') { 
			SliMP3::Prefs::clientSet($client, 'powerOnBrightness', 1);		
	}
} 

sub setMode {
	my $client = shift;
	$::d_time && msg("going into screensaver mode");
	$client->lines(\&lines);
}

sub lines {
	my $client = shift;
	$::d_time && msg("getting screensaver lines");
	return(SliMP3::Buttons::Playlist::currentSongLines($client));
}

1;

__END__

# Local Variables:
# tab-width:4
# indent-tabs-mode:t
# End:
