\function{current_newsgroup}
\synopsis{-}
\usage{String current_newsgroup ()}
\description
   This function returns the name of the current newsgroup.
\seealso{server_name}
\done

\function{get_group_flags}
\synopsis{-}
\usage{Integer get_group_flags ()}
\description
   This function returns the flags associated with the current
   newsgroup.  This integer is a bitmapped value whose bits are
   defined by the following constants:
#v+
     GROUP_UNSUBSCRIBED   : set if the group is unsubscribed
     GROUP_NEW_GROUP_FLAG : set if the group is new
#v-
\seealso{get_header_flags, set_group_flags, current_newsgroup}
\done

\function{group_down_n}
\synopsis{-}
\usage{Integer group_down_n (Integer n)}
\description
   This function moves the current group pointer down \var{n} groups and
   returns the actual number moved.
\seealso{group_up_n, group_search, current_newsgroup}
\done

\function{group_search}
\synopsis{-}
\usage{Integer group_search (String name)}
\description
   This function searches for a newsgroup containing the string
   \var{name}.  It also searches newsgroup descriptions.  A non-zero value
   is returned upon success or zero upon failure.
\notes
   This search may wrap.
\seealso{select_group, current_newsgroup}
\done

\function{group_unread}
\synopsis{-}
\usage{Integer group_unread ()}
\description
   This function returns the number of unread articles in the current
   newsgroup.
\seealso{select_group, current_newsgroup, is_group_mode}
\done

\function{group_up_n}
\synopsis{-}
\usage{Integer group_up_n (Integer n)}
\description
   This function moves the current group pointer up \var{n} groups and
   returns the actual number moved.
\seealso{group_down_n, group_search, current_newsgroup}
\done

\function{is_group_mode}
\synopsis{-}
\usage{Integer is_group_mode ()}
\description
   This function returns non-zero if the current mode is group-mode.
\seealso{}
\done

\function{select_group}
\synopsis{-}
\usage{Integer select_group ()}
\description
   This function may be used to select the current group.  It returns
   0 upon success or -1 upon failure.  It can fail if the group has no
   articles.
\seealso{current_newsgroup}
\done

\function{set_group_flags}
\synopsis{-}
\usage{Void set_group_flags (Integer flags)}
\description
   This function may be used to set the flags associated with the
   current newsgroup.
\seealso{get_group_flags}
\done

