/***************************************************************************
    smb4kshareoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>

// KDE includes
#include <klocale.h>
#include <kbuttonbox.h>

// system includes
#include <stdlib.h>

// applications specific includes
#include "smb4kshareoptions.h"
#include "../smb4k.h"

Smb4KShareOptions::Smb4KShareOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );
  
  QVGroupBox *dirBox = new QVGroupBox( i18n( "Directories" ), this );
  QLabel *defaultPathLabel = new QLabel( i18n( "This is the directory under which the shares will be mounted. Adjust it according to your wishes." ), dirBox );
  defaultPathLabel->setTextFormat( RichText );
  m_defaultPath = new KURLRequester( QString::null, dirBox );
  m_defaultPath->setMode( KFile::Directory );
  m_lowercase = new QCheckBox( i18n( "Force generated subdirectories to be lower case." ), dirBox );

  QButtonGroup *mountBox = new QButtonGroup( i18n( "Mounting and Unmounting" ), this );
  m_unmountAll = new QCheckBox( i18n( "Unmount all of %1's shares on exit." ).arg( getenv( "USER" ) ), mountBox );
  m_unmountAll->setGeometry( 10, 25, m_unmountAll->sizeHint().width(), m_unmountAll->sizeHint().height() );
  m_mountRecent = new QCheckBox( i18n( "Remount recently used shares on program start." ), mountBox );
  m_mountRecent->setGeometry( 10, m_unmountAll->frameGeometry().bottom()+5, m_mountRecent->sizeHint().width(), m_mountRecent->sizeHint().height() );
  m_allowUnmountForeign = new QCheckBox( i18n( "Allow the unmounting of shares that are owned by other users." ), mountBox );
  m_allowUnmountForeign->setGeometry( 10, m_mountRecent->frameGeometry().bottom()+5, m_allowUnmountForeign->sizeHint().width(), m_allowUnmountForeign->sizeHint().height() );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addWidget( dirBox, 0, 0, 0 );
  grid->addWidget( mountBox, 1, 0, 0 );
  grid->addItem( spacer2, 2, 0 );
}

Smb4KShareOptions::~Smb4KShareOptions()
{
}


#include "smb4kshareoptions.moc"
