/***************************************************************************
    smb4kbookmarkhandler  -  This class handles the bookmarks.
                             -------------------
    begin                : Fr Jan 9 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KBOOKMARKHANDLER_H
#define SMB4KBOOKMARKHANDLER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qvaluelist.h>

// Application includes
#include "smb4kbookmark.h"


/**
 * This class belongs the to core classes of Smb4K and manages the
 * bookmarks.
 *
 * @author         Alexander Reinholdt <dustpuppy@mail.berlios.de>
 */

class Smb4KBookmarkHandler : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parent        The parent of this object
     *
     * @param name          This object's name
     */
    Smb4KBookmarkHandler( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KBookmarkHandler();
    /**
     * Writes a bookmark to the bookmark file. It is located under
     * $HOME/.kde/share/apps/smb4k and stores, at the moment, only
     * the name of the bookmark.
     *
     * NOTE: This function is more or less a wrapper around the
     * writeBookmarList() function.
     *
     * @param bookmark      An bookmark object that is to be written
     *                      to the bookmark file
     */
    void addBookmark( Smb4KBookmark *bookmark );
    /**
     * This function writes a new list of bookmarks. The old list will be
     * deleted. It should be used, if you manipulated the list of bookmarks
     * i. e. by a bookmark editor. When this function finishes, the
     * bookmarksUpdated() signal will be emitted.
     *
     * @param list          The (new) list of bookmarks that is to be written
     *                      to the bookmark file
     */
    void writeBookmarkList( const QValueList<Smb4KBookmark *> &list );
    /**
     * Get the list of bookmarks.
     *
     * @returns             The current list of bookmarks stored in the
     *                      bookmark file.
     */
    const QValueList<Smb4KBookmark *> &getBookmarks() { return m_bookmarks; }
    /**
     * This function returns a single bookmark.
     *
     * @param bookmark      The bookmark that is searched. The string you enter
     *                      must consist of the host and the share: //HOST/SHARE.
     *
     * @returns             The bookmark object that was searched or NULL if it
     *                      wasn't found.
     */
    Smb4KBookmark *getBookmark( const QString &bookmark );

  signals:
    /**
     * Signal emitted when the list of bookmarks has been updated.
     */
    void bookmarksUpdated();

  private:
    /**
     * The list of bookmarks.
     */
    QValueList<Smb4KBookmark *> m_bookmarks;
    /**
     * This function loads the list of bookmarks from the bookmarks file.
     * When it finishes, the bookmarksUpdated() signal is emitted. So, if you
     * want to access the list of bookmarks immediately after they were read,
     * connect a slot to that signal.
     */
    void loadBookmarks();
};
#endif
