/***************************************************************************
    smb4kuser.cpp  -  This class provides a container for the user
    information that is read from /etc/passwd.
                             -------------------
    begin                : Mo Mr 1 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// system includes
#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>

// application specific includes
#include "smb4kuser.h"


Smb4KUser::Smb4KUser( const int uid, const int gid ) : m_uid( uid ), m_gid( gid )
{
  if ( uid >= 0 && gid >= 0 )
  {
    struct passwd p;
    struct passwd *p_ptr = &p;
    struct passwd *p_tmp;
#ifndef __FreeBSD__
    char p_buf[sysconf( _SC_GETPW_R_SIZE_MAX )];
#else
    char p_buf[4096];
#endif
    int p_buf_len = sizeof( p_buf );

    if ( (getpwuid_r( uid, p_ptr, p_buf, p_buf_len, &p_tmp )) != 0 )
    {
      qFatal( "Smb4KUser: Could not get user name!" );
    }
    else
    {
      m_user.append( p.pw_name );
    }

    struct group g;
    struct group *g_ptr = &g;
    struct group *g_tmp;
#ifndef __FreeBSD__
    char g_buf[sysconf( _SC_GETGR_R_SIZE_MAX )];
#else
    char g_buf[4096];
#endif
    int g_buf_len = sizeof( g_buf );

    if ( getgrgid_r( gid, g_ptr, g_buf, g_buf_len, &g_tmp ) != 0 )
    {
      qFatal( "Smb4KUser: Could not get group name!" );
    }
    else
    {
      m_group.append( g_ptr->gr_name );
    }
  }
  else
    qFatal( "Smb4KUser: UID and/or GID smaller than 0!" );
}


Smb4KUser::~Smb4KUser()
{
}
