/***************************************************************************
    smb4kpreviewdialog.cpp  -  description
                             -------------------
    begin                : Fre Jul 4 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qtooltip.h>
#include <qiconset.h>

// KDE includes
#include <klocale.h>
#include <kapplication.h>
#include <kiconloader.h>

// application specific includes
#include "smb4kpreviewdialog.h"
#include "../smb4k.h"
#include "../core/smb4kcore.h"
#include "../core/smb4kglobal.h"

using namespace Smb4KGlobal;


Smb4KPreviewDialog::Smb4KPreviewDialog( const QString &workgroup, const QString &host, const QString &ip,
const QString &share, QWidget *parent, const char *name, bool modal )
: KDialogBase( Plain, i18n( "Preview" ), Close, Close, parent, name, modal, true ), m_workgroup( workgroup ), m_host( host ), m_share( share ), m_ip( ip )
{
  setupView();

  readOptions();

  setMinimumSize( sizeHint() );
  setWFlags( Qt::WDestructiveClose );

  connect( this,      SIGNAL( finished() ),
           this,      SLOT( slotFinished() ) );
  connect( m_view,    SIGNAL( executed( QIconViewItem * ) ),
           this,      SLOT( slotItemExecuted( QIconViewItem * ) ) );
  connect( m_toolbar, SIGNAL( clicked( int ) ),
           this,      SLOT( slotButtonClicked( int ) ) );
  connect( m_combo,   SIGNAL( activated( const QString & ) ),
           this,      SLOT( slotItemActivated( const QString & ) ) );

  connect( smb4k_core->scanner(), SIGNAL( previewResult( const QValueList<Smb4KPreviewItem *> & ) ),
           this,                  SLOT( slotReceivedData( const QValueList<Smb4KPreviewItem *> & ) ) );

  m_share = smb4k_core->scanner()->getPreview( workgroup, host, ip, share, QString::null );

  m_address = QString( "//%1/%2/" ).arg( m_host ).arg( m_share );

  if ( m_share.isEmpty() )
  {
    close();
  }
}


Smb4KPreviewDialog::~Smb4KPreviewDialog()
{
}


void Smb4KPreviewDialog::setupView()
{
  QFrame *frame = plainPage();
  QGridLayout *layout = new QGridLayout( frame );

  m_view = new KIconView( frame, 0, 0 );
  m_view->setItemTextPos( KIconView::Right );
  m_view->setResizeMode( KIconView::Adjust );
  m_view->setArrangement( KIconView::TopToBottom );
  m_view->setSpacing( 1 );
  m_view->setGridX( 200 );
  m_view->setWordWrapIconText( false );
  m_view->setShowToolTips( true );
  m_view->setAutoArrange( true );
  m_view->setSorting( true, true );

  m_toolbar = new KToolBar( frame, 0, true, false );
  m_toolbar->insertButton( BarIcon( "up" ), Up, true, i18n( "Up" ), 0 );
  m_combo = new KComboBox( false, m_toolbar, 0 );
  m_combo->setDuplicatesEnabled( false );
  m_toolbar->insertWidget( Combo, 10, m_combo, 2 );
  m_toolbar->setItemAutoSized( Combo, true );

  layout->addWidget( m_view, 0, 0, 0 );
  layout->addWidget( m_toolbar, 1, 0, 0 );
  setTooltips();
}


void Smb4KPreviewDialog::saveOptions()
{
  config()->setGroup( "Dialogs" );
  config()->writeEntry( "Preview Dialog Geometry", size() );
}


void Smb4KPreviewDialog::readOptions()
{
  config()->setGroup( "Dialogs" );
  setInitialSize( config()->readSizeEntry( "Preview Dialog Geometry", 0L ) );
}


void Smb4KPreviewDialog::setTooltips()
{
  QToolTip::add( m_view, i18n( "Contents" ) );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KPreviewDialog::slotFinished()
{
  saveOptions();
}


void Smb4KPreviewDialog::slotReceivedData( const QValueList<Smb4KPreviewItem *> &list )
{
  Smb4KPreviewItem *preview_item = (Smb4KPreviewItem *)list.first();

  if ( !list.isEmpty() &&
       QString::compare( preview_item->host(), m_host ) == 0 &&
       QString::compare( preview_item->share(), m_share ) == 0 &&
       QString::compare( preview_item->path(), m_path ) == 0 )
  {
    m_view->clear();

    QString item = QString( "%1%2" ).arg( m_address ).arg( m_path );

    if ( m_combo->count() == 0 )
    {
      m_combo->insertItem( item, -1 );
      m_combo->setCurrentItem( 0 );
    }
    else if ( !m_combo->contains( item ) )
    {
      m_combo->insertItem( item, 0 );
      m_combo->setCurrentItem( 0 );
    }
    else
    {
      int index = 0;
      int pos = 0;
      bool exists = false;

      while ( index < m_combo->count() )
      {
        if ( QString::compare( m_combo->text( index ).stripWhiteSpace(), item.stripWhiteSpace() ) == 0 )
        {
          pos = index;
          exists = true;
          break;
        }
        else if ( QString::compare( m_combo->text( index ).stripWhiteSpace(), m_address ) == 0 )
        {
          pos = index;
          exists = true;
          break;
        }
        index++;
      }

      if ( !exists )
      {
        m_combo->insertItem( item, 0 );
        m_combo->setCurrentItem( 0 );
      }
      else
        m_combo->setCurrentItem( pos );
    }

    for ( QValueList<Smb4KPreviewItem *>::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      if ( (*it)->isFile() )
      {
        QIconViewItem *view_item = new QIconViewItem( m_view, (*it)->name(), SmallIcon( "file" ) );
        view_item->setKey( QString( "1%1" ).arg( (*it)->name() ) );
      }
      else
      {
        if ( QString::compare( (*it)->name(), "." ) != 0 && QString::compare( (*it)->name(), ".." ) != 0 )
        {
          QIconViewItem *view_item = new QIconViewItem( m_view, (*it)->name(), SmallIcon( "folder" ) );
          view_item->setKey( QString( "0%1" ).arg( (*it)->name() ) );
        }
      }
    }
  }
  else
  {
    if ( m_path.contains( "/" ) == 1 )
    {
      m_path = QString::null;
    }
    else
    {
      m_path = m_path.section( "/", 0, -2 ).stripWhiteSpace();
    }
  }
}


void Smb4KPreviewDialog::slotItemExecuted( QIconViewItem *item )
{
  if ( !item->key().startsWith( "1" ) )
  {
    QString tmp = item->text();
    m_path.append( tmp ).append( "/" );

    smb4k_core->scanner()->getPreview( m_workgroup, m_host, m_ip, m_share, m_path );
  }
}


void Smb4KPreviewDialog::slotButtonClicked( int id )
{
  if ( id == Up && !m_path.isEmpty() )
  {
    if ( m_path.contains( "/" ) > 1 )
    {
      m_path = m_path.section( "/", 0, -3 ).append( "/" );
    }
    else if ( m_path.contains( "/", true ) == 1 )
    {
      m_path = QString::null;
    }

    smb4k_core->scanner()->getPreview( m_workgroup, m_host, m_ip, m_share, m_path );
  }
}


void Smb4KPreviewDialog::slotItemActivated( const QString &item )
{
  // First we have to strip the address:
  QString path = item.section( m_address, 1, 1 ).stripWhiteSpace();

  smb4k_core->scanner()->getPreview( m_workgroup, m_host, m_ip, m_share, path );

  m_path = path;
}


#include "smb4kpreviewdialog.moc"

