/***************************************************************************
    smb4kpreviewdialog.h  -  description
                             -------------------
    begin                : Fre Jul 4 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPREVIEWDIALOG_H
#define SMB4KPREVIEWDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qvaluelist.h>

// KDE includes
#include <kdialogbase.h>
#include <kiconview.h>
#include <ktoolbar.h>
#include <kcombobox.h>

// application spcific includes
#include "../core/smb4knetworkitems.h"

/**
 * The share preview dialog of Smb4K.
 */

class Smb4KPreviewDialog : public KDialogBase
{
  Q_OBJECT

  friend class Smb4KApp;

  public:
    /**
     * This is the constructor of the preview dialog.
     *
     * @param workgroup     The workgroup the share is in that is to be previewed
     *
     * @param host          The host where the share is located
     *
     * @param ip            The IP address of the host
     *
     * @param share         The share name. Please note, that the preview dialog won't
     *                      be shown, if the share name is empty.
     *
     * @param parent        The parent of this widget
     *
     * @param name          The name of this widget
     *
     * @param modal         Sets the modal mode for this widget
     */
    Smb4KPreviewDialog( const QString &workgroup, const QString &host, const QString &ip, const QString &share, QWidget *parent = 0, const char *name = 0, bool modal = false );
    /**
     * The destructor.
     */
    ~Smb4KPreviewDialog();

  protected slots:
    /**
     * Is called, when the dialog is finished.
     */
    void slotFinished();
    /**
     * Is called, if the scanner returned data.
     */
    void slotReceivedData( const QValueList<Smb4KPreviewItem *> &list );
    /**
     * Is called, if one icon view item is clicked.
     */
    void slotItemExecuted( QIconViewItem *item );
    /**
     * Is called, if a tool bar button is clicked.
     */
    void slotButtonClicked( int id );
    /**
     * Is called, if an item in the combo box is activated.
     */
    void slotItemActivated( const QString &item );

  private:
    /**
     * Enumeration for the buttons.
     */
    enum ButtonID{ Up, Combo };
    /**
     * Set the tooltips.
     */
    void setTooltips();
    /**
     * Saves the options.
     */
    void saveOptions();
    /**
     * Reads the options.
     */
    void readOptions();
    /**
     * Sets up the file view.
     */
    void setupView();
    /**
     * The icon view.
     */
    KIconView *m_view;
    /**
     * The current workgroup
     */
    QString m_workgroup;
    /**
     * The current host
     */
    QString m_host;
    /**
     * The current share
     */
    QString m_share;
    /**
     * The current path.
     */
    QString m_path;
    /**
     * The current host's IP address.
     */
    QString m_ip;
    /**
     * The toolbar.
     */
    KToolBar *m_toolbar;
    /**
     * The combo box.
     */
    KComboBox *m_combo;
    /**
     * Holds the "address", i.e. the address of the share.
     */
    QString m_address;
};
#endif
