/***************************************************************************
                          smb4kprintinfo  -  description
                             -------------------
    begin                : Mo Apr 19 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPRINTINFO_H
#define SMB4KPRINTINFO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qstring.h>

/**
 * This class provides a container that holds all the info
 * that is needed to print a file.
 */

class Smb4KPrintInfo
{
  public:
    /**
     * The constructor.
     */
    Smb4KPrintInfo( const QString &workgroup, const QString &host, const QString &ip, const QString &printer, const QString &filepath, int copies = 1 );
    /**
     * Empty constructor.
     */
    Smb4KPrintInfo() {}
    /**
     * The destructor.
     */
    ~Smb4KPrintInfo();
    /**
     * Returns the path of the file.
     */
    QString path() const;
    /**
     * Returns the host where the printer is located.
     */
    QString host() const;
    /**
     * Returns the workgroup in which the host located.
     */
    QString workgroup() const;
    /**
     * Returns the name of the printer.
     */
    QString printer() const;
    /**
     * Returns the IP address of the host.
     */
    QString ip() const;
    /**
     * Sets the path to the file to print.
     */
    void setPath( const QString &path );
    /**
     * Returns the number of copies the user wants to have.
     */
    int copies() const;
    /**
     * Sets the number of copies.
     */
    void setCopies( int num );

  private:
    /**
     * The workgroup.
     */
    QString m_workgroup;
    /**
     * The host.
     */
    QString m_host;
    /**
     * The IP address.
     */
    QString m_ip;
    /**
     * The printer name.
     */
    QString m_printer;
    /**
     * The path to the file to print.
     */
    QString m_path;
    /**
     * Holds the number of copies the user wants to have.
     */
    int m_copies;
};

#endif

