/***************************************************************************
    smb4kappearance.h  -  description
                             -------------------
    begin                : Di Okt 28 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KAPPEARANCEOPTIONS_H
#define SMB4KAPPEARANCEOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

/** The configuration dialog for the appearance of Smb4K.
 *
 * @author Alexander Reinholdt  <dustpuppy@mail.berlios.de>
 */

class Smb4KAppearanceOptions : public QWidget
{
  Q_OBJECT

  friend class Smb4KOptionsDlg;

  public:
    /**
     * The constructor
     */
    Smb4KAppearanceOptions( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor
     */
    ~Smb4KAppearanceOptions();

  protected slots:
    /**
     * Enables/disables buttons according to the toggle state of the "Show hidden shares." button.
     *
     * @param state  Describes the toggle state of the "Show hidden shares"  checkbox.
     */
    void slotShowHiddenShares( int state );

  private:
    /**
     * The checkbox for the appearance of the share view.
     */
    QCheckBox *m_shareview;
    /**
     * Checkbox for the description of the share.
     */
    QCheckBox *m_description;
    /**
     * This checkbox determines, whether externally mounted shares
     * are to be displayed.
     */
    QCheckBox *m_external;
    /**
     * Show hidden shares.
     */
    QCheckBox *m_showHidden;
    /**
     * Show IPC shares.
     */
    QCheckBox *m_showIPC;
    /**
     * Show ADMIN shares.
     */
    QCheckBox *m_showAdmin;
    /**
     * Show type of share.
     */
    QCheckBox *m_showType;
    /**
     * Show comment of share.
     */
    QCheckBox *m_showComment;
    /**
     * Show printer shares.
     */
    QCheckBox *m_showPrinter;
    /**
     * Show the IP address of the host.
     */
    QCheckBox *m_showIP;
    /**
     * This check box determines whether the tool tip with the
     * info of the share should be shown.
     */
    QCheckBox *m_showShareTooltip;
    /**
     * This check box determies whether the tool tip with the
     * info about a network item should be shown.
     */
    QCheckBox *m_showNetworkItemTooltip;

};
#endif
