/***************************************************************************
    smb4kauthoptions  -  The configuration page for the authentication
    settings of Smb4K
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qcheckbox.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qwhatsthis.h>

// KDE includes
#include <klocale.h>
#include <klineedit.h>

// application specific includes
#include "smb4kauthoptions.h"

Smb4KAuthOptions::Smb4KAuthOptions( QWidget *parent, const char *name )
: QWidget( parent, name )
{
  //
  // Default Authentication
  //
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );

  QButtonGroup *password_group = new QButtonGroup( 1, QButtonGroup::Horizontal,
                                 i18n( "Password Storage" ), this );
  QCheckBox *use_wallet =        new QCheckBox( i18n( "Save the authentication data in a wallet" ),
                                 password_group, "kcfg_UseWallet" );
  (void) new QCheckBox( i18n( "If no wallet is used, remember authentication data during run time" ),
                                 password_group, "kcfg_RememberPasswords" );

  QGroupBox *login_box =         new QGroupBox( 1, Qt::Horizontal, i18n( "Default Login" ),
                                 this, "DefaultLoginBox" );
//   login_box->setInsideMargin( 10 );

  QCheckBox *default_auth =      new QCheckBox( i18n( "Use default login" ),
                                 login_box, "kcfg_UseDefaultLogin" );

  QWidget *auth_widget =         new QWidget( login_box, "DefaultAuthWidget" );
  QGridLayout *auth_grid =       new QGridLayout( auth_widget );
  auth_grid->setSpacing( 5 );

  QLabel *login =                new QLabel( i18n( "User:" ), auth_widget );
  KLineEdit *default_login =     new KLineEdit( auth_widget, "DefaultUserName" );
  default_login->setMinimumWidth( 150 );
  QWhatsThis::add( default_login, i18n( "This login name is used by default to authenticate to a remote server." ) );
  QLabel *password =             new QLabel( i18n( "Password:" ), auth_widget );
  KLineEdit *default_password =  new KLineEdit( auth_widget, "DefaultPassword" );
  default_password->setEchoMode( KLineEdit::Password );
  default_password->setMinimumWidth( 150 );
  QWhatsThis::add( default_password, i18n( "This password is used by default to authenticate to a remote server. It may be empty." ) );

  auth_grid->addWidget( login, 0, 0 );
  auth_grid->addWidget( default_login, 0, 1 );
  auth_grid->addWidget( password, 1, 0 );
  auth_grid->addWidget( default_password, 1, 1 );

  QSpacerItem *spacer2 =         new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addWidget( password_group, 0, 0, 0 );
  grid->addWidget( login_box, 1, 0, 0 );
  grid->addItem( spacer2, 2, 0 );

  connect( use_wallet,  SIGNAL( stateChanged( int ) ),
           this,          SLOT( slotKWalletButtonState( int ) ) );
  connect( default_auth, SIGNAL( stateChanged( int ) ),
           this,          SLOT( slotDefaultAuthButtonState( int ) ) );

  slotKWalletButtonState( use_wallet->state() );
  slotDefaultAuthButtonState( default_auth->state() );
}


Smb4KAuthOptions::~Smb4KAuthOptions()
{
}

/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KAuthOptions::slotKWalletButtonState( int state )
{
  if ( state == QCheckBox::On )
  {
    static_cast<QCheckBox *>( child( "DefaultLoginBox", "QGroupBox", true ) )->setEnabled( true );
  }
  else if ( state == QCheckBox::Off )
  {
    static_cast<QCheckBox *>( child( "DefaultLoginBox", "QGroupBox", true ) )->setEnabled( false );
  }
}


void Smb4KAuthOptions::slotDefaultAuthButtonState( int state )
{
  if ( state == QCheckBox::On )
  {
    static_cast<QCheckBox *>( child( "DefaultAuthWidget", "QWidget", true ) )->setEnabled( true );
  }
  else if ( state == QCheckBox::Off )
  {
    static_cast<QCheckBox *>( child( "DefaultAuthWidget", "QWidget", true ) )->setEnabled( false );
  }
}



#include "smb4kauthoptions.moc"
