#include <config.h>
#include <iostream>
#include <string>
using std::string;

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "extensions.h"

/** Stoopid really - being a C coder I'd used pointers for most of the kino 
	code (rather than references) and have suffered ever since... even the most 
	recent code in kino suffers from this (wrongly chosen to try to keep 
	consistency... bad, bad idea.. sigh). 

	This is only sightly better - the pool is now a reference, but the methods
	still use pointers for the frames.
*/

class SmilExtendedFramePool : public ExtendedFramePool
{
	private:
		FramePool &pool;

	public:
		SmilExtendedFramePool( FramePool &in_pool ) : pool( in_pool )
		{
		}

		Frame &GetFrame( )
		{
			return *pool.GetFrame();
		}

		void DoneWithFrame( Frame &frame )
		{
			pool.DoneWithFrame( &frame );
		}
};

ExtendedFramePool &ExtendedFramePool::Get( )
{
	static SmilExtendedFramePool pool( *GetFramePool( ) );
	return pool;
}


