#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "headers.h"

Headers::Headers()
{
    head = current = NULL;
}

Headers::~Headers()
{
    HeaderNode *node;

    while (node = head) {
         head = node->next;
         free(node->name);
         free(node->value);
         delete node;
    }
    head = current = NULL;
}

void Headers::Replace(const char *name, const char *value)
{
    HeaderNode *node = head;

    while (node) {
         if (!strcasecmp(node->name, name)) {
              free(node->value);
              node->value = strdup(value);
              return;
         }
         node = node->next;
    }
    Add(name, value);
}

void Headers::Add(const char *name, int value)
{
    char buf[15];

    sprintf(buf,"%d",value);
    Add(name,buf);
}

void Headers::Add(const char *name, const char *value)
{
    HeaderNode *node = new HeaderNode;

    node->name = strdup(name);
    node->value = strdup(value);
    node->next = head;
    head = node;
}

const char *Headers::Header(const char *name)
{
    const char *h_name, *value;

    h_name = FirstHeader(&value);
    while (h_name && strcasecmp(name, h_name)) h_name = NextHeader(&value);

    return (!!h_name) ? value : NULL;
}

const char *Headers::FirstHeader(const char **value)
{
    current = head;
    if (!current) return NULL;
    *value = current->value;
    return current->name;
}

const char *Headers::NextHeader(const char **value)
{
    current = current->next;
    if (!current) return NULL;
    *value = current->value;
    return current->name;
}
