#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <pwd.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cgdbm.h"
#include "addrbook.h"
#include "vsprintf.h"
#include "match.h"

#define SHOW_ERR fprintf(stderr, addr_info, SMSADDR)

const char *addr_info = 
"Uzycie:\n\t%s -a nazwa numer | -r nazwa | -l [ nazwa ] | -s maska\n\n"\
"\t-a  dodaje podana pozycje do ksiazki adresowej\n"\
"\t-r  usuwa wpis o podanej nazwie z ksiazki adresowej\n"\
"\t-l  wypisuje cala zawartosc bazy, lub tylko rekord o podanej nazwie\n"\
"\t-s  wypisuje rekordy pasujace do podanej maski, np: ani*\n"\
"\t    maski lepiej objac tutaj cudzyslowami, zeby shell sam z siebie\n"\
"\t    ich nie popodmienial, czyli: smsaddr -s \"ani*\"\n\n"\
"Przy wysylaniu sms'ow zamiast numeru mozna podac nazwe pozycji z ksiazki\n"\
"adresowej. Numery nalezy podawac w takim formacie jak dla programu sms, czyli\n"\
"bez kodu kraju, np: 602123456\n\n"\
"Mikolaj Rydzewski, <miki@ceti.pl>\n";

// funkcja wyznaczy pelna nazwe pliku ksiazki adresowej - bedzie on w glownym
// katalogu katalogu domowego usera, ktory program uruchomil
char *getdb_filename()
{
        struct passwd *pwd;
	struct stat buf;
        static char file[MAXPATHLEN];
	char *path;
        
        if (!(pwd = getpwuid(getuid()))) return NULL;
	if ((path = getenv("CONFIG_DIR")) && *path)
		snprintf(file, sizeof(file)-1, "%s/%s/%s",pwd->pw_dir, path, ADDRDB);
	else
		snprintf(file, sizeof(file)-1, "%s/.%s", pwd->pw_dir, ADDRDB);
        return file;
}

int addr_main(int argc, char **argv)
{
        if (argc < 2) {
               SHOW_ERR;
               return 1;
        }

        Cgdbm db;
        char *db_file = getdb_filename();
        if (!db_file) return -1;

        switch (*(++argv[1])) {
          case 'a': 
                   if (argc == 4) {
                   db.Open(db_file, 0, GDBM_WRCREAT);
		   if (!db.Status()) {
			fprintf(stderr,"Nie moge utworzyc pliku ksiazki.\n");
			return 1;
		   }
                   Cdatum nazwa(argv[2]);
                   Cdatum numer(argv[3]);
                   if (db.Insert(nazwa, numer) == 1)
                      printf("Podany klucz juz istnieje w ksiazce.\n");
                   } else SHOW_ERR;
                   break;
	  case 's': {
		db.Open(db_file, 0, GDBM_READER);
		if (!db.Status()) {
			fprintf(stderr,"Nie moge otworzyc pliku ksiazki.\n");
			return 1;
		}
		if (argc == 3) {
		      char *glob = argv[2];
                      Cdatum nazwa = db.FirstKey();
                      while (!nazwa.IsNull()) {
                            Cdatum &numer = db.Fetch(nazwa);
			    if (match(glob, (char*)(const char*)nazwa)) 
	                            printf("%s%s%s\n", (const char*)nazwa,
					(strlen((const char*)nazwa)<8)?"\t\t\t":"\t\t",
					(const char*)numer);
                            delete &numer;
                            nazwa = db.NextKey(nazwa);
                      } 
		} else SHOW_ERR;
		    }
		    break;
          case 'l': {
                   db.Open(db_file, 0, GDBM_READER);
		   if (!db.Status()) {
			fprintf(stderr,"Nie moge otworzyc pliku ksiazki.\n");
			return 1;
		   }
                   if (argc == 3) {
                      Cdatum nazwa(argv[2]);
                      if (db.Exists(nazwa)) {
                         Cdatum &numer = db.Fetch(nazwa);
                         printf("%s%s%s\n", (const char*)nazwa,
				(strlen((const char*)nazwa)<8)?"\t\t\t":"\t\t",
				(const char*)numer);
                         delete &numer;
                      } else printf("Brak podanego klucza w ksiazce.\n");
                   } else {
                      Cdatum nazwa = db.FirstKey();
                      while (!nazwa.IsNull()) {
                            Cdatum &numer = db.Fetch(nazwa);
                            printf("%s%s%s\n", (const char*)nazwa,
				(strlen((const char*)nazwa)<8)?"\t\t\t":"\t\t",
				(const char*)numer);
                            delete &numer;
                            nazwa = db.NextKey(nazwa);
                      }
                   }
                }
                break;
          case 'r': {
                   if (argc == 3) {
                      db.Open(db_file, 0, GDBM_WRITER);
		      if (!db.Status()) {
			fprintf(stderr,"Nie moge otworzyc pliku ksiazki.\n");
			return 1;
		      }
                      Cdatum nazwa(argv[2]);
                      if (db.Delete(nazwa) == -1) printf("Brak podanego klucza w ksiazce.\n");
                      else db.Reorganize();
                   } else SHOW_ERR;
                }
                break; 
          default: SHOW_ERR;
        }

        return 0;
}

char *lookup_addrbook(const char *key, char *buf, int size)
{
        char *df = getdb_filename();
	if (!df) return NULL;

        Cgdbm db(df, 0, GDBM_READER);

	if (!db.Status()) return NULL;

        Cdatum nazwa(key);
        if (db.Exists(nazwa)) {
           Cdatum &numer = db.Fetch(nazwa);
           strncpy(buf, (const char*)numer, size);
           delete &numer;
           return buf;
        }
        return NULL;
}
