#ifndef __request_h
#define __request_h

#include "socket.h"
#include "headers.h"

extern const char *HTTP_VER;

class HTTP_Request {
protected:
    char *host, *body, *w3_host, *w3host_prefix;
    int port, w3_port;
    Headers *headers;

    void ParseHeaders(Headers &hd, const char *buf, int buf_len);
    const char *JoinFormFields(Headers &fields);
    char *str2url(const char *name, char *buf);
    Socket *CreateSocket();
public:
    HTTP_Request(const char *_host, int _port = 80, const char *_w3_host = NULL, int _w3_port = 0);
    ~HTTP_Request();

    Headers *GetData(const char *path, int retr_body = 1);
    Headers *PostData(const char *path, Headers &fields);

    void ReplaceHeader(const char *name, const char *value);
    void AddHeader(const char *name, const char *value);
    const char *Header(const char *name);
    const char *GetBody();
};

#endif
