#include <stdlib.h>
#include <ctype.h>
#include "debug.h"
#include "generic_sms.h"
#include "era.h"
#include "eranet.h"
#include "miastoplusa.h"
#include "orangembox.h"
#include "plusmail.h"
#include "plus.h"
#include "o2uk.h"

using namespace std;

GenericSMS &GenericSMS::Factory(Config &config)
{
	GenericSMS *sms;

	if (config["gateway"] == "era") sms = new EraSMS(config);
	else if (config["gateway"] == "eranet")	sms = new EranetSMS(config);
	else if (config["gateway"] == "miastoplusa") sms = new MiastoplusaSMS(config);
	else if (config["gateway"] == "orangembox") sms = new OrangemboxSMS(config);
	else if (config["gateway"] == "plusmail") sms = new PlusmailSMS(config);
	else if (config["gateway"] == "plus") sms = new PlusSMS(config);
	else if (config["gateway"] == "o2uk") sms = new O2ukSMS(config);
	else if (config["gateway"] == "test") sms = new TestSMS(config);
	else throw Exception("Unknown SMS->WWW gateway."); 
	
	return *sms;
}

bool GenericSMS::SendMessage(const string &phone_no, const string &message)
{
	long num_parts;
	
	if (phone_no == "") throw Exception("No phone number specified.");
	if (message == "") throw Exception("No message specified.");
	
	string normalized_phone_no = NormalizePhoneNo(phone_no, "+48");
	string full_message = message;
	
	num_parts = strtol(config["num_parts"].c_str(), (char**)NULL, 10);
	if (num_parts > 0) full_message = full_message.substr(0, 160 * num_parts);
	
	
	return Send(normalized_phone_no, full_message);
}

string GenericSMS::NormalizePhoneNo(const string &phone_no, const string &prefix)
{
	return (phone_no[0] != '+' && isdigit(phone_no[0])) ? prefix + phone_no : phone_no;
}

bool GenericSMS::ShowStats()
{
	return false;
}
