#ifndef __generic_sms
#define __generic_sms

#include <string>
#include <iostream>
#include "mr_curl/mr_curl.h"
#include "config.h"
#include "debug.h"

class GenericSMS {
protected:
	// ile znakow moze przyjac pojedyncza wiadomosc w bramce
	int max_chars;
	Curl curl;
	Config config;
	
	// wysyla konkretna wiadomosc przez okreslona bramke. musi byc pokryta
	// w potomnych klasach
	virtual bool Send(const std::string &phone_no, const std::string &message) = 0;
	
	// jesli trzeba doklei kod kraju do numeru telefonu
	std::string NormalizePhoneNo(const std::string &phone_no, const std::string &prefix);
public:
	GenericSMS(const Config &config) : config(config) {};
	virtual ~GenericSMS() {};
	
	// na podstawie parametrow zawartych w konfiguracji zwroci klase do
	// wysylania SMSow przez odpowiednia bramke
	static GenericSMS &Factory(Config &config);
	
	// wysyla SMSa na okreslony numer. dlugosc wiadomosci moze byc dowolna,
	// jesli jest wieksza niz max_chars to zostanie podzielona na odpowiednia
	// ilosc mniejszych czesci
	bool SendMessage(const std::string &phone_no, const std::string &message);
	
	// pokazuje dodatkowe informacje z bramki (o ile sa dostepne)
	virtual bool ShowStats();
};


class TestSMS : public GenericSMS {
public:
	TestSMS(const Config &config) : GenericSMS(config) {};
	virtual bool Send(const std::string &phone_no, const std::string &message) {
		std::cout << "TestSMS " << phone_no << " - " << message << std::endl;
		return true;
	};
};

#endif
