/*
SMS Server Tools 3
Copyright (C) Keijo Kasvi
http://smstools3.kekekasvi.com/

Based on SMS Server Tools 2 from Stefan Frings
http://www.meinemullemaus.de/

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.
*/

#include <syslog.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "whitelist.h"
#include "extras.h"
#include "logging.h"
#include "alarm.h"
#include "smsd_cfg.h"

int inwhitelist(char* msisdn)
{
  FILE* file;
  char line[256];
  char* posi;
  if (whitelist[0]) // is a whitelist file specified?
  {
    file=fopen(whitelist,"r");
    if (file)
    {
      while (fgets(line,sizeof(line),file))
      {
        posi=strchr(line,'#');     // remove comment
        if (posi)
          *posi=0;
        cutspaces(line);
	if (strlen(line)>0)
	{
          if (strncmp(msisdn,line,strlen(line))==0)
	  {
	    fclose(file);
            return 1;
	  }  
	  else if (msisdn[0]=='s' && strncmp(msisdn+1,line,strlen(line))==0)
	  {
	    fclose(file);
	    return 1;
	  }
	}  
      }  
      fclose(file);
      return 0;
    }  
    else
    {
      writelogfile(LOG_CRIT,"smsd","Stopping. Cannot read whitelist file %s.",whitelist);
      alarm_handler(LOG_CRIT,"smsd","Stopping. Cannot read whitelist file %s.",whitelist);
      remove_pid(pidfile);
      signal(SIGTERM,SIG_IGN);
      kill(0,SIGTERM);
      exit(127);
    }
  }      
  return 1;
}
