# smtpf.plot : input file for gnuplot

# Usage: gnuplot smtpf.plot

set term x11
#set term latex
#set term postscript portrait "Times-Roman"
#set term postscript "Times-Roman"
#set term tgif
#set term pbm color

#set tics out
set grid
set xrange [0:5]
set yrange [1:1200]
#set logscale x
#set logscale y

#set xlabel "Recipients"
set ylabel "Time (Sec)"
#set label "label" at 100,150 center
#set key 80,150

set xtics ( \
	"MX" 1, \
	"90%%SMTP" 2, \
	"90%%Total" 3, \
	"Total" 4 \
	)

set title "Performance of delivery with smtpfeed"

#set output "out-a.pbm"

plot \
	'gp-data.a' using 1:10 title "" with points 1, \
	'gp-data.a' using 2:11 title "" with points 2, \
	'gp-data.a' using 3:13 title "" with points 3, \
	'gp-data.a' using 4:14 title "" with points 4

pause -1 "Hit return to continue"

set xlabel "Transactions"

#set output "out-b.pbm"

plot \
	'gp-data.b' using 1:10 title "MX" with points 1, \
	'gp-data.b' using 2:11 title "90%SMTP" with points 2, \
	'gp-data.b' using 3:13 title "90%Total" with points 3, \
	'gp-data.b' using 4:14 title "Total" with points 4

pause -1 "Hit return to continue"

#set nologscale y
#set yrange [0:0.1]
set logscale y
set yrange [0.001:]

set xlabel "Recipients"
set ylabel "Time/Recipients (Sec/Rec)"

#set output "out-c.pbm"

plot \
	'gp-data.c' using 1:10 title "MX" with points 1, \
	'gp-data.c' using 2:11 title "90%SMTP" with points 2, \
	'gp-data.c' using 3:13 title "90%Total" with points 3, \
	'gp-data.c' using 4:14 title "Total" with points 4

pause -1 "Hit return to continue"

set xlabel "Transactions"
set ylabel "Time/Recipients (Sec/Trans)"

#set output "out-d.pbm"

plot \
	'gp-data.d' using 1:10 title "MX" with points 1, \
	'gp-data.d' using 2:11 title "90%SMTP" with points 2, \
	'gp-data.d' using 3:13 title "90%Total" with points 3, \
	'gp-data.d' using 4:14 title "Total" with points 4

pause -1 "Hit return to continue"

set nologscale x
set logscale y
set xrange [*:*]
set yrange [0.001:]

set xlabel "Time"
set ylabel "Time/Recipients (Sec/Rec)"

#set output "out-e.pbm"

plot \
	'gp-data.e' using 1:10 title "MX" with points 1, \
	'gp-data.e' using 2:11 title "90%SMTP" with points 2, \
	'gp-data.e' using 3:13 title "90%Total" with points 3, \
	'gp-data.e' using 4:14 title "Total" with points 4

pause -1 "Hit return to continue"

set ylabel "Time/Recipients (Sec/Trans)"

#set output "out-f.pbm"

plot \
	'gp-data.f' using 1:10 title "MX" with points 1, \
	'gp-data.f' using 2:11 title "90%SMTP" with points 2, \
	'gp-data.f' using 3:13 title "90%Total" with points 3, \
	'gp-data.f' using 4:14 title "Total" with points 4

pause -1 "Hit return to continue"

#set nolabel
