/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: mailwarn.c,v 1.2 2005/11/25 02:48:54 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "smtpguard/smtpguard.h"
#include "smtpguard/smtpguard-daemon.h"
#include "smtpguard/sg_io.h"

// From: alert@eonet.ne.jp
// To: callcenter@eonet.ne.jp
// Date: 11 Aug 2003 12:11:11
// Subject: SMTPGUARD ALM <IP>
//
// ALERT MESSAGE FROM SMTPGUARD @ <HOST>
//
// IP: <IP ADDR>
// FROM: <MAIL FROM>
// TO: <RCPT TO>
// POINT: <POINT>
// DELETE AFTER: <SECOND> (s)

#define FROM 	"From: "
#define TO 	"To: "
#define SUBJECT "Subject: SMTPGUARD ALM "
#define LINE1 	"ALERT MESSAGE FROM SMTPGUARD @ "
#define LINE2	"IP: "
#define LINE3	"FROM: "
#define LINE4	"TO: "
#define LINE5	"POINT: "
#define LINE6	"DELETE AFTER: "
#define LINE6_2 " (s)"

int
mailwarn (char *rcptto, FGSmtpInfo *fsi, idb_data_t *d)
{
    char *args[] = { sendmail, "-f" , mailfrom, "--", rcptto, 0};
	char *msg, p_buf[16], dt_buf[16];
	int pid, len;
	int pi[2];
	time_t now = sg_time(NULL);
	
	if (!(*mailfrom) || !(*rcptto) || !(*sendmail)) {
		return -1;
	}

	if (snprintf (p_buf, sizeof(p_buf), "%u", d->P) <= 0) {
		sg_err(0, "mailwarn: snprintf p_buf\n");
		return -1;
	}
	if (snprintf (dt_buf, sizeof(dt_buf), "%lu", d->xtime - now) <= 0) {
		sg_err(0,"mailwarn: snprintf dt_buf\n");
		return -1;
	}

	len  = strlen(FROM)	+ strlen(mailfrom)  + 1;
	len += strlen(TO)	+ strlen(rcptto)    + 1;
	len += strlen(SUBJECT)	+ strlen(fg_smtp_info_get_addr(fsi))+ 2;
	len += strlen(LINE1)	+ strlen(hostname)  + 2;
	len += strlen(LINE2)    + strlen(fg_smtp_info_get_addr(fsi))       + 1;
	if (fg_smtp_info_get_mailfrom(fsi))
		len += strlen(LINE3) 	+ strlen(fg_smtp_info_get_mailfrom(fsi)) + 1;
	if (fg_smtp_info_get_rcptto(fsi))
		len += strlen(LINE4) 	+ strlen(fg_smtp_info_get_rcptto(fsi))   + 1;
	len += strlen(LINE5) 	+ strlen(p_buf)     + 1;
	len += strlen(LINE6) 	+ strlen(dt_buf)    + strlen(LINE6_2) + 1;
		
	msg = malloc(len);
	if (msg == NULL) {
		sg_err(errno, "mailwarn: malloc msg");
		return -1;
	}
	snprintf(msg, len,
		      "%s%s\n"
		      "%s%s\n"
		      "%s%s\n\n"
		      "%s%s\n\n"
		      "%s%s\n"
		      "%s%s\n"
		      "%s%s\n"
		      "%s%s\n"
		      "%s%s%s\n",
		      FROM, mailfrom,
		      TO, rcptto,
		      SUBJECT, fg_smtp_info_get_addr(fsi),
		      LINE1, hostname,
		      LINE2, fg_smtp_info_get_addr(fsi),
		      LINE3, fg_smtp_info_get_mailfrom(fsi),
		      LINE4, fg_smtp_info_get_rcptto(fsi),
		      LINE5, p_buf,
		      LINE6, dt_buf, LINE6_2);
	
	if (pipe(pi) == -1) {
		free(msg);
		sg_err(errno, "mailwarn: pipe");
		return -1;
	}
	switch(pid = fork()) {
		case -1:
			free(msg);
			sg_err(errno, "mailwarn: fork");
			if (close(pi[0]) == -1) {
				sg_err(errno, "mailwarn: close pi[0] case -1");
				return -1;
			}
			if (close(pi[1]) == -1) {
				sg_err(errno, "mailwarn: close pi[1] case -1");
				return -1;
			}
			return -1;
		case 0:
			if (close(pi[1]) == -1) {
				sg_err(errno, "mailwarn: close pi[1] case 0");
				exit(1);
			}
			if (dup2(pi[0], 0) == -1) {
				sg_err(errno, "mailwarn: dup2 case 0");
				exit(1);
			}
			if (close(pi[0]) == -1) {
				sg_err(errno, "mailwarn: close pi[0] case 0");
				exit(1);
			}
			execv(*(args), args);
			sg_err(errno, "mailwarn: execv");
			sleep(1);
			exit(1);
		default:
			if (close(pi[0]) == -1) {
				free(msg);
				sg_err(errno, "mailwarn: close pi[0] case default");
				return -1;
			}
			
			len = strlen(msg);
			if (sg_write(pi[1], msg, len, 1) < 0)
				sg_err(0, "mailwarn: sg_write error");

			free(msg);
			if (close(pi[1]) == -1) {
				sg_err(errno, "mailwarn: close pi[1] case default");
				return -1;
			}
			return 0;
#if 0 /* unused */
		fail:
			free(msg);
			if (close(pi[1]) == -1) {
				sg_err(errno, "mailwarn: close pi[1] case fail");
				return -1;
			}
			return -1;
#endif /* unused */
	}
}

void
mailwarn_handle (int signum)
{
	int e = errno;
	int pid;
	int status;

	while(1) {
#ifdef SOLARIS8
		pid = waitpid(-1, &status, WNOHANG);
#else
		pid = waitpid(WAIT_ANY, &status, WNOHANG);
#endif
		if (pid < 0) {
			if (errno == ECHILD)
				break;
			else {
				sg_err(errno, "mailwarn: non-zero waitpid %d errno %d", pid, errno);
				break;
			}
		}
		if (pid == 0)
			break;
		if (WEXITSTATUS(status) == 0)
			break;
		else {
			sg_err(errno, "mailwarn: %d status %d", pid, status);
			break;
		}
	}

	errno = e;
}
