/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*  $Id: fg-smtp-info.h,v 1.1.1.1 2005/11/04 07:19:34 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FG_SMTP_INFO_H
#define FG_SMTP_INFO_H

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define FG_TYPE_SMTP_INFO         (fg_smtp_info_get_type ())
#define FG_SMTP_INFO(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), FG_TYPE_SMTP_INFO, FGSmtpInfo))
#define FG_SMTP_INFO_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), FG_TYPE_SMTP_INFO, FGSmtpInfoClass))
#define FG_IS_SMTP_INFO(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), FG_TYPE_SMTP_INFO))
#define FG_IS_SMTP_INFO_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), FG_TYPE_SMTP_INFO))
#define FG_SMTP_INFO_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), FG_TYPE_SMTP_INFO, FGSmtpInfoClass))

typedef enum
{
	FG_SMTP_INFO_ERROR_UNKNOWN,
	FG_SMTP_INFO_ERROR_ALLOC_FAILED,
	FG_SMTP_INFO_ERROR_INVALID_XML,
	FG_SMTP_INFO_ERROR_XML_READ_FAILED,
	FG_SMTP_INFO_ERROR_XML_PARSE_FAILED,
	FG_SMTP_INFO_ERROR_GET_XML_FAILED,
	FG_SMTP_INFO_ERROR_INVALID_VALUE,
	FG_SMTP_INFO_ERROR_SOCKET_ERROR,
	FG_SMTP_INFO_ERROR_PROTOCOL_ERROR,
	FG_SMTP_INFO_ERROR_IO_ERROR,
	FG_SMTP_INFO_ERROR_DB_SEARCH_FAILED,
	FG_SMTP_INFO_ERROR_DB_UPDATE_FAILED,
	FG_SMTP_INFO_ERROR_EVALCALC_FAILED,
	FG_SMTP_INFO_ERROR_DAEMON_ERROR
} FGSmtpInfoError;

#define FG_SMTP_INFO_ERROR fg_smtp_info_error_quark()
GQuark fg_smtp_info_error_quark (void);

typedef struct {
	GObject parent;
} FGSmtpInfo;

typedef struct {
	GObjectClass parent_class;
	/* Add Signal Functions Here */
} FGSmtpInfoClass;

GType fg_smtp_info_get_type (void);

FGSmtpInfo *fg_smtp_info_new (gboolean session);
FGSmtpInfo *fg_smtp_info_new_from_xml (gboolean session, const gchar *xmlbuff,
				       gsize len, GError **error);

/* malloced buffer */
gchar *fg_smtp_info_get_xml (FGSmtpInfo *fsi, GError **error);


/* set values */
void fg_smtp_info_set_session (FGSmtpInfo *fsi, gboolean session);
gint fg_smtp_info_set_addr (FGSmtpInfo *fsi, const gchar *addr, gboolean mynetworks);
void fg_smtp_info_set_pid (FGSmtpInfo *fsi, gint pid);
gint fg_smtp_info_set_mailfrom (FGSmtpInfo *fsi, const gchar *mailfrom);
gint fg_smtp_info_set_rcptto (FGSmtpInfo *fsi, const gchar *rcptto, gboolean mydestination);
gint fg_smtp_info_set_action (FGSmtpInfo *fsi, gchar *message, gint wait, gint code);
gint fg_smtp_info_set_action_message (FGSmtpInfo *fsi, gchar *message);
void fg_smtp_info_set_wait (FGSmtpInfo *fsi, gint wait);
#define fg_smtp_info_delete_action(x) fg_smtp_info_set_action_message(x,NULL)


void fg_smtp_info_free (FGSmtpInfo *fsi);

/* get values */
gboolean fg_smtp_info_is_session (FGSmtpInfo *fsi);
gchar *fg_smtp_info_get_addr (FGSmtpInfo *fsi);
gint fg_smtp_info_get_pid (FGSmtpInfo *fsi);
gchar *fg_smtp_info_get_mailfrom (FGSmtpInfo *fsi);
gchar *fg_smtp_info_get_rcptto (FGSmtpInfo *fsi);
gboolean fg_smtp_info_is_mynetworks (FGSmtpInfo *fsi);
gboolean fg_smtp_info_is_mydestination (FGSmtpInfo *fsi);
gchar *fg_smtp_info_get_action_message (FGSmtpInfo *fsi);
gint fg_smtp_info_get_wait (FGSmtpInfo *fsi);
gint fg_smtp_info_get_action_code (FGSmtpInfo *fsi);

/* utils */
void fg_smtp_info_sleep_wait (FGSmtpInfo *fsi);

#endif /* FG_SMTP_INFO_H */
