/*==================================================================
 * seq_alsa.h - Header file for ALSA sequencer routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __SEQ_ALSA_H__
#define __SEQ_ALSA_H__

#include "config.h"

#ifdef ALSA_SUPPORT

#include <glib.h>
#include <sys/asoundlib.h>
#include "alsa.h"

snd_seq_t *seq_alsa_handle;

gint seq_alsa_vkeyb_conn_client;
gint seq_alsa_vkeyb_conn_port;

gboolean seq_alsa_vkeyb_active;

gint seq_alsa_fd;

void seq_alsa_load_config (void);
gint seq_alsa_init (void);
void seq_alsa_close (void);
gint seq_alsa_vkeyb_init (void);
void seq_alsa_vkeyb_close (void);
gint seq_alsa_find_port (gchar *namematch, gint perm, gint type, gint *client,
			 gint *port);
gboolean seq_alsa_is_subscribed (snd_seq_addr_t *src, snd_seq_addr_t *dest);

void seq_alsa_set_bank (gint chan, gint bank);
void seq_alsa_set_preset (gint chan, gint preset);
void seq_alsa_note_on (gint chan, gint note, gint vel);
void seq_alsa_note_off (gint chan, gint note, gint vel);
void seq_alsa_pitch_bender (gint chan, gint bendval);
void seq_alsa_pitch_bend_range (gint chan, gint range);
void seq_alsa_main_volume (gint chan, gint volume);
void seq_alsa_chorus (gint chan, gint val);
void seq_alsa_reverb (gint chan, gint val);

#endif /* #ifdef ALSA_SUPPORT */

#endif /* __SEQ_ALSA_H__ */
