/*==================================================================
 * wavetable.h - Header for wavetable routines (independent of device)
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __WAVETABLE_H__
#define __WAVETABLE_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include "sfont.h"
#include "vbank.h"

enum
{ WTBL_NONE,
#ifdef AWE_SUPPORT
  WTBL_AWE,
#endif
  WTBL_COUNT
} WTblDriverType;

typedef enum
{
  WTBL_ITEM_CHANGE,
  WTBL_ITEM_DELETE
} WTblItemChange;

/* wavetable driver information and function pointers */
typedef struct
{
  char *name;			/* textual name of driver */
  gint (*init) (void);
  void (*close) (void);
  void (*effect) (gint chan, guint16 genid, SFGenAmount amt);
  gint (*open_patch) (gboolean locksamples);
  gint (*close_patch) (void);
  gint (*load_sample) (SFSample *sam, SFData *sf);
  gint (*load_patch_info) (gint bank, gint prenum, SFGenAmount *gens,
			   SFSample *sam, SFData *sf, gboolean replace);
  gint (*clear_samples) (void);
  gint (*clear_unlocked_samples) (void);
  void (*clear_sample_patch_id) (SFSample *sam, gboolean locked);
  gint (*mem_avail) (void);
  gint (*samdata_mem_required) (SFSample *sam, SFData *sf, gboolean usecache,
				gboolean locked);
} WTblDriverInfo;

extern WTblDriverInfo wtbl_drivers[];	/* array of wavetable driver info */

gint wtbl_driver;
gboolean wtbl_active;
gchar *wtbl_oss_devname;
gboolean wtbl_loop_sam_as_inst;
gboolean wtbl_sample_cache_support;
gboolean wtbl_cache_samples;
gboolean wtbl_recursive_bank_refresh;

SFItemID wtbl_temp_audible;
gboolean wtbl_temp_audible_changed;
GList *wtbl_temp_audible_muted_zones;
SFItemID wtbl_loaded_sfbank;

gint wtbl_init_from_config (void);
void wtbl_set_driver (guint drvr_id);
gint wtbl_locate_byname (gchar *name);

void wtbl_sfitem_changed (SFItemID itemid, WTblItemChange change);
void wtbl_note_on_notify (void);

gint wtbl_assign_patch_id (SFSample *sam);

gint wtbl_init (void);
void wtbl_close (void);
void wtbl_set_effect (gint chan, guint16 genid, SFGenAmount amt);
gint wtbl_load_sfont (SFData *sf);
gint wtbl_load_vbank (VBnkData *vbnk);
gint wtbl_load_temp_preset (SFPreset *pset, SFData *sf);
gint wtbl_load_temp_inst (SFInst *inst, SFData *sf);
gint wtbl_load_temp_sam_as_inst (SFSample *sam, SFData *sf);

gint wtbl_open_patch (gboolean locksamples);
gint wtbl_close_patch (void);
gint wtbl_load_sample (SFSample *sam, SFData *sf);
gint wtbl_load_patch_info (gint bank, gint prenum, SFGenAmount *gens,
			   SFSample *sam, SFData *sf, gboolean replace);
gint wtbl_clear_samples (void);
gint wtbl_clear_unlocked_samples (void);
void wtbl_clear_sample_patch_id (SFSample *sam, gboolean locked);
gint wtbl_enable_sample_locking (gboolean lock);

gint wtbl_mem_avail (void);
gint wtbl_samdata_mem_required (SFSample *sam, SFData *sf, gboolean usecache,
				gboolean locked);

#endif	/* __WAVETABLE_H__ */
