/*
 * This file is part of the sn package.
 * Distribution of sn is covered by the GNU GPL. See file COPYING.
 * Copyright  1998-2000 Harold Tay.
 * Copyright  2000- Patrik Rdman.
 */

#ifndef FORMAT_H
#define FORMAT_H

#include <stdarg.h>

/*
 * Formatting like printf(3).  Not all format specs are supported,
 * in particular, no field specs allowed.
 */

/* Print integer into tmp, returns pointer to start of it */

extern char *istr (int i, int base, char tmp[40]);
extern char *uistr (unsigned int u, int base, char tmp[40]);

/* Returns string based on format character c.  length of string,
which may NOT be null terminated, is in *len. */

extern char *vachar (int c, va_list * app, char tmp[40], int *len);

/* 2 forms, like snprintf */

extern int formatv (char *buf, int size, char *fmt, va_list ap);
extern int formats (char *buf, int size, char *fmt, ...);

#endif
