/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include <string.h>
#include "ag_defs.h"
#include "errorstring.h"


extern AgError errState;


void 
str_error(gchar *str)
{
	switch(errState.state) {
	case SYN_ERROR:
		strcpy(str,gettext("syn error!"));
		break;
	case UNCLOSED_PAREN:
		strcpy(str,gettext("unclosed paren!"));
		break;
	case UNDEFINED_RESULT:
		strcpy(str,gettext("undefined result!"));
		break;
	case INFINITE_RESULT:
		strcpy(str,gettext("infinite result!"));
		break;
	case AG_OVERFLOW:
		strcpy(str,gettext("overflow!"));
		break;
	case MISSING_ARGUMENT:
		strcpy(str,gettext("missing argument!"));
		break;
	case FACTORIAL_NOT_INT:
		strcpy(str,gettext("factorial not an integer!"));
		break;
	case FACTORIAL_NOT_POSITIVE:
		strcpy(str,gettext("factorial not positive!"));
		break;
	case LOGIC_NOT_POSITIVE:
		strcpy(str,gettext("logical operator argument negative!"));
		break;		
	}
}

