/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick         
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __HANDLERS_H__
#define __HANDLERS_H__

#include <gtk/gtk.h>


void
ag_handler_ans(gpointer data);

void
ag_handler_cursor_forward(gpointer data);


void
ag_handler_cursor_backward(gpointer data);


void
ag_handler_hstack_up(gpointer data);


void
ag_handler_hstack_down(gpointer data);

/*
 * ag_recalc_expr
 * recalculates current expression
 */
void
ag_recalc_expr();

/*
 * ag_get_expr_n_eval
 * gets the expression from the text, sends it to the solving
 * functions, and then displays the formated result.
 * It also redraws the expression, with the special atributes
 * (error hilighting) when needed.
 */
void 
ag_get_expr_n_eval();



/*
 * ag_keypath_handler
 * handles the action of some keytable buttons,
 * for each button a special action, the default
 * is writing to the input text. A pointer to 
 * this function is passed to the function
 * make_keytable
 */
void
ag_keypath_handler(gpointer data);



/*
 * ag_handle_keyboard_input
 */
void
ag_handle_keyboard_input (GtkWidget        *widget,
			  GdkEventKey      *event,
			  void             *data);


#endif /* __HANDLERS_H__ */
