;;; GL spectrograph Snd hook
;;;
;;; file of data has: srate scaler cutoff slices bins followed by data[slices][bins] all float
;;; data file is "glfft.data" written first, then "glfft.lock" is created.
;;;   reader waits for glfft.lock, then reads glfft.data and deletes both
;;;   if writer sees lock file, returns without writing
;;;   if reader doesn't see lock file, returns without reading
;;; to use this, start glfft, load this file, set fft type to spectrogram, (start-gl)

(use-modules (ice-9 format))

(define data-file "glfft.data")
(define lock-file "glfft.lock")

(define write-fft-data 
  (lambda (snd chn scaler)
    (let ((selsnd (selected-sound))
	  (selchn (selected-channel snd)))
      (if (and (= (transform-graph-type) graph-transform-as-spectrogram)
	       (or (= selsnd -1) (= selsnd snd))
	       (or (= selchn -1) (= selchn chn))
	       (not (file-exists? lock-file)))
	  (let ((data (transform-samples->vct snd chn))
		(sizes (cons (srate) (cons scaler (transform-samples-size snd chn))))
		(fd (mus-sound-open-output data-file 1 1 mus-bfloat mus-raw "")))
	    (if (not (vct? data))
		(snd-error (format #f "fft-data: ~A?" data)))
	    (if (not (= fd -1))
		(let ((desc (list->vct sizes)))
		  (vct->sound-file fd desc 5)
		  (vct->sound-file fd data (vct-length data))
		  (mus-sound-close-output fd 0)
		  (set! fd (mus-sound-open-output lock-file 1 1 mus-bfloat mus-raw ""))
		  (mus-sound-close-output fd 0))
		(snd-error (format #f "can't open ~S?" data-file)))))
      #f)))

(define start-gl
  (lambda ()
    (add-hook! transform-hook write-fft-data)))

(define stop-gl 
  (lambda ()
    (remove-hook! transform-hook write-fft-data)))

(define cleanup-gl 
  (lambda ()
    (stop-gl)
    (if (file-exists? lock-file) (delete-file lock-file))
    (if (file-exists? data-file) (delete-file data-file))))

		
